/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.helpers;

import androidx.annotation.NonNull;
import io.reactivex.Emitter;
import io.reactivex.Flowable;
import io.reactivex.functions.Consumer;
import java.nio.ByteBuffer;
import org.reactivestreams.Subscriber;

public class ByteArrayBatchObservable
extends Flowable<byte[]> {
    @NonNull
    private final ByteBuffer byteBuffer;
    private final int maxBatchSize;

    public ByteArrayBatchObservable(@NonNull byte[] bytes, int maxBatchSize) {
        if (maxBatchSize <= 0) {
            throw new IllegalArgumentException("maxBatchSize must be > 0 but found: " + maxBatchSize);
        }
        this.byteBuffer = ByteBuffer.wrap(bytes);
        this.maxBatchSize = maxBatchSize;
    }

    protected void subscribeActual(Subscriber<? super byte[]> subscriber) {
        Flowable.generate((Consumer)new Consumer<Emitter<byte[]>>(){

            public void accept(Emitter<byte[]> emitter) throws Exception {
                int nextBatchSize = Math.min(ByteArrayBatchObservable.this.byteBuffer.remaining(), ByteArrayBatchObservable.this.maxBatchSize);
                if (nextBatchSize == 0) {
                    emitter.onComplete();
                    return;
                }
                byte[] nextBatch = new byte[nextBatchSize];
                ByteArrayBatchObservable.this.byteBuffer.get(nextBatch);
                emitter.onNext((Object)nextBatch);
            }
        }).subscribe(subscriber);
    }
}

