/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.connection;

import android.bluetooth.BluetoothGatt;
import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import com.polidea.rxandroidble2.ConnectionSetup;
import com.polidea.rxandroidble2.RxBleConnection;
import com.polidea.rxandroidble2.internal.connection.ConnectionComponent;
import com.polidea.rxandroidble2.internal.connection.ConnectionSubscriptionWatcher;
import com.polidea.rxandroidble2.internal.connection.Connector;
import com.polidea.rxandroidble2.internal.serialization.ClientOperationQueue;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import java.util.Set;
import java.util.concurrent.Callable;

public class ConnectorImpl
implements Connector {
    private final ClientOperationQueue clientOperationQueue;
    private final ConnectionComponent.Builder connectionComponentBuilder;
    private final Scheduler callbacksScheduler;

    @Inject
    public ConnectorImpl(ClientOperationQueue clientOperationQueue, ConnectionComponent.Builder connectionComponentBuilder, @Named(value="bluetooth_callbacks") Scheduler callbacksScheduler) {
        this.clientOperationQueue = clientOperationQueue;
        this.connectionComponentBuilder = connectionComponentBuilder;
        this.callbacksScheduler = callbacksScheduler;
    }

    @Override
    public Observable<RxBleConnection> prepareConnection(final ConnectionSetup options) {
        return Observable.defer((Callable)new Callable<ObservableSource<RxBleConnection>>(){

            @Override
            public ObservableSource<RxBleConnection> call() throws Exception {
                ConnectionComponent connectionComponent = ConnectorImpl.this.connectionComponentBuilder.autoConnect(options.autoConnect).suppressOperationChecks(options.suppressOperationCheck).operationTimeout(options.operationTimeout).build();
                final Set<ConnectionSubscriptionWatcher> connSubWatchers = connectionComponent.connectionSubscriptionWatchers();
                return ConnectorImpl.obtainRxBleConnection(connectionComponent).mergeWith((ObservableSource)ConnectorImpl.observeDisconnections(connectionComponent)).delaySubscription((ObservableSource)ConnectorImpl.this.enqueueConnectOperation(connectionComponent)).doOnSubscribe((Consumer)new Consumer<Disposable>(){

                    public void accept(Disposable disposable) throws Exception {
                        for (ConnectionSubscriptionWatcher csa : connSubWatchers) {
                            csa.onConnectionSubscribed();
                        }
                    }
                }).doFinally(new Action(){

                    public void run() throws Exception {
                        for (ConnectionSubscriptionWatcher csa : connSubWatchers) {
                            csa.onConnectionUnsubscribed();
                        }
                    }
                }).subscribeOn(ConnectorImpl.this.callbacksScheduler).unsubscribeOn(ConnectorImpl.this.callbacksScheduler);
            }
        });
    }

    private static Observable<RxBleConnection> obtainRxBleConnection(final ConnectionComponent connectionComponent) {
        return Observable.fromCallable((Callable)new Callable<RxBleConnection>(){

            @Override
            public RxBleConnection call() throws Exception {
                return connectionComponent.rxBleConnection();
            }
        });
    }

    private static Observable<RxBleConnection> observeDisconnections(ConnectionComponent connectionComponent) {
        return connectionComponent.gattCallback().observeDisconnect();
    }

    private Observable<BluetoothGatt> enqueueConnectOperation(ConnectionComponent connectionComponent) {
        return this.clientOperationQueue.queue(connectionComponent.connectOperation());
    }
}

