/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.connection;

import androidx.annotation.RestrictTo;
import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import com.polidea.rxandroidble2.RxBleConnection;
import com.polidea.rxandroidble2.internal.connection.ConnectionScope;
import com.polidea.rxandroidble2.internal.connection.PayloadSizeLimitProvider;

@ConnectionScope
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class MtuBasedPayloadSizeLimit
implements PayloadSizeLimitProvider {
    private final RxBleConnection rxBleConnection;
    private final int gattWriteMtuOverhead;

    @Inject
    MtuBasedPayloadSizeLimit(RxBleConnection rxBleConnection, @Named(value="GATT_WRITE_MTU_OVERHEAD") int gattWriteMtuOverhead) {
        this.rxBleConnection = rxBleConnection;
        this.gattWriteMtuOverhead = gattWriteMtuOverhead;
    }

    @Override
    public int getPayloadSizeLimit() {
        return this.rxBleConnection.getMtu() - this.gattWriteMtuOverhead;
    }
}

