/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.connection;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import bleshadow.javax.inject.Inject;
import com.polidea.rxandroidble2.HiddenBluetoothGattCallback;

class NativeCallbackDispatcher {
    private BluetoothGattCallback nativeCallback;
    private HiddenBluetoothGattCallback nativeCallbackHidden;

    @Inject
    NativeCallbackDispatcher() {
    }

    void notifyNativeChangedCallback(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
        if (this.nativeCallback != null) {
            this.nativeCallback.onCharacteristicChanged(gatt, characteristic);
        }
    }

    void notifyNativeConnectionStateCallback(BluetoothGatt gatt, int status, int newState) {
        if (this.nativeCallback != null) {
            this.nativeCallback.onConnectionStateChange(gatt, status, newState);
        }
    }

    void notifyNativeDescriptorReadCallback(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
        if (this.nativeCallback != null) {
            this.nativeCallback.onDescriptorRead(gatt, descriptor, status);
        }
    }

    void notifyNativeDescriptorWriteCallback(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
        if (this.nativeCallback != null) {
            this.nativeCallback.onDescriptorWrite(gatt, descriptor, status);
        }
    }

    @TargetApi(value=21)
    void notifyNativeMtuChangedCallback(BluetoothGatt gatt, int mtu, int status) {
        if (this.nativeCallback != null) {
            this.nativeCallback.onMtuChanged(gatt, mtu, status);
        }
    }

    void notifyNativeReadRssiCallback(BluetoothGatt gatt, int rssi, int status) {
        if (this.nativeCallback != null) {
            this.nativeCallback.onReadRemoteRssi(gatt, rssi, status);
        }
    }

    void notifyNativeReliableWriteCallback(BluetoothGatt gatt, int status) {
        if (this.nativeCallback != null) {
            this.nativeCallback.onReliableWriteCompleted(gatt, status);
        }
    }

    void notifyNativeServicesDiscoveredCallback(BluetoothGatt gatt, int status) {
        if (this.nativeCallback != null) {
            this.nativeCallback.onServicesDiscovered(gatt, status);
        }
    }

    void notifyNativeWriteCallback(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
        if (this.nativeCallback != null) {
            this.nativeCallback.onCharacteristicWrite(gatt, characteristic, status);
        }
    }

    void notifyNativeParamsUpdateCallback(BluetoothGatt gatt, int interval, int latency, int timeout, int status) {
        if (this.nativeCallbackHidden != null) {
            this.nativeCallbackHidden.onConnectionUpdated(gatt, interval, latency, timeout, status);
        }
    }

    void setNativeCallback(BluetoothGattCallback callback) {
        this.nativeCallback = callback;
    }

    void notifyNativeReadCallback(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
        if (this.nativeCallback != null) {
            this.nativeCallback.onCharacteristicRead(gatt, characteristic, status);
        }
    }

    void setNativeCallabackHidden(HiddenBluetoothGattCallback callbackHidden) {
        this.nativeCallbackHidden = callbackHidden;
    }
}

