/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.connection;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import androidx.annotation.NonNull;
import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import com.polidea.rxandroidble2.NotificationSetupMode;
import com.polidea.rxandroidble2.exceptions.BleCannotSetCharacteristicNotificationException;
import com.polidea.rxandroidble2.exceptions.BleConflictingNotificationAlreadySetException;
import com.polidea.rxandroidble2.internal.connection.ConnectionScope;
import com.polidea.rxandroidble2.internal.connection.DescriptorWriter;
import com.polidea.rxandroidble2.internal.connection.RxBleGattCallback;
import com.polidea.rxandroidble2.internal.util.ActiveCharacteristicNotification;
import com.polidea.rxandroidble2.internal.util.CharacteristicChangedEvent;
import com.polidea.rxandroidble2.internal.util.CharacteristicNotificationId;
import com.polidea.rxandroidble2.internal.util.ObservableUtil;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.CompletableTransformer;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.functions.Action;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.functions.Functions;
import io.reactivex.subjects.PublishSubject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;

@ConnectionScope
class NotificationAndIndicationManager {
    static final UUID CLIENT_CHARACTERISTIC_CONFIG_UUID = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    private final byte[] configEnableNotification;
    private final byte[] configEnableIndication;
    private final byte[] configDisable;
    private final BluetoothGatt bluetoothGatt;
    private final RxBleGattCallback gattCallback;
    private final DescriptorWriter descriptorWriter;
    private final Map<CharacteristicNotificationId, ActiveCharacteristicNotification> activeNotificationObservableMap = new HashMap<CharacteristicNotificationId, ActiveCharacteristicNotification>();

    @Inject
    NotificationAndIndicationManager(@Named(value="enable-notification-value") byte[] configEnableNotification, @Named(value="enable-indication-value") byte[] configEnableIndication, @Named(value="disable-notification-value") byte[] configDisable, BluetoothGatt bluetoothGatt, RxBleGattCallback gattCallback, DescriptorWriter descriptorWriter) {
        this.configEnableNotification = configEnableNotification;
        this.configEnableIndication = configEnableIndication;
        this.configDisable = configDisable;
        this.bluetoothGatt = bluetoothGatt;
        this.gattCallback = gattCallback;
        this.descriptorWriter = descriptorWriter;
    }

    Observable<Observable<byte[]>> setupServerInitiatedCharacteristicRead(final @NonNull BluetoothGattCharacteristic characteristic, final NotificationSetupMode setupMode, final boolean isIndication) {
        return Observable.defer((Callable)new Callable<ObservableSource<Observable<byte[]>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ObservableSource<Observable<byte[]>> call() {
                Map map = NotificationAndIndicationManager.this.activeNotificationObservableMap;
                synchronized (map) {
                    final CharacteristicNotificationId id = new CharacteristicNotificationId(characteristic.getUuid(), characteristic.getInstanceId());
                    ActiveCharacteristicNotification activeCharacteristicNotification = (ActiveCharacteristicNotification)NotificationAndIndicationManager.this.activeNotificationObservableMap.get((Object)id);
                    if (activeCharacteristicNotification != null) {
                        if (activeCharacteristicNotification.isIndication == isIndication) {
                            return activeCharacteristicNotification.notificationObservable;
                        }
                        return Observable.error((Throwable)new BleConflictingNotificationAlreadySetException(characteristic.getUuid(), !isIndication));
                    }
                    byte[] enableNotificationTypeValue = isIndication ? NotificationAndIndicationManager.this.configEnableIndication : NotificationAndIndicationManager.this.configEnableNotification;
                    final PublishSubject notificationCompletedSubject = PublishSubject.create();
                    Observable newObservable = NotificationAndIndicationManager.setCharacteristicNotification(NotificationAndIndicationManager.this.bluetoothGatt, characteristic, true).andThen(ObservableUtil.justOnNext(NotificationAndIndicationManager.observeOnCharacteristicChangeCallbacks(NotificationAndIndicationManager.this.gattCallback, id))).compose(NotificationAndIndicationManager.setupModeTransformer(NotificationAndIndicationManager.this.descriptorWriter, characteristic, enableNotificationTypeValue, setupMode)).map((Function)new Function<Observable<byte[]>, Observable<byte[]>>(){

                        public Observable<byte[]> apply(Observable<byte[]> observable) {
                            return Observable.amb(Arrays.asList(notificationCompletedSubject.cast(byte[].class), observable.takeUntil((ObservableSource)notificationCompletedSubject)));
                        }
                    }).doFinally(new Action(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @SuppressLint(value={"CheckResult"})
                        public void run() {
                            notificationCompletedSubject.onComplete();
                            Map map = NotificationAndIndicationManager.this.activeNotificationObservableMap;
                            synchronized (map) {
                                NotificationAndIndicationManager.this.activeNotificationObservableMap.remove((Object)id);
                            }
                            NotificationAndIndicationManager.setCharacteristicNotification(NotificationAndIndicationManager.this.bluetoothGatt, characteristic, false).compose(NotificationAndIndicationManager.teardownModeTransformer(NotificationAndIndicationManager.this.descriptorWriter, characteristic, NotificationAndIndicationManager.this.configDisable, setupMode)).subscribe(Functions.EMPTY_ACTION, Functions.emptyConsumer());
                        }
                    }).mergeWith(NotificationAndIndicationManager.this.gattCallback.observeDisconnect()).replay(1).refCount();
                    NotificationAndIndicationManager.this.activeNotificationObservableMap.put(id, new ActiveCharacteristicNotification((Observable<Observable<byte[]>>)newObservable, isIndication));
                    return newObservable;
                }
            }
        });
    }

    @NonNull
    private static Completable setCharacteristicNotification(final BluetoothGatt bluetoothGatt, final BluetoothGattCharacteristic characteristic, final boolean isNotificationEnabled) {
        return Completable.fromAction((Action)new Action(){

            public void run() {
                if (!bluetoothGatt.setCharacteristicNotification(characteristic, isNotificationEnabled)) {
                    throw new BleCannotSetCharacteristicNotificationException(characteristic, 1, null);
                }
            }
        });
    }

    @NonNull
    private static ObservableTransformer<Observable<byte[]>, Observable<byte[]>> setupModeTransformer(final DescriptorWriter descriptorWriter, final BluetoothGattCharacteristic characteristic, final byte[] value, final NotificationSetupMode mode) {
        return new ObservableTransformer<Observable<byte[]>, Observable<byte[]>>(){

            public ObservableSource<Observable<byte[]>> apply(Observable<Observable<byte[]>> upstream) {
                switch (mode) {
                    case COMPAT: {
                        return upstream;
                    }
                    case QUICK_SETUP: {
                        final Completable publishedWriteCCCDesc = NotificationAndIndicationManager.writeClientCharacteristicConfig(characteristic, descriptorWriter, value).toObservable().publish().autoConnect(2).ignoreElements();
                        return upstream.mergeWith((CompletableSource)publishedWriteCCCDesc).map((Function)new Function<Observable<byte[]>, Observable<byte[]>>(){

                            public Observable<byte[]> apply(Observable<byte[]> observable) {
                                return observable.mergeWith((CompletableSource)publishedWriteCCCDesc.onErrorComplete());
                            }
                        });
                    }
                }
                return NotificationAndIndicationManager.writeClientCharacteristicConfig(characteristic, descriptorWriter, value).andThen(upstream);
            }
        };
    }

    @NonNull
    private static CompletableTransformer teardownModeTransformer(final DescriptorWriter descriptorWriter, final BluetoothGattCharacteristic characteristic, final byte[] value, final NotificationSetupMode mode) {
        return new CompletableTransformer(){

            public Completable apply(Completable completable) {
                if (mode == NotificationSetupMode.COMPAT) {
                    return completable;
                }
                return completable.andThen((CompletableSource)NotificationAndIndicationManager.writeClientCharacteristicConfig(characteristic, descriptorWriter, value));
            }
        };
    }

    @NonNull
    private static Observable<byte[]> observeOnCharacteristicChangeCallbacks(RxBleGattCallback gattCallback, final CharacteristicNotificationId characteristicId) {
        return gattCallback.getOnCharacteristicChanged().filter((Predicate)new Predicate<CharacteristicChangedEvent>(){

            public boolean test(CharacteristicChangedEvent notificationIdWithData) {
                return notificationIdWithData.equals((Object)characteristicId);
            }
        }).map((Function)new Function<CharacteristicChangedEvent, byte[]>(){

            public byte[] apply(CharacteristicChangedEvent notificationIdWithData) {
                return notificationIdWithData.data;
            }
        });
    }

    @NonNull
    private static Completable writeClientCharacteristicConfig(final BluetoothGattCharacteristic bluetoothGattCharacteristic, DescriptorWriter descriptorWriter, byte[] value) {
        BluetoothGattDescriptor descriptor = bluetoothGattCharacteristic.getDescriptor(CLIENT_CHARACTERISTIC_CONFIG_UUID);
        if (descriptor == null) {
            return Completable.error((Throwable)new BleCannotSetCharacteristicNotificationException(bluetoothGattCharacteristic, 2, null));
        }
        return descriptorWriter.writeDescriptor(descriptor, value).onErrorResumeNext((Function)new Function<Throwable, CompletableSource>(){

            public CompletableSource apply(Throwable throwable) {
                return Completable.error((Throwable)new BleCannotSetCharacteristicNotificationException(bluetoothGattCharacteristic, 3, throwable));
            }
        });
    }
}

