/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.logger;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import com.polidea.rxandroidble2.internal.RxBleLog;
import com.polidea.rxandroidble2.internal.operations.Operation;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;

public class LoggerUtil {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    private LoggerUtil() {
    }

    public static String bytesToHex(byte[] bytes) {
        int j;
        if (bytes == null) {
            return String.valueOf(null);
        }
        if (!RxBleLog.getShouldLogAttributeValues()) {
            return "[...]";
        }
        int byteArrayLength = bytes.length;
        if (byteArrayLength == 0) {
            return "[]";
        }
        int byteCharsLength = byteArrayLength * 2;
        int delimiterCount = byteArrayLength - 1;
        int delimiterCharsLength = delimiterCount * 2;
        int arrayBorderLength = 2;
        char[] hexChars = new char[byteCharsLength + delimiterCharsLength + arrayBorderLength];
        for (j = 0; j < byteArrayLength; ++j) {
            int v = bytes[j] & 0xFF;
            int i = j * 2 + 1 + j * 2;
            hexChars[i] = HEX_ARRAY[v >>> 4];
            hexChars[i + 1] = HEX_ARRAY[v & 0xF];
        }
        for (j = 0; j < byteArrayLength - 1; ++j) {
            int i = j * 2 + 1 + j * 2 + 2;
            hexChars[i] = 44;
            hexChars[i + 1] = 32;
        }
        hexChars[0] = 91;
        hexChars[hexChars.length - 1] = 93;
        return new String(hexChars);
    }

    public static void logOperationStarted(Operation operation) {
        if (RxBleLog.isAtLeast(3)) {
            RxBleLog.d("STARTED  %s(%d)", operation.getClass().getSimpleName(), System.identityHashCode(operation));
        }
    }

    public static void logOperationRunning(Operation operation) {
        RxBleLog.i("RUNNING  %s", operation);
    }

    public static void logOperationRemoved(Operation operation) {
        if (RxBleLog.isAtLeast(3)) {
            RxBleLog.d("REMOVED  %s(%d)", operation.getClass().getSimpleName(), System.identityHashCode(operation));
        }
    }

    public static void logOperationQueued(Operation operation) {
        if (RxBleLog.isAtLeast(3)) {
            RxBleLog.d("QUEUED   %s(%d)", operation.getClass().getSimpleName(), System.identityHashCode(operation));
        }
    }

    public static void logOperationFinished(Operation operation, long startTime, long endTime) {
        if (RxBleLog.isAtLeast(3)) {
            RxBleLog.d("FINISHED %s(%d) in %d ms", operation.getClass().getSimpleName(), System.identityHashCode(operation), endTime - startTime);
        }
    }

    public static void logOperationSkippedBecauseDisposedWhenAboutToRun(Operation operation) {
        if (RxBleLog.isAtLeast(2)) {
            RxBleLog.v("SKIPPED  %s(%d) just before running \u2014 is disposed", operation.getClass().getSimpleName(), System.identityHashCode(operation));
        }
    }

    public static void logCallback(String callbackName, BluetoothGatt gatt, int status, BluetoothGattCharacteristic characteristic, boolean valueMatters) {
        if (!RxBleLog.isAtLeast(4)) {
            return;
        }
        AttributeLogWrapper value = new AttributeLogWrapper(characteristic.getUuid(), characteristic.getValue(), valueMatters);
        RxBleLog.i(LoggerUtil.commonMacMessage(gatt) + LoggerUtil.commonCallbackMessage() + LoggerUtil.commonStatusMessage() + LoggerUtil.commonValueMessage(), callbackName, status, value);
    }

    public static void logCallback(String callbackName, BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, boolean valueMatters) {
        if (!RxBleLog.isAtLeast(4)) {
            return;
        }
        AttributeLogWrapper value = new AttributeLogWrapper(characteristic.getUuid(), characteristic.getValue(), valueMatters);
        RxBleLog.i(LoggerUtil.commonMacMessage(gatt) + LoggerUtil.commonCallbackMessage() + LoggerUtil.commonValueMessage(), callbackName, value);
    }

    public static void logCallback(String callbackName, BluetoothGatt gatt, int status, BluetoothGattDescriptor descriptor, boolean valueMatters) {
        if (!RxBleLog.isAtLeast(4)) {
            return;
        }
        AttributeLogWrapper value = new AttributeLogWrapper(descriptor.getUuid(), descriptor.getValue(), valueMatters);
        RxBleLog.i(LoggerUtil.commonMacMessage(gatt) + LoggerUtil.commonCallbackMessage() + LoggerUtil.commonStatusMessage() + LoggerUtil.commonValueMessage(), callbackName, status, value);
    }

    public static void logCallback(String callbackName, BluetoothGatt gatt, int status) {
        if (!RxBleLog.isAtLeast(4)) {
            return;
        }
        RxBleLog.i(LoggerUtil.commonMacMessage(gatt) + LoggerUtil.commonCallbackMessage() + LoggerUtil.commonStatusMessage(), callbackName, status);
    }

    public static void logCallback(String callbackName, BluetoothGatt gatt, int status, int value) {
        if (!RxBleLog.isAtLeast(4)) {
            return;
        }
        RxBleLog.i(LoggerUtil.commonMacMessage(gatt) + LoggerUtil.commonCallbackMessage() + LoggerUtil.commonStatusMessage() + LoggerUtil.commonValueMessage(), callbackName, status, value);
    }

    public static void logConnectionUpdateCallback(String callbackName, BluetoothGatt gatt, int status, int interval, int latency, int timeout) {
        if (!RxBleLog.isAtLeast(4)) {
            return;
        }
        String customValueMessage = ", interval=%d (%.2f ms), latency=%d, timeout=%d (%.0f ms)";
        RxBleLog.i(LoggerUtil.commonMacMessage(gatt) + LoggerUtil.commonCallbackMessage() + LoggerUtil.commonStatusMessage() + customValueMessage, callbackName, status, interval, Float.valueOf((float)interval * 1.25f), latency, timeout, Float.valueOf((float)timeout * 10.0f));
    }

    public static String commonMacMessage(BluetoothGatt gatt) {
        if (gatt == null) {
            return "MAC=null";
        }
        return LoggerUtil.commonMacMessage(gatt.getDevice().getAddress());
    }

    public static String commonMacMessage(String macAddress) {
        if (macAddress == null) {
            return "MAC=null";
        }
        int logSetting = RxBleLog.getMacAddressLogSetting();
        switch (logSetting) {
            case 3: {
                macAddress = macAddress.substring(0, 15) + "XX";
                break;
            }
            case 0x7FFFFFFF: {
                macAddress = "XX:XX:XX:XX:XX:XX";
            }
        }
        return String.format("MAC='%s'", macAddress);
    }

    private static String commonCallbackMessage() {
        return " %24s()";
    }

    private static String commonStatusMessage() {
        return ", status=%d";
    }

    private static String commonValueMessage() {
        return ", value=%s";
    }

    public static AttributeLogWrapper wrap(BluetoothGattCharacteristic characteristic, boolean valueMatters) {
        return new AttributeLogWrapper(characteristic.getUuid(), characteristic.getValue(), valueMatters);
    }

    public static AttributeLogWrapper wrap(BluetoothGattDescriptor descriptor, boolean valueMatters) {
        return new AttributeLogWrapper(descriptor.getUuid(), descriptor.getValue(), valueMatters);
    }

    public static String getUuidToLog(UUID uuid) {
        int uuidLogSetting = RxBleLog.getUuidLogSetting();
        if (uuidLogSetting == 2) {
            return uuid.toString();
        }
        return "...";
    }

    public static String getUuidSetToLog(Set<UUID> uuidSet) {
        int size = uuidSet.size();
        Object[] uuids = new String[size];
        Iterator<UUID> iterator = uuidSet.iterator();
        for (int i = 0; i < size; ++i) {
            String uuidToLog = LoggerUtil.getUuidToLog(iterator.next());
            uuids[i] = uuidToLog;
        }
        return Arrays.toString(uuids);
    }

    public static class AttributeLogWrapper {
        private final UUID uuid;
        private final byte[] value;
        private final boolean valueMatters;

        public AttributeLogWrapper(UUID uuid, byte[] value, boolean valueMatters) {
            this.uuid = uuid;
            this.value = value;
            this.valueMatters = valueMatters;
        }

        public String toString() {
            return "[uuid='" + LoggerUtil.getUuidToLog(this.uuid) + (this.valueMatters ? "', hexValue=" + LoggerUtil.bytesToHex(this.value) : "'") + ']';
        }
    }
}

