/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.logger;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import bleshadow.javax.inject.Inject;
import com.polidea.rxandroidble2.RxBleDeviceServices;
import com.polidea.rxandroidble2.internal.RxBleLog;
import com.polidea.rxandroidble2.internal.logger.LoggerUtil;
import com.polidea.rxandroidble2.internal.util.CharacteristicPropertiesParser;
import com.polidea.rxandroidble2.utils.StandardUUIDsParser;

public class LoggerUtilBluetoothServices {
    private final CharacteristicPropertiesParser characteristicPropertiesParser;

    @Inject
    LoggerUtilBluetoothServices(CharacteristicPropertiesParser characteristicPropertiesParser) {
        this.characteristicPropertiesParser = characteristicPropertiesParser;
    }

    public void log(RxBleDeviceServices rxBleDeviceServices, BluetoothDevice device) {
        if (RxBleLog.isAtLeast(2)) {
            RxBleLog.v("Preparing services description", new Object[0]);
            RxBleLog.v(this.prepareServicesDescription(rxBleDeviceServices, device), new Object[0]);
        }
    }

    private String prepareServicesDescription(RxBleDeviceServices rxBleDeviceServices, BluetoothDevice device) {
        StringBuilder descriptionBuilder = new StringBuilder();
        this.appendDeviceHeader(device, descriptionBuilder);
        for (BluetoothGattService bluetoothGattService : rxBleDeviceServices.getBluetoothGattServices()) {
            descriptionBuilder.append('\n');
            this.appendServiceDescription(descriptionBuilder, bluetoothGattService);
        }
        descriptionBuilder.append("\n--------------- ====== Finished peripheral content ====== ---------------");
        return descriptionBuilder.toString();
    }

    private void appendServiceDescription(StringBuilder descriptionBuilder, BluetoothGattService bluetoothGattService) {
        this.appendServiceHeader(descriptionBuilder, bluetoothGattService);
        descriptionBuilder.append("-> Characteristics:");
        for (BluetoothGattCharacteristic characteristic : bluetoothGattService.getCharacteristics()) {
            this.appendCharacteristicNameHeader(descriptionBuilder, characteristic);
            this.appendCharacteristicProperties(descriptionBuilder, characteristic);
            this.appendDescriptors(descriptionBuilder, characteristic);
        }
    }

    private void appendDescriptors(StringBuilder descriptionBuilder, BluetoothGattCharacteristic characteristic) {
        if (!characteristic.getDescriptors().isEmpty()) {
            this.appendDescriptorsHeader(descriptionBuilder);
            for (BluetoothGattDescriptor descriptor : characteristic.getDescriptors()) {
                this.appendDescriptorNameHeader(descriptionBuilder, descriptor);
            }
        }
    }

    private void appendDescriptorsHeader(StringBuilder descriptionBuilder) {
        descriptionBuilder.append('\n').append('\t').append("  ").append("-> Descriptors: ");
    }

    private void appendCharacteristicNameHeader(StringBuilder descriptionBuilder, BluetoothGattCharacteristic characteristic) {
        descriptionBuilder.append('\n').append('\t').append("* ").append(this.createCharacteristicName(characteristic)).append(" (").append(LoggerUtil.getUuidToLog(characteristic.getUuid())).append(")");
    }

    private void appendDescriptorNameHeader(StringBuilder descriptionBuilder, BluetoothGattDescriptor descriptor) {
        descriptionBuilder.append('\n').append('\t').append('\t').append("* ").append(this.createDescriptorName(descriptor)).append(" (").append(LoggerUtil.getUuidToLog(descriptor.getUuid())).append(")");
    }

    private String createDescriptorName(BluetoothGattDescriptor descriptor) {
        String descriptorName = StandardUUIDsParser.getDescriptorName(descriptor.getUuid());
        return descriptorName == null ? "Unknown descriptor" : descriptorName;
    }

    private void appendCharacteristicProperties(StringBuilder descriptionBuilder, BluetoothGattCharacteristic characteristic) {
        descriptionBuilder.append('\n').append('\t').append("  ").append("Properties: ").append(this.characteristicPropertiesParser.propertiesIntToString(characteristic.getProperties()));
    }

    private String createCharacteristicName(BluetoothGattCharacteristic characteristic) {
        String characteristicName = StandardUUIDsParser.getCharacteristicName(characteristic.getUuid());
        return characteristicName == null ? "Unknown characteristic" : characteristicName;
    }

    private void appendDeviceHeader(BluetoothDevice device, StringBuilder descriptionBuilder) {
        descriptionBuilder.append("--------------- ====== Printing peripheral content ====== ---------------\n").append(LoggerUtil.commonMacMessage(device.getAddress())).append('\n').append("PERIPHERAL NAME: ").append(device.getName()).append('\n').append("-------------------------------------------------------------------------");
    }

    private void appendServiceHeader(StringBuilder descriptionBuilder, BluetoothGattService bluetoothGattService) {
        descriptionBuilder.append("\n").append(this.createServiceType(bluetoothGattService)).append(" - ").append(this.createServiceName(bluetoothGattService)).append(" (").append(LoggerUtil.getUuidToLog(bluetoothGattService.getUuid())).append(")\n").append("Instance ID: ").append(bluetoothGattService.getInstanceId()).append('\n');
    }

    private String createServiceName(BluetoothGattService bluetoothGattService) {
        String serviceName = StandardUUIDsParser.getServiceName(bluetoothGattService.getUuid());
        return serviceName == null ? "Unknown service" : serviceName;
    }

    private String createServiceType(BluetoothGattService bluetoothGattService) {
        if (bluetoothGattService.getType() == 0) {
            return "Primary Service";
        }
        return "Secondary Service";
    }
}

