/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.operations;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import androidx.annotation.NonNull;
import com.polidea.rxandroidble2.internal.RxBleLog;
import com.polidea.rxandroidble2.internal.logger.LoggerUtil;
import com.polidea.rxandroidble2.internal.operations.ScanOperation;
import com.polidea.rxandroidble2.internal.scan.EmulatedScanFilterMatcher;
import com.polidea.rxandroidble2.internal.scan.InternalScanResultCreator;
import com.polidea.rxandroidble2.internal.scan.RxBleInternalScanResult;
import com.polidea.rxandroidble2.internal.util.RxBleAdapterWrapper;
import io.reactivex.ObservableEmitter;

public class ScanOperationApi18
extends ScanOperation<RxBleInternalScanResult, BluetoothAdapter.LeScanCallback> {
    @NonNull
    private final InternalScanResultCreator scanResultCreator;
    @NonNull
    private final EmulatedScanFilterMatcher scanFilterMatcher;

    public ScanOperationApi18(@NonNull RxBleAdapterWrapper rxBleAdapterWrapper, @NonNull InternalScanResultCreator scanResultCreator, @NonNull EmulatedScanFilterMatcher scanFilterMatcher) {
        super(rxBleAdapterWrapper);
        this.scanResultCreator = scanResultCreator;
        this.scanFilterMatcher = scanFilterMatcher;
    }

    @Override
    BluetoothAdapter.LeScanCallback createScanCallback(final ObservableEmitter<RxBleInternalScanResult> emitter) {
        return new BluetoothAdapter.LeScanCallback(){

            public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
                if (!ScanOperationApi18.this.scanFilterMatcher.isEmpty() && RxBleLog.isAtLeast(3) && RxBleLog.getShouldLogScannedPeripherals()) {
                    RxBleLog.d("%s, name=%s, rssi=%d, data=%s", LoggerUtil.commonMacMessage(device.getAddress()), device.getName(), rssi, LoggerUtil.bytesToHex(scanRecord));
                }
                RxBleInternalScanResult internalScanResult = ScanOperationApi18.this.scanResultCreator.create(device, rssi, scanRecord);
                if (ScanOperationApi18.this.scanFilterMatcher.matches(internalScanResult)) {
                    emitter.onNext((Object)internalScanResult);
                }
            }
        };
    }

    @Override
    boolean startScan(RxBleAdapterWrapper rxBleAdapterWrapper, BluetoothAdapter.LeScanCallback scanCallback) {
        if (this.scanFilterMatcher.isEmpty()) {
            RxBleLog.d("No library side filtering \u2014> debug logs of scanned devices disabled", new Object[0]);
        }
        return rxBleAdapterWrapper.startLegacyLeScan(scanCallback);
    }

    @Override
    void stopScan(RxBleAdapterWrapper rxBleAdapterWrapper, BluetoothAdapter.LeScanCallback scanCallback) {
        rxBleAdapterWrapper.stopLegacyLeScan(scanCallback);
    }

    public String toString() {
        return "ScanOperationApi18{" + (this.scanFilterMatcher.isEmpty() ? "" : "ANY_MUST_MATCH -> " + this.scanFilterMatcher) + '}';
    }
}

