/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.operations;

import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.polidea.rxandroidble2.exceptions.BleScanException;
import com.polidea.rxandroidble2.internal.RxBleLog;
import com.polidea.rxandroidble2.internal.logger.LoggerUtil;
import com.polidea.rxandroidble2.internal.operations.ScanOperation;
import com.polidea.rxandroidble2.internal.scan.AndroidScanObjectsConverter;
import com.polidea.rxandroidble2.internal.scan.EmulatedScanFilterMatcher;
import com.polidea.rxandroidble2.internal.scan.InternalScanResultCreator;
import com.polidea.rxandroidble2.internal.scan.RxBleInternalScanResult;
import com.polidea.rxandroidble2.internal.util.RxBleAdapterWrapper;
import com.polidea.rxandroidble2.scan.ScanFilter;
import com.polidea.rxandroidble2.scan.ScanSettings;
import io.reactivex.ObservableEmitter;
import java.util.Arrays;
import java.util.List;

@RequiresApi(value=21)
public class ScanOperationApi21
extends ScanOperation<RxBleInternalScanResult, ScanCallback> {
    @NonNull
    private final InternalScanResultCreator internalScanResultCreator;
    @NonNull
    private final AndroidScanObjectsConverter androidScanObjectsConverter;
    @NonNull
    private final ScanSettings scanSettings;
    @NonNull
    private final EmulatedScanFilterMatcher emulatedScanFilterMatcher;
    @Nullable
    private final ScanFilter[] scanFilters;

    public ScanOperationApi21(@NonNull RxBleAdapterWrapper rxBleAdapterWrapper, @NonNull InternalScanResultCreator internalScanResultCreator, @NonNull AndroidScanObjectsConverter androidScanObjectsConverter, @NonNull ScanSettings scanSettings, @NonNull EmulatedScanFilterMatcher emulatedScanFilterMatcher, @Nullable ScanFilter[] offloadedScanFilters) {
        super(rxBleAdapterWrapper);
        this.internalScanResultCreator = internalScanResultCreator;
        this.scanSettings = scanSettings;
        this.emulatedScanFilterMatcher = emulatedScanFilterMatcher;
        this.scanFilters = offloadedScanFilters;
        this.androidScanObjectsConverter = androidScanObjectsConverter;
    }

    @Override
    ScanCallback createScanCallback(final ObservableEmitter<RxBleInternalScanResult> emitter) {
        return new ScanCallback(){

            public void onScanResult(int callbackType, ScanResult result) {
                if (!ScanOperationApi21.this.emulatedScanFilterMatcher.isEmpty() && RxBleLog.isAtLeast(3) && RxBleLog.getShouldLogScannedPeripherals()) {
                    ScanRecord scanRecord = result.getScanRecord();
                    RxBleLog.d("%s, name=%s, rssi=%d, data=%s", LoggerUtil.commonMacMessage(result.getDevice().getAddress()), result.getDevice().getName(), result.getRssi(), LoggerUtil.bytesToHex(scanRecord != null ? scanRecord.getBytes() : null));
                }
                RxBleInternalScanResult internalScanResult = ScanOperationApi21.this.internalScanResultCreator.create(callbackType, result);
                if (ScanOperationApi21.this.emulatedScanFilterMatcher.matches(internalScanResult)) {
                    emitter.onNext((Object)internalScanResult);
                }
            }

            public void onBatchScanResults(List<ScanResult> results) {
                for (ScanResult result : results) {
                    RxBleInternalScanResult internalScanResult = ScanOperationApi21.this.internalScanResultCreator.create(result);
                    if (!ScanOperationApi21.this.emulatedScanFilterMatcher.matches(internalScanResult)) continue;
                    emitter.onNext((Object)internalScanResult);
                }
            }

            public void onScanFailed(int errorCode) {
                emitter.tryOnError((Throwable)new BleScanException(ScanOperationApi21.errorCodeToBleErrorCode(errorCode)));
            }
        };
    }

    @Override
    boolean startScan(RxBleAdapterWrapper rxBleAdapterWrapper, ScanCallback scanCallback) {
        if (this.emulatedScanFilterMatcher.isEmpty()) {
            RxBleLog.d("No library side filtering \u2014> debug logs of scanned devices disabled", new Object[0]);
        }
        rxBleAdapterWrapper.startLeScan(this.androidScanObjectsConverter.toNativeFilters(this.scanFilters), this.androidScanObjectsConverter.toNativeSettings(this.scanSettings), scanCallback);
        return true;
    }

    @Override
    void stopScan(RxBleAdapterWrapper rxBleAdapterWrapper, ScanCallback scanCallback) {
        rxBleAdapterWrapper.stopLeScan(scanCallback);
    }

    private static int errorCodeToBleErrorCode(int errorCode) {
        switch (errorCode) {
            case 1: {
                return 5;
            }
            case 2: {
                return 6;
            }
            case 4: {
                return 8;
            }
            case 3: {
                return 7;
            }
            case 5: {
                return 9;
            }
        }
        RxBleLog.w("Encountered unknown scanning error code: %d -> check android.bluetooth.le.ScanCallback", new Object[0]);
        return Integer.MAX_VALUE;
    }

    public String toString() {
        boolean scanFiltersEmpty = this.scanFilters == null || this.scanFilters.length == 0;
        boolean emulatedScanFiltersEmpty = this.emulatedScanFilterMatcher.isEmpty();
        return "ScanOperationApi21{" + (scanFiltersEmpty ? "" : "ANY_MUST_MATCH -> nativeFilters=" + Arrays.toString(this.scanFilters)) + (!scanFiltersEmpty && !emulatedScanFiltersEmpty ? " and then " : "") + (emulatedScanFiltersEmpty ? "" : "ANY_MUST_MATCH -> " + this.emulatedScanFilterMatcher) + '}';
    }
}

