/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.scan;

import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanSettings;
import android.content.Intent;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import bleshadow.javax.inject.Inject;
import com.polidea.rxandroidble2.exceptions.BleScanException;
import com.polidea.rxandroidble2.internal.RxBleLog;
import com.polidea.rxandroidble2.internal.scan.AndroidScanObjectsConverter;
import com.polidea.rxandroidble2.internal.scan.InternalScanResultCreator;
import com.polidea.rxandroidble2.internal.scan.InternalToExternalScanResultConverter;
import com.polidea.rxandroidble2.internal.util.RxBleAdapterWrapper;
import com.polidea.rxandroidble2.scan.BackgroundScanner;
import com.polidea.rxandroidble2.scan.ScanResult;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=26)
public class BackgroundScannerImpl
implements BackgroundScanner {
    private static final int NO_ERROR = 0;
    private final RxBleAdapterWrapper rxBleAdapterWrapper;
    private final AndroidScanObjectsConverter scanObjectsConverter;
    private final InternalScanResultCreator internalScanResultCreator;
    private final InternalToExternalScanResultConverter internalToExternalScanResultConverter;

    @Inject
    BackgroundScannerImpl(RxBleAdapterWrapper rxBleAdapterWrapper, AndroidScanObjectsConverter scanObjectsConverter, InternalScanResultCreator internalScanResultCreator, InternalToExternalScanResultConverter internalToExternalScanResultConverter) {
        this.rxBleAdapterWrapper = rxBleAdapterWrapper;
        this.scanObjectsConverter = scanObjectsConverter;
        this.internalScanResultCreator = internalScanResultCreator;
        this.internalToExternalScanResultConverter = internalToExternalScanResultConverter;
    }

    @Override
    @RequiresApi(value=26)
    public void scanBleDeviceInBackground(@NonNull PendingIntent callbackIntent, com.polidea.rxandroidble2.scan.ScanSettings scanSettings, com.polidea.rxandroidble2.scan.ScanFilter ... scanFilters) {
        if (Build.VERSION.SDK_INT < 26) {
            RxBleLog.w("PendingIntent based scanning is available for Android O and higher only.", new Object[0]);
            return;
        }
        if (!this.rxBleAdapterWrapper.isBluetoothEnabled()) {
            RxBleLog.w("PendingIntent based scanning is available only when Bluetooth is ON.", new Object[0]);
            throw new BleScanException(1);
        }
        RxBleLog.i("Requesting pending intent based scan.", new Object[0]);
        List<ScanFilter> nativeScanFilters = this.scanObjectsConverter.toNativeFilters(scanFilters);
        ScanSettings nativeScanSettings = this.scanObjectsConverter.toNativeSettings(scanSettings);
        int scanStartResult = this.rxBleAdapterWrapper.startLeScan(nativeScanFilters, nativeScanSettings, callbackIntent);
        if (scanStartResult != 0) {
            BleScanException bleScanException = new BleScanException(scanStartResult);
            RxBleLog.w(bleScanException, "Failed to start scan", new Object[0]);
            throw bleScanException;
        }
    }

    @Override
    @RequiresApi(value=26)
    public void stopBackgroundBleScan(@NonNull PendingIntent callbackIntent) {
        if (Build.VERSION.SDK_INT < 26) {
            RxBleLog.w("PendingIntent based scanning is available for Android O and higher only.", new Object[0]);
            return;
        }
        if (!this.rxBleAdapterWrapper.isBluetoothEnabled()) {
            RxBleLog.w("PendingIntent based scanning is available only when Bluetooth is ON.", new Object[0]);
            return;
        }
        RxBleLog.i("Stopping pending intent based scan.", new Object[0]);
        this.rxBleAdapterWrapper.stopLeScan(callbackIntent);
    }

    @Override
    public List<ScanResult> onScanResultReceived(@NonNull Intent intent) {
        int callbackType = intent.getIntExtra("android.bluetooth.le.extra.CALLBACK_TYPE", -1);
        int errorCode = intent.getIntExtra("android.bluetooth.le.extra.ERROR_CODE", 0);
        List<android.bluetooth.le.ScanResult> nativeScanResults = BackgroundScannerImpl.extractScanResults(intent);
        ArrayList<ScanResult> scanResults = new ArrayList<ScanResult>();
        if (errorCode == 0) {
            for (android.bluetooth.le.ScanResult result : nativeScanResults) {
                scanResults.add(this.convertScanResultToRxAndroidBLEModel(callbackType, result));
            }
            return scanResults;
        }
        throw new BleScanException(errorCode);
    }

    private static List<android.bluetooth.le.ScanResult> extractScanResults(@NonNull Intent intent) {
        return (List)((Object)intent.getSerializableExtra("android.bluetooth.le.extra.LIST_SCAN_RESULT"));
    }

    private ScanResult convertScanResultToRxAndroidBLEModel(int callbackType, android.bluetooth.le.ScanResult result) {
        return this.internalToExternalScanResultConverter.apply(this.internalScanResultCreator.create(callbackType, result));
    }
}

