/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.scan;

import android.os.ParcelUuid;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.polidea.rxandroidble2.scan.ScanRecord;
import java.util.List;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ScanRecordImplCompat
implements ScanRecord {
    private final int advertiseFlags;
    @Nullable
    private final List<ParcelUuid> serviceUuids;
    private final SparseArray<byte[]> manufacturerSpecificData;
    private final Map<ParcelUuid, byte[]> serviceData;
    private final int txPowerLevel;
    private final String deviceName;
    private final byte[] bytes;

    public ScanRecordImplCompat(@Nullable List<ParcelUuid> serviceUuids, SparseArray<byte[]> manufacturerData, Map<ParcelUuid, byte[]> serviceData, int advertiseFlags, int txPowerLevel, String localName, byte[] bytes) {
        this.serviceUuids = serviceUuids;
        this.manufacturerSpecificData = manufacturerData;
        this.serviceData = serviceData;
        this.deviceName = localName;
        this.advertiseFlags = advertiseFlags;
        this.txPowerLevel = txPowerLevel;
        this.bytes = bytes;
    }

    @Override
    public int getAdvertiseFlags() {
        return this.advertiseFlags;
    }

    @Override
    @Nullable
    public List<ParcelUuid> getServiceUuids() {
        return this.serviceUuids;
    }

    @Override
    public SparseArray<byte[]> getManufacturerSpecificData() {
        return this.manufacturerSpecificData;
    }

    @Override
    @Nullable
    public byte[] getManufacturerSpecificData(int manufacturerId) {
        return (byte[])this.manufacturerSpecificData.get(manufacturerId);
    }

    @Override
    public Map<ParcelUuid, byte[]> getServiceData() {
        return this.serviceData;
    }

    @Override
    @Nullable
    public byte[] getServiceData(ParcelUuid serviceDataUuid) {
        if (serviceDataUuid == null) {
            return null;
        }
        return this.serviceData.get(serviceDataUuid);
    }

    @Override
    public int getTxPowerLevel() {
        return this.txPowerLevel;
    }

    @Override
    @Nullable
    public String getDeviceName() {
        return this.deviceName;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }
}

