/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.util;

import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import androidx.annotation.NonNull;
import java.util.Arrays;
import java.util.UUID;

public class ByteAssociation<T> {
    public final T first;
    public final byte[] second;

    public ByteAssociation(@NonNull T first, byte[] second) {
        this.first = first;
        this.second = second;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ByteAssociation)) {
            return false;
        }
        ByteAssociation ba = (ByteAssociation)o;
        return Arrays.equals(ba.second, this.second) && ba.first.equals(this.first);
    }

    public int hashCode() {
        return this.first.hashCode() ^ Arrays.hashCode(this.second);
    }

    public String toString() {
        String firstDescription = this.first instanceof BluetoothGattCharacteristic ? BluetoothGattCharacteristic.class.getSimpleName() + "(" + ((BluetoothGattCharacteristic)this.first).getUuid().toString() + ")" : (this.first instanceof BluetoothGattDescriptor ? BluetoothGattDescriptor.class.getSimpleName() + "(" + ((BluetoothGattDescriptor)this.first).getUuid().toString() + ")" : (this.first instanceof UUID ? UUID.class.getSimpleName() + "(" + this.first.toString() + ")" : this.first.getClass().getSimpleName()));
        return this.getClass().getSimpleName() + "[first=" + firstDescription + ", second=" + Arrays.toString(this.second) + "]";
    }

    public static <T> ByteAssociation<T> create(T first, byte[] bytes) {
        return new ByteAssociation<T>(first, bytes);
    }
}

