/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.util;

import androidx.annotation.NonNull;
import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import com.polidea.rxandroidble2.RxBleAdapterStateObservable;
import com.polidea.rxandroidble2.RxBleClient;
import com.polidea.rxandroidble2.internal.util.LocationServicesStatus;
import com.polidea.rxandroidble2.internal.util.RxBleAdapterWrapper;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.disposables.Disposables;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import java.util.concurrent.TimeUnit;

public class ClientStateObservable
extends Observable<RxBleClient.State> {
    private final RxBleAdapterWrapper rxBleAdapterWrapper;
    private final Observable<RxBleAdapterStateObservable.BleAdapterState> bleAdapterStateObservable;
    private final Observable<Boolean> locationServicesOkObservable;
    private final LocationServicesStatus locationServicesStatus;
    private final Scheduler timerScheduler;

    @Inject
    protected ClientStateObservable(RxBleAdapterWrapper rxBleAdapterWrapper, Observable<RxBleAdapterStateObservable.BleAdapterState> bleAdapterStateObservable, @Named(value="location-ok-boolean-observable") Observable<Boolean> locationServicesOkObservable, LocationServicesStatus locationServicesStatus, @Named(value="timeout") Scheduler timerScheduler) {
        this.rxBleAdapterWrapper = rxBleAdapterWrapper;
        this.bleAdapterStateObservable = bleAdapterStateObservable;
        this.locationServicesOkObservable = locationServicesOkObservable;
        this.locationServicesStatus = locationServicesStatus;
        this.timerScheduler = timerScheduler;
    }

    @NonNull
    private static Single<Boolean> checkPermissionUntilGranted(final LocationServicesStatus locationServicesStatus, Scheduler timerScheduler) {
        return Observable.interval((long)0L, (long)1L, (TimeUnit)TimeUnit.SECONDS, (Scheduler)timerScheduler).takeWhile((Predicate)new Predicate<Long>(){

            public boolean test(Long timer) {
                return !locationServicesStatus.isLocationPermissionOk();
            }
        }).count().map((Function)new Function<Long, Boolean>(){

            public Boolean apply(Long count) {
                return count == 0L;
            }
        });
    }

    @NonNull
    private static Observable<RxBleClient.State> checkAdapterAndServicesState(RxBleAdapterWrapper rxBleAdapterWrapper, Observable<RxBleAdapterStateObservable.BleAdapterState> rxBleAdapterStateObservable, final Observable<Boolean> locationServicesOkObservable) {
        return rxBleAdapterStateObservable.startWith((Object)(rxBleAdapterWrapper.isBluetoothEnabled() ? RxBleAdapterStateObservable.BleAdapterState.STATE_ON : RxBleAdapterStateObservable.BleAdapterState.STATE_OFF)).switchMap((Function)new Function<RxBleAdapterStateObservable.BleAdapterState, Observable<RxBleClient.State>>(){

            public Observable<RxBleClient.State> apply(RxBleAdapterStateObservable.BleAdapterState bleAdapterState) {
                if (bleAdapterState != RxBleAdapterStateObservable.BleAdapterState.STATE_ON) {
                    return Observable.just((Object)((Object)RxBleClient.State.BLUETOOTH_NOT_ENABLED));
                }
                return locationServicesOkObservable.map((Function)new Function<Boolean, RxBleClient.State>(){

                    public RxBleClient.State apply(Boolean locationServicesOk) {
                        return locationServicesOk != false ? RxBleClient.State.READY : RxBleClient.State.LOCATION_SERVICES_NOT_ENABLED;
                    }
                });
            }
        });
    }

    protected void subscribeActual(Observer<? super RxBleClient.State> observer) {
        if (!this.rxBleAdapterWrapper.hasBluetoothAdapter()) {
            observer.onSubscribe(Disposables.empty());
            observer.onComplete();
            return;
        }
        ClientStateObservable.checkPermissionUntilGranted(this.locationServicesStatus, this.timerScheduler).flatMapObservable((Function)new Function<Boolean, Observable<RxBleClient.State>>(){

            public Observable<RxBleClient.State> apply(Boolean permissionWasInitiallyGranted) {
                Observable stateObservable = ClientStateObservable.checkAdapterAndServicesState(ClientStateObservable.this.rxBleAdapterWrapper, (Observable<RxBleAdapterStateObservable.BleAdapterState>)ClientStateObservable.this.bleAdapterStateObservable, (Observable<Boolean>)ClientStateObservable.this.locationServicesOkObservable).distinctUntilChanged();
                return permissionWasInitiallyGranted != false ? stateObservable.skip(1L) : stateObservable;
            }
        }).subscribe(observer);
    }
}

