/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2;

import android.content.Context;
import androidx.annotation.NonNull;
import com.polidea.rxandroidble2.DaggerClientComponent;
import com.polidea.rxandroidble2.LogOptions;
import com.polidea.rxandroidble2.RxBleDevice;
import com.polidea.rxandroidble2.RxBleScanResult;
import com.polidea.rxandroidble2.internal.RxBleLog;
import com.polidea.rxandroidble2.scan.BackgroundScanner;
import com.polidea.rxandroidble2.scan.ScanFilter;
import com.polidea.rxandroidble2.scan.ScanResult;
import com.polidea.rxandroidble2.scan.ScanSettings;
import io.reactivex.Observable;
import java.util.Set;
import java.util.UUID;

public abstract class RxBleClient {
    public static RxBleClient create(@NonNull Context context) {
        return DaggerClientComponent.builder().applicationContext(context.getApplicationContext()).build().rxBleClient();
    }

    @Deprecated
    public static void setLogLevel(int logLevel) {
        RxBleLog.setLogLevel(logLevel);
    }

    public static void updateLogOptions(LogOptions logOptions) {
        RxBleLog.updateLogOptions(logOptions);
    }

    public abstract RxBleDevice getBleDevice(@NonNull String var1);

    public abstract Set<RxBleDevice> getBondedDevices();

    public abstract Set<RxBleDevice> getConnectedPeripherals();

    @Deprecated
    public abstract Observable<RxBleScanResult> scanBleDevices(UUID ... var1);

    public abstract Observable<ScanResult> scanBleDevices(ScanSettings var1, ScanFilter ... var2);

    public abstract BackgroundScanner getBackgroundScanner();

    public abstract Observable<State> observeStateChanges();

    public abstract State getState();

    public abstract boolean isScanRuntimePermissionGranted();

    public abstract boolean isConnectRuntimePermissionGranted();

    public abstract String[] getRecommendedScanRuntimePermissions();

    public abstract String[] getRecommendedConnectRuntimePermissions();

    public static enum State {
        BLUETOOTH_NOT_AVAILABLE,
        LOCATION_PERMISSION_NOT_GRANTED,
        BLUETOOTH_NOT_ENABLED,
        LOCATION_SERVICES_NOT_ENABLED,
        READY;

    }
}

