/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2;

import android.bluetooth.BluetoothDevice;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import bleshadow.dagger.Lazy;
import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import com.polidea.rxandroidble2.ClientComponent;
import com.polidea.rxandroidble2.RxBleAdapterStateObservable;
import com.polidea.rxandroidble2.RxBleClient;
import com.polidea.rxandroidble2.RxBleDevice;
import com.polidea.rxandroidble2.RxBleScanResult;
import com.polidea.rxandroidble2.exceptions.BleScanException;
import com.polidea.rxandroidble2.internal.RxBleDeviceProvider;
import com.polidea.rxandroidble2.internal.RxBleLog;
import com.polidea.rxandroidble2.internal.operations.LegacyScanOperation;
import com.polidea.rxandroidble2.internal.operations.Operation;
import com.polidea.rxandroidble2.internal.scan.RxBleInternalScanResult;
import com.polidea.rxandroidble2.internal.scan.RxBleInternalScanResultLegacy;
import com.polidea.rxandroidble2.internal.scan.ScanPreconditionsVerifier;
import com.polidea.rxandroidble2.internal.scan.ScanSetup;
import com.polidea.rxandroidble2.internal.scan.ScanSetupBuilder;
import com.polidea.rxandroidble2.internal.serialization.ClientOperationQueue;
import com.polidea.rxandroidble2.internal.util.BluetoothManagerWrapper;
import com.polidea.rxandroidble2.internal.util.CheckerConnectPermission;
import com.polidea.rxandroidble2.internal.util.CheckerScanPermission;
import com.polidea.rxandroidble2.internal.util.ClientStateObservable;
import com.polidea.rxandroidble2.internal.util.LocationServicesStatus;
import com.polidea.rxandroidble2.internal.util.RxBleAdapterWrapper;
import com.polidea.rxandroidble2.internal.util.ScanRecordParser;
import com.polidea.rxandroidble2.scan.BackgroundScanner;
import com.polidea.rxandroidble2.scan.ScanFilter;
import com.polidea.rxandroidble2.scan.ScanResult;
import com.polidea.rxandroidble2.scan.ScanSettings;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.functions.Function;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

class RxBleClientImpl
extends RxBleClient {
    @Deprecated
    public static final String TAG = "RxBleClient";
    final ClientOperationQueue operationQueue;
    private final ScanRecordParser scanRecordParser;
    private final RxBleDeviceProvider rxBleDeviceProvider;
    final ScanSetupBuilder scanSetupBuilder;
    final ScanPreconditionsVerifier scanPreconditionVerifier;
    final Function<RxBleInternalScanResult, ScanResult> internalToExternalScanResultMapFunction;
    private final ClientComponent.ClientComponentFinalizer clientComponentFinalizer;
    final Scheduler bluetoothInteractionScheduler;
    final Map<Set<UUID>, Observable<RxBleScanResult>> queuedScanOperations = new HashMap<Set<UUID>, Observable<RxBleScanResult>>();
    private final BluetoothManagerWrapper bluetoothManagerWrapper;
    private final RxBleAdapterWrapper rxBleAdapterWrapper;
    private final Observable<RxBleAdapterStateObservable.BleAdapterState> rxBleAdapterStateObservable;
    private final LocationServicesStatus locationServicesStatus;
    private final Lazy<ClientStateObservable> lazyClientStateObservable;
    private final BackgroundScanner backgroundScanner;
    private final CheckerScanPermission checkerScanPermission;
    private final CheckerConnectPermission checkerConnectPermission;

    @Inject
    RxBleClientImpl(BluetoothManagerWrapper bluetoothManagerWrapper, RxBleAdapterWrapper rxBleAdapterWrapper, ClientOperationQueue operationQueue, Observable<RxBleAdapterStateObservable.BleAdapterState> adapterStateObservable, ScanRecordParser scanRecordParser, LocationServicesStatus locationServicesStatus, Lazy<ClientStateObservable> lazyClientStateObservable, RxBleDeviceProvider rxBleDeviceProvider, ScanSetupBuilder scanSetupBuilder, ScanPreconditionsVerifier scanPreconditionVerifier, Function<RxBleInternalScanResult, ScanResult> internalToExternalScanResultMapFunction, @Named(value="bluetooth_interaction") Scheduler bluetoothInteractionScheduler, ClientComponent.ClientComponentFinalizer clientComponentFinalizer, BackgroundScanner backgroundScanner, CheckerScanPermission checkerScanPermission, CheckerConnectPermission checkerConnectPermission) {
        this.operationQueue = operationQueue;
        this.bluetoothManagerWrapper = bluetoothManagerWrapper;
        this.rxBleAdapterWrapper = rxBleAdapterWrapper;
        this.rxBleAdapterStateObservable = adapterStateObservable;
        this.scanRecordParser = scanRecordParser;
        this.locationServicesStatus = locationServicesStatus;
        this.lazyClientStateObservable = lazyClientStateObservable;
        this.rxBleDeviceProvider = rxBleDeviceProvider;
        this.scanSetupBuilder = scanSetupBuilder;
        this.scanPreconditionVerifier = scanPreconditionVerifier;
        this.internalToExternalScanResultMapFunction = internalToExternalScanResultMapFunction;
        this.bluetoothInteractionScheduler = bluetoothInteractionScheduler;
        this.clientComponentFinalizer = clientComponentFinalizer;
        this.backgroundScanner = backgroundScanner;
        this.checkerScanPermission = checkerScanPermission;
        this.checkerConnectPermission = checkerConnectPermission;
    }

    protected void finalize() throws Throwable {
        this.clientComponentFinalizer.onFinalize();
        super.finalize();
    }

    @Override
    public RxBleDevice getBleDevice(@NonNull String macAddress) {
        this.guardBluetoothAdapterAvailable();
        return this.rxBleDeviceProvider.getBleDevice(macAddress);
    }

    @Override
    public Set<RxBleDevice> getBondedDevices() {
        this.guardBluetoothAdapterAvailable();
        HashSet<RxBleDevice> rxBleDevices = new HashSet<RxBleDevice>();
        Set<BluetoothDevice> bluetoothDevices = this.rxBleAdapterWrapper.getBondedDevices();
        for (BluetoothDevice bluetoothDevice : bluetoothDevices) {
            rxBleDevices.add(this.getBleDevice(bluetoothDevice.getAddress()));
        }
        return rxBleDevices;
    }

    @Override
    public Set<RxBleDevice> getConnectedPeripherals() {
        HashSet<RxBleDevice> rxBleDevices = new HashSet<RxBleDevice>();
        List<BluetoothDevice> bluetoothDevices = this.bluetoothManagerWrapper.getConnectedPeripherals();
        for (BluetoothDevice bluetoothDevice : bluetoothDevices) {
            rxBleDevices.add(this.getBleDevice(bluetoothDevice.getAddress()));
        }
        return rxBleDevices;
    }

    @Override
    public Observable<ScanResult> scanBleDevices(ScanSettings scanSettings, ScanFilter ... scanFilters) {
        return Observable.defer(() -> {
            this.scanPreconditionVerifier.verify(scanSettings.shouldCheckLocationProviderState());
            ScanSetup scanSetup = this.scanSetupBuilder.build(scanSettings, scanFilters);
            Operation<RxBleInternalScanResult> scanOperation = scanSetup.scanOperation;
            return this.operationQueue.queue(scanOperation).unsubscribeOn(this.bluetoothInteractionScheduler).compose(scanSetup.scanOperationBehaviourEmulatorTransformer).map(this.internalToExternalScanResultMapFunction).doOnNext(scanResult -> {
                if (RxBleLog.getShouldLogScannedPeripherals()) {
                    RxBleLog.i("%s", scanResult);
                }
            }).mergeWith(this.bluetoothAdapterOffExceptionObservable());
        });
    }

    @Override
    public BackgroundScanner getBackgroundScanner() {
        return this.backgroundScanner;
    }

    @Override
    @Deprecated
    public Observable<RxBleScanResult> scanBleDevices(UUID ... filterServiceUUIDs) {
        return Observable.defer(() -> {
            this.scanPreconditionVerifier.verify(true);
            return this.initializeScan(filterServiceUUIDs);
        });
    }

    private Set<UUID> toDistinctSet(@Nullable UUID[] uuids) {
        if (uuids == null) {
            uuids = new UUID[]{};
        }
        return new HashSet<UUID>(Arrays.asList(uuids));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Observable<RxBleScanResult> initializeScan(@Nullable UUID[] filterServiceUUIDs) {
        Set<UUID> filteredUUIDs = this.toDistinctSet(filterServiceUUIDs);
        Map<Set<UUID>, Observable<RxBleScanResult>> map = this.queuedScanOperations;
        synchronized (map) {
            Observable<RxBleScanResult> matchingQueuedScan = this.queuedScanOperations.get(filteredUUIDs);
            if (matchingQueuedScan == null) {
                matchingQueuedScan = this.createScanOperationApi18(filterServiceUUIDs);
                this.queuedScanOperations.put(filteredUUIDs, matchingQueuedScan);
            }
            return matchingQueuedScan;
        }
    }

    <T> Observable<T> bluetoothAdapterOffExceptionObservable() {
        return this.rxBleAdapterStateObservable.filter(state -> state != RxBleAdapterStateObservable.BleAdapterState.STATE_ON).firstElement().flatMap(bleAdapterState -> Maybe.error((Throwable)new BleScanException(1))).toObservable();
    }

    RxBleScanResult convertToPublicScanResult(RxBleInternalScanResultLegacy scanResult) {
        BluetoothDevice bluetoothDevice = scanResult.getBluetoothDevice();
        RxBleDevice bleDevice = this.getBleDevice(bluetoothDevice.getAddress());
        return new RxBleScanResult(bleDevice, scanResult.getRssi(), scanResult.getScanRecord());
    }

    private Observable<RxBleScanResult> createScanOperationApi18(@Nullable UUID[] filterServiceUUIDs) {
        Set<UUID> filteredUUIDs = this.toDistinctSet(filterServiceUUIDs);
        LegacyScanOperation scanOperation = new LegacyScanOperation(filterServiceUUIDs, this.rxBleAdapterWrapper, this.scanRecordParser);
        return this.operationQueue.queue(scanOperation).doFinally(() -> {
            Map<Set<UUID>, Observable<RxBleScanResult>> map = this.queuedScanOperations;
            synchronized (map) {
                this.queuedScanOperations.remove(filteredUUIDs);
            }
        }).mergeWith(this.bluetoothAdapterOffExceptionObservable()).map(this::convertToPublicScanResult).doOnNext(rxBleScanResult -> RxBleLog.i("%s", rxBleScanResult)).share();
    }

    private void guardBluetoothAdapterAvailable() {
        if (!this.rxBleAdapterWrapper.hasBluetoothAdapter()) {
            throw new UnsupportedOperationException("RxAndroidBle library needs a BluetoothAdapter to be available in the system to work. If this is a test on an emulator then you can use 'https://github.com/Polidea/RxAndroidBle/tree/master/mockrxandroidble'");
        }
    }

    @Override
    public Observable<RxBleClient.State> observeStateChanges() {
        return (Observable)this.lazyClientStateObservable.get();
    }

    @Override
    public RxBleClient.State getState() {
        if (!this.rxBleAdapterWrapper.hasBluetoothAdapter()) {
            return RxBleClient.State.BLUETOOTH_NOT_AVAILABLE;
        }
        if (!this.locationServicesStatus.isLocationPermissionOk()) {
            return RxBleClient.State.LOCATION_PERMISSION_NOT_GRANTED;
        }
        if (!this.rxBleAdapterWrapper.isBluetoothEnabled()) {
            return RxBleClient.State.BLUETOOTH_NOT_ENABLED;
        }
        if (!this.locationServicesStatus.isLocationProviderOk()) {
            return RxBleClient.State.LOCATION_SERVICES_NOT_ENABLED;
        }
        return RxBleClient.State.READY;
    }

    @Override
    public boolean isScanRuntimePermissionGranted() {
        return this.checkerScanPermission.isScanRuntimePermissionGranted();
    }

    @Override
    public boolean isConnectRuntimePermissionGranted() {
        return this.checkerConnectPermission.isConnectRuntimePermissionGranted();
    }

    @Override
    public String[] getRecommendedScanRuntimePermissions() {
        return this.checkerScanPermission.getRecommendedScanRuntimePermissions();
    }

    @Override
    public String[] getRecommendedConnectRuntimePermissions() {
        return this.checkerConnectPermission.getRecommendedConnectRuntimePermissions();
    }
}

