/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.helpers;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import com.polidea.rxandroidble2.internal.RxBleLog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ValueInterpreter {
    public static final int FORMAT_UINT8 = 17;
    public static final int FORMAT_UINT16 = 18;
    public static final int FORMAT_UINT32 = 20;
    public static final int FORMAT_SINT8 = 33;
    public static final int FORMAT_SINT16 = 34;
    public static final int FORMAT_SINT32 = 36;
    public static final int FORMAT_SFLOAT = 50;
    public static final int FORMAT_FLOAT = 52;

    private ValueInterpreter() {
    }

    public static Integer getIntValue(@NonNull byte[] value, int formatType, @IntRange(from=0L) int offset) {
        if (offset + ValueInterpreter.getTypeLen(formatType) > value.length) {
            RxBleLog.w("Int formatType (0x%x) is longer than remaining bytes (%d) - returning null", formatType, value.length - offset);
            return null;
        }
        switch (formatType) {
            case 17: {
                return ValueInterpreter.unsignedByteToInt(value[offset]);
            }
            case 18: {
                return ValueInterpreter.unsignedBytesToInt(value[offset], value[offset + 1]);
            }
            case 20: {
                return ValueInterpreter.unsignedBytesToInt(value[offset], value[offset + 1], value[offset + 2], value[offset + 3]);
            }
            case 33: {
                return ValueInterpreter.unsignedToSigned(ValueInterpreter.unsignedByteToInt(value[offset]), 8);
            }
            case 34: {
                return ValueInterpreter.unsignedToSigned(ValueInterpreter.unsignedBytesToInt(value[offset], value[offset + 1]), 16);
            }
            case 36: {
                return ValueInterpreter.unsignedToSigned(ValueInterpreter.unsignedBytesToInt(value[offset], value[offset + 1], value[offset + 2], value[offset + 3]), 32);
            }
        }
        RxBleLog.w("Passed an invalid integer formatType (0x%x) - returning null", formatType);
        return null;
    }

    public static Float getFloatValue(@NonNull byte[] value, int formatType, @IntRange(from=0L) int offset) {
        if (offset + ValueInterpreter.getTypeLen(formatType) > value.length) {
            RxBleLog.w("Float formatType (0x%x) is longer than remaining bytes (%d) - returning null", formatType, value.length - offset);
            return null;
        }
        switch (formatType) {
            case 50: {
                return Float.valueOf(ValueInterpreter.bytesToFloat(value[offset], value[offset + 1]));
            }
            case 52: {
                return Float.valueOf(ValueInterpreter.bytesToFloat(value[offset], value[offset + 1], value[offset + 2], value[offset + 3]));
            }
        }
        RxBleLog.w("Passed an invalid float formatType (0x%x) - returning null", formatType);
        return null;
    }

    public static String getStringValue(@NonNull byte[] value, @IntRange(from=0L) int offset) {
        if (offset > value.length) {
            RxBleLog.w("Passed offset that exceeds the length of the byte array - returning null", new Object[0]);
            return null;
        }
        byte[] strBytes = new byte[value.length - offset];
        for (int i = 0; i != value.length - offset; ++i) {
            strBytes[i] = value[offset + i];
        }
        return new String(strBytes);
    }

    private static int getTypeLen(int formatType) {
        return formatType & 0xF;
    }

    private static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    private static int unsignedBytesToInt(byte b0, byte b1) {
        return ValueInterpreter.unsignedByteToInt(b0) + (ValueInterpreter.unsignedByteToInt(b1) << 8);
    }

    private static int unsignedBytesToInt(byte b0, byte b1, byte b2, byte b3) {
        return ValueInterpreter.unsignedByteToInt(b0) + (ValueInterpreter.unsignedByteToInt(b1) << 8) + (ValueInterpreter.unsignedByteToInt(b2) << 16) + (ValueInterpreter.unsignedByteToInt(b3) << 24);
    }

    private static float bytesToFloat(byte b0, byte b1) {
        int mantissa = ValueInterpreter.unsignedToSigned(ValueInterpreter.unsignedByteToInt(b0) + ((ValueInterpreter.unsignedByteToInt(b1) & 0xF) << 8), 12);
        int exponent = ValueInterpreter.unsignedToSigned(ValueInterpreter.unsignedByteToInt(b1) >> 4, 4);
        return (float)((double)mantissa * Math.pow(10.0, exponent));
    }

    private static float bytesToFloat(byte b0, byte b1, byte b2, byte b3) {
        int mantissa = ValueInterpreter.unsignedToSigned(ValueInterpreter.unsignedByteToInt(b0) + (ValueInterpreter.unsignedByteToInt(b1) << 8) + (ValueInterpreter.unsignedByteToInt(b2) << 16), 24);
        return (float)((double)mantissa * Math.pow(10.0, b3));
    }

    private static int unsignedToSigned(int unsigned, int size) {
        if ((unsigned & 1 << size - 1) != 0) {
            unsigned = -1 * ((1 << size - 1) - (unsigned & (1 << size - 1) - 1));
        }
        return unsigned;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FloatFormatType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IntFormatType {
    }
}

