/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.connection;

import android.bluetooth.BluetoothGatt;
import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import com.polidea.rxandroidble2.ConnectionSetup;
import com.polidea.rxandroidble2.RxBleConnection;
import com.polidea.rxandroidble2.internal.connection.ConnectionComponent;
import com.polidea.rxandroidble2.internal.connection.ConnectionSubscriptionWatcher;
import com.polidea.rxandroidble2.internal.connection.Connector;
import com.polidea.rxandroidble2.internal.serialization.ClientOperationQueue;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import java.util.Set;

public class ConnectorImpl
implements Connector {
    private final ClientOperationQueue clientOperationQueue;
    final ConnectionComponent.Builder connectionComponentBuilder;
    final Scheduler callbacksScheduler;

    @Inject
    public ConnectorImpl(ClientOperationQueue clientOperationQueue, ConnectionComponent.Builder connectionComponentBuilder, @Named(value="bluetooth_callbacks") Scheduler callbacksScheduler) {
        this.clientOperationQueue = clientOperationQueue;
        this.connectionComponentBuilder = connectionComponentBuilder;
        this.callbacksScheduler = callbacksScheduler;
    }

    @Override
    public Observable<RxBleConnection> prepareConnection(ConnectionSetup options) {
        return Observable.defer(() -> {
            ConnectionComponent connectionComponent = this.connectionComponentBuilder.autoConnect(options.autoConnect).suppressOperationChecks(options.suppressOperationCheck).operationTimeout(options.operationTimeout).build();
            Set<ConnectionSubscriptionWatcher> connSubWatchers = connectionComponent.connectionSubscriptionWatchers();
            return ConnectorImpl.obtainRxBleConnection(connectionComponent).mergeWith(ConnectorImpl.observeDisconnections(connectionComponent)).delaySubscription(this.enqueueConnectOperation(connectionComponent)).doOnSubscribe(disposable -> {
                for (ConnectionSubscriptionWatcher csa : connSubWatchers) {
                    csa.onConnectionSubscribed();
                }
            }).doFinally(() -> {
                for (ConnectionSubscriptionWatcher csa : connSubWatchers) {
                    csa.onConnectionUnsubscribed();
                }
            }).subscribeOn(this.callbacksScheduler).unsubscribeOn(this.callbacksScheduler);
        });
    }

    static Observable<RxBleConnection> obtainRxBleConnection(ConnectionComponent connectionComponent) {
        return Observable.fromCallable(connectionComponent::rxBleConnection);
    }

    static Observable<RxBleConnection> observeDisconnections(ConnectionComponent connectionComponent) {
        return connectionComponent.gattCallback().observeDisconnect();
    }

    Observable<BluetoothGatt> enqueueConnectOperation(ConnectionComponent connectionComponent) {
        return this.clientOperationQueue.queue(connectionComponent.connectOperation());
    }
}

