/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.connection;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import androidx.annotation.NonNull;
import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import com.polidea.rxandroidble2.NotificationSetupMode;
import com.polidea.rxandroidble2.exceptions.BleCannotSetCharacteristicNotificationException;
import com.polidea.rxandroidble2.exceptions.BleConflictingNotificationAlreadySetException;
import com.polidea.rxandroidble2.internal.connection.ConnectionScope;
import com.polidea.rxandroidble2.internal.connection.DescriptorWriter;
import com.polidea.rxandroidble2.internal.connection.RxBleGattCallback;
import com.polidea.rxandroidble2.internal.util.ActiveCharacteristicNotification;
import com.polidea.rxandroidble2.internal.util.CharacteristicNotificationId;
import com.polidea.rxandroidble2.internal.util.ObservableUtil;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.CompletableTransformer;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.internal.functions.Functions;
import io.reactivex.subjects.PublishSubject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

@ConnectionScope
class NotificationAndIndicationManager {
    static final UUID CLIENT_CHARACTERISTIC_CONFIG_UUID = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    final byte[] configEnableNotification;
    final byte[] configEnableIndication;
    final byte[] configDisable;
    final BluetoothGatt bluetoothGatt;
    final RxBleGattCallback gattCallback;
    final DescriptorWriter descriptorWriter;
    final Map<CharacteristicNotificationId, ActiveCharacteristicNotification> activeNotificationObservableMap = new HashMap<CharacteristicNotificationId, ActiveCharacteristicNotification>();

    @Inject
    NotificationAndIndicationManager(@Named(value="enable-notification-value") byte[] configEnableNotification, @Named(value="enable-indication-value") byte[] configEnableIndication, @Named(value="disable-notification-value") byte[] configDisable, BluetoothGatt bluetoothGatt, RxBleGattCallback gattCallback, DescriptorWriter descriptorWriter) {
        this.configEnableNotification = configEnableNotification;
        this.configEnableIndication = configEnableIndication;
        this.configDisable = configDisable;
        this.bluetoothGatt = bluetoothGatt;
        this.gattCallback = gattCallback;
        this.descriptorWriter = descriptorWriter;
    }

    Observable<Observable<byte[]>> setupServerInitiatedCharacteristicRead(@NonNull BluetoothGattCharacteristic characteristic, NotificationSetupMode setupMode, boolean isIndication) {
        return Observable.defer(() -> {
            Map<CharacteristicNotificationId, ActiveCharacteristicNotification> map = this.activeNotificationObservableMap;
            synchronized (map) {
                CharacteristicNotificationId id = new CharacteristicNotificationId(characteristic.getUuid(), characteristic.getInstanceId());
                ActiveCharacteristicNotification activeCharacteristicNotification = this.activeNotificationObservableMap.get((Object)id);
                if (activeCharacteristicNotification != null) {
                    if (activeCharacteristicNotification.isIndication == isIndication) {
                        return activeCharacteristicNotification.notificationObservable;
                    }
                    return Observable.error((Throwable)new BleConflictingNotificationAlreadySetException(characteristic.getUuid(), !isIndication));
                }
                byte[] enableNotificationTypeValue = isIndication ? this.configEnableIndication : this.configEnableNotification;
                PublishSubject notificationCompletedSubject = PublishSubject.create();
                Observable newObservable = NotificationAndIndicationManager.setCharacteristicNotification(this.bluetoothGatt, characteristic, true).andThen(ObservableUtil.justOnNext(NotificationAndIndicationManager.observeOnCharacteristicChangeCallbacks(this.gattCallback, id))).compose(NotificationAndIndicationManager.setupModeTransformer(this.descriptorWriter, characteristic, enableNotificationTypeValue, setupMode)).map(observable -> Observable.amb(Arrays.asList(notificationCompletedSubject.cast(byte[].class), observable.takeUntil((ObservableSource)notificationCompletedSubject)))).doFinally(() -> {
                    notificationCompletedSubject.onComplete();
                    Map<CharacteristicNotificationId, ActiveCharacteristicNotification> map = this.activeNotificationObservableMap;
                    synchronized (map) {
                        this.activeNotificationObservableMap.remove((Object)id);
                    }
                    NotificationAndIndicationManager.setCharacteristicNotification(this.bluetoothGatt, characteristic, false).compose(NotificationAndIndicationManager.teardownModeTransformer(this.descriptorWriter, characteristic, this.configDisable, setupMode)).subscribe(Functions.EMPTY_ACTION, Functions.emptyConsumer());
                }).mergeWith(this.gattCallback.observeDisconnect()).replay(1).refCount();
                this.activeNotificationObservableMap.put(id, new ActiveCharacteristicNotification((Observable<Observable<byte[]>>)newObservable, isIndication));
                return newObservable;
            }
        });
    }

    @NonNull
    static Completable setCharacteristicNotification(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic characteristic, boolean isNotificationEnabled) {
        return Completable.fromAction(() -> {
            if (!bluetoothGatt.setCharacteristicNotification(characteristic, isNotificationEnabled)) {
                throw new BleCannotSetCharacteristicNotificationException(characteristic, 1, null);
            }
        });
    }

    @NonNull
    static ObservableTransformer<Observable<byte[]>, Observable<byte[]>> setupModeTransformer(DescriptorWriter descriptorWriter, BluetoothGattCharacteristic characteristic, byte[] value, NotificationSetupMode mode) {
        return upstream -> {
            switch (mode) {
                case COMPAT: {
                    return upstream;
                }
                case QUICK_SETUP: {
                    Completable publishedWriteCCCDesc = NotificationAndIndicationManager.writeClientCharacteristicConfig(characteristic, descriptorWriter, value).toObservable().publish().autoConnect(2).ignoreElements();
                    return upstream.mergeWith((CompletableSource)publishedWriteCCCDesc).map(observable -> observable.mergeWith((CompletableSource)publishedWriteCCCDesc.onErrorComplete()));
                }
            }
            return NotificationAndIndicationManager.writeClientCharacteristicConfig(characteristic, descriptorWriter, value).andThen((ObservableSource)upstream);
        };
    }

    @NonNull
    static CompletableTransformer teardownModeTransformer(DescriptorWriter descriptorWriter, BluetoothGattCharacteristic characteristic, byte[] value, NotificationSetupMode mode) {
        return completable -> {
            if (mode == NotificationSetupMode.COMPAT) {
                return completable;
            }
            return completable.andThen((CompletableSource)NotificationAndIndicationManager.writeClientCharacteristicConfig(characteristic, descriptorWriter, value));
        };
    }

    @NonNull
    static Observable<byte[]> observeOnCharacteristicChangeCallbacks(RxBleGattCallback gattCallback, CharacteristicNotificationId characteristicId) {
        return gattCallback.getOnCharacteristicChanged().filter(notificationIdWithData -> notificationIdWithData.equals((Object)characteristicId)).map(notificationIdWithData -> notificationIdWithData.data);
    }

    @NonNull
    static Completable writeClientCharacteristicConfig(BluetoothGattCharacteristic bluetoothGattCharacteristic, DescriptorWriter descriptorWriter, byte[] value) {
        BluetoothGattDescriptor descriptor = bluetoothGattCharacteristic.getDescriptor(CLIENT_CHARACTERISTIC_CONFIG_UUID);
        if (descriptor == null) {
            return Completable.error((Throwable)new BleCannotSetCharacteristicNotificationException(bluetoothGattCharacteristic, 2, null));
        }
        return descriptorWriter.writeDescriptor(descriptor, value).onErrorResumeNext(throwable -> Completable.error((Throwable)new BleCannotSetCharacteristicNotificationException(bluetoothGattCharacteristic, 3, (Throwable)throwable)));
    }
}

