/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.connection;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import bleshadow.javax.inject.Inject;
import bleshadow.javax.inject.Named;
import com.jakewharton.rxrelay2.PublishRelay;
import com.jakewharton.rxrelay2.Relay;
import com.polidea.rxandroidble2.ConnectionParameters;
import com.polidea.rxandroidble2.HiddenBluetoothGattCallback;
import com.polidea.rxandroidble2.RxBleConnection;
import com.polidea.rxandroidble2.RxBleDeviceServices;
import com.polidea.rxandroidble2.exceptions.BleDisconnectedException;
import com.polidea.rxandroidble2.exceptions.BleGattCharacteristicException;
import com.polidea.rxandroidble2.exceptions.BleGattDescriptorException;
import com.polidea.rxandroidble2.exceptions.BleGattException;
import com.polidea.rxandroidble2.exceptions.BleGattOperationType;
import com.polidea.rxandroidble2.internal.connection.BluetoothGattProvider;
import com.polidea.rxandroidble2.internal.connection.ConnectionParametersImpl;
import com.polidea.rxandroidble2.internal.connection.ConnectionScope;
import com.polidea.rxandroidble2.internal.connection.DisconnectionRouter;
import com.polidea.rxandroidble2.internal.connection.NativeCallbackDispatcher;
import com.polidea.rxandroidble2.internal.logger.LoggerUtil;
import com.polidea.rxandroidble2.internal.util.ByteAssociation;
import com.polidea.rxandroidble2.internal.util.CharacteristicChangedEvent;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Scheduler;
import io.reactivex.functions.Function;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

@ConnectionScope
public class RxBleGattCallback {
    private final Scheduler callbackScheduler;
    final BluetoothGattProvider bluetoothGattProvider;
    final DisconnectionRouter disconnectionRouter;
    final NativeCallbackDispatcher nativeCallbackDispatcher;
    final PublishRelay<RxBleConnection.RxBleConnectionState> connectionStatePublishRelay = PublishRelay.create();
    final Output<RxBleDeviceServices> servicesDiscoveredOutput = new Output();
    final Output<ByteAssociation<UUID>> readCharacteristicOutput = new Output();
    final Output<ByteAssociation<UUID>> writeCharacteristicOutput = new Output();
    final Relay<CharacteristicChangedEvent> changedCharacteristicSerializedPublishRelay = PublishRelay.create().toSerialized();
    final Output<ByteAssociation<BluetoothGattDescriptor>> readDescriptorOutput = new Output();
    final Output<ByteAssociation<BluetoothGattDescriptor>> writeDescriptorOutput = new Output();
    final Output<Integer> readRssiOutput = new Output();
    final Output<Integer> changedMtuOutput = new Output();
    final Output<ConnectionParameters> updatedConnectionOutput = new Output();
    private final Function<BleGattException, Observable<?>> errorMapper = new Function<BleGattException, Observable<?>>(){

        public Observable<?> apply(BleGattException bleGattException) {
            return Observable.error((Throwable)bleGattException);
        }
    };
    private final BluetoothGattCallback bluetoothGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            LoggerUtil.logCallback("onConnectionStateChange", gatt, status, newState);
            RxBleGattCallback.this.nativeCallbackDispatcher.notifyNativeConnectionStateCallback(gatt, status, newState);
            super.onConnectionStateChange(gatt, status, newState);
            RxBleGattCallback.this.bluetoothGattProvider.updateBluetoothGatt(gatt);
            if (this.isDisconnectedOrDisconnecting(newState)) {
                RxBleGattCallback.this.disconnectionRouter.onDisconnectedException(new BleDisconnectedException(gatt.getDevice().getAddress(), status));
            } else if (status != 0) {
                RxBleGattCallback.this.disconnectionRouter.onGattConnectionStateException(new BleGattException(gatt, status, BleGattOperationType.CONNECTION_STATE));
            }
            RxBleGattCallback.this.connectionStatePublishRelay.accept((Object)RxBleGattCallback.mapConnectionStateToRxBleConnectionStatus(newState));
        }

        private boolean isDisconnectedOrDisconnecting(int newState) {
            return newState == 0 || newState == 3;
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            LoggerUtil.logCallback("onServicesDiscovered", gatt, status);
            RxBleGattCallback.this.nativeCallbackDispatcher.notifyNativeServicesDiscoveredCallback(gatt, status);
            super.onServicesDiscovered(gatt, status);
            if (RxBleGattCallback.this.servicesDiscoveredOutput.hasObservers() && !RxBleGattCallback.propagateErrorIfOccurred(RxBleGattCallback.this.servicesDiscoveredOutput, gatt, status, BleGattOperationType.SERVICE_DISCOVERY)) {
                RxBleGattCallback.this.servicesDiscoveredOutput.valueRelay.accept((Object)new RxBleDeviceServices(gatt.getServices()));
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            LoggerUtil.logCallback("onCharacteristicRead", gatt, status, characteristic, true);
            RxBleGattCallback.this.nativeCallbackDispatcher.notifyNativeReadCallback(gatt, characteristic, status);
            super.onCharacteristicRead(gatt, characteristic, status);
            if (RxBleGattCallback.this.readCharacteristicOutput.hasObservers() && !RxBleGattCallback.propagateErrorIfOccurred(RxBleGattCallback.this.readCharacteristicOutput, gatt, characteristic, status, BleGattOperationType.CHARACTERISTIC_READ)) {
                RxBleGattCallback.this.readCharacteristicOutput.valueRelay.accept(new ByteAssociation<UUID>(characteristic.getUuid(), characteristic.getValue()));
            }
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            LoggerUtil.logCallback("onCharacteristicWrite", gatt, status, characteristic, false);
            RxBleGattCallback.this.nativeCallbackDispatcher.notifyNativeWriteCallback(gatt, characteristic, status);
            super.onCharacteristicWrite(gatt, characteristic, status);
            if (RxBleGattCallback.this.writeCharacteristicOutput.hasObservers() && !RxBleGattCallback.propagateErrorIfOccurred(RxBleGattCallback.this.writeCharacteristicOutput, gatt, characteristic, status, BleGattOperationType.CHARACTERISTIC_WRITE)) {
                RxBleGattCallback.this.writeCharacteristicOutput.valueRelay.accept(new ByteAssociation<UUID>(characteristic.getUuid(), characteristic.getValue()));
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            LoggerUtil.logCallback("onCharacteristicChanged", gatt, characteristic, true);
            RxBleGattCallback.this.nativeCallbackDispatcher.notifyNativeChangedCallback(gatt, characteristic);
            super.onCharacteristicChanged(gatt, characteristic);
            if (RxBleGattCallback.this.changedCharacteristicSerializedPublishRelay.hasObservers()) {
                RxBleGattCallback.this.changedCharacteristicSerializedPublishRelay.accept((Object)new CharacteristicChangedEvent(characteristic.getUuid(), characteristic.getInstanceId(), characteristic.getValue()));
            }
        }

        public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            LoggerUtil.logCallback("onDescriptorRead", gatt, status, descriptor, true);
            RxBleGattCallback.this.nativeCallbackDispatcher.notifyNativeDescriptorReadCallback(gatt, descriptor, status);
            super.onDescriptorRead(gatt, descriptor, status);
            if (RxBleGattCallback.this.readDescriptorOutput.hasObservers() && !RxBleGattCallback.propagateErrorIfOccurred(RxBleGattCallback.this.readDescriptorOutput, gatt, descriptor, status, BleGattOperationType.DESCRIPTOR_READ)) {
                RxBleGattCallback.this.readDescriptorOutput.valueRelay.accept(new ByteAssociation<BluetoothGattDescriptor>(descriptor, descriptor.getValue()));
            }
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            LoggerUtil.logCallback("onDescriptorWrite", gatt, status, descriptor, false);
            RxBleGattCallback.this.nativeCallbackDispatcher.notifyNativeDescriptorWriteCallback(gatt, descriptor, status);
            super.onDescriptorWrite(gatt, descriptor, status);
            if (RxBleGattCallback.this.writeDescriptorOutput.hasObservers() && !RxBleGattCallback.propagateErrorIfOccurred(RxBleGattCallback.this.writeDescriptorOutput, gatt, descriptor, status, BleGattOperationType.DESCRIPTOR_WRITE)) {
                RxBleGattCallback.this.writeDescriptorOutput.valueRelay.accept(new ByteAssociation<BluetoothGattDescriptor>(descriptor, descriptor.getValue()));
            }
        }

        public void onReliableWriteCompleted(BluetoothGatt gatt, int status) {
            LoggerUtil.logCallback("onReliableWriteCompleted", gatt, status);
            RxBleGattCallback.this.nativeCallbackDispatcher.notifyNativeReliableWriteCallback(gatt, status);
            super.onReliableWriteCompleted(gatt, status);
        }

        public void onReadRemoteRssi(BluetoothGatt gatt, int rssi, int status) {
            LoggerUtil.logCallback("onReadRemoteRssi", gatt, status, rssi);
            RxBleGattCallback.this.nativeCallbackDispatcher.notifyNativeReadRssiCallback(gatt, rssi, status);
            super.onReadRemoteRssi(gatt, rssi, status);
            if (RxBleGattCallback.this.readRssiOutput.hasObservers() && !RxBleGattCallback.propagateErrorIfOccurred(RxBleGattCallback.this.readRssiOutput, gatt, status, BleGattOperationType.READ_RSSI)) {
                RxBleGattCallback.this.readRssiOutput.valueRelay.accept((Object)rssi);
            }
        }

        public void onMtuChanged(BluetoothGatt gatt, int mtu, int status) {
            LoggerUtil.logCallback("onMtuChanged", gatt, status, mtu);
            RxBleGattCallback.this.nativeCallbackDispatcher.notifyNativeMtuChangedCallback(gatt, mtu, status);
            super.onMtuChanged(gatt, mtu, status);
            if (RxBleGattCallback.this.changedMtuOutput.hasObservers() && !RxBleGattCallback.propagateErrorIfOccurred(RxBleGattCallback.this.changedMtuOutput, gatt, status, BleGattOperationType.ON_MTU_CHANGED)) {
                RxBleGattCallback.this.changedMtuOutput.valueRelay.accept((Object)mtu);
            }
        }

        public void onConnectionUpdated(BluetoothGatt gatt, int interval, int latency, int timeout, int status) {
            LoggerUtil.logConnectionUpdateCallback("onConnectionUpdated", gatt, status, interval, latency, timeout);
            RxBleGattCallback.this.nativeCallbackDispatcher.notifyNativeParamsUpdateCallback(gatt, interval, latency, timeout, status);
            if (RxBleGattCallback.this.updatedConnectionOutput.hasObservers() && !RxBleGattCallback.propagateErrorIfOccurred(RxBleGattCallback.this.updatedConnectionOutput, gatt, status, BleGattOperationType.CONNECTION_PRIORITY_CHANGE)) {
                RxBleGattCallback.this.updatedConnectionOutput.valueRelay.accept((Object)new ConnectionParametersImpl(interval, latency, timeout));
            }
        }
    };

    @Inject
    public RxBleGattCallback(@Named(value="bluetooth_callbacks") Scheduler callbackScheduler, BluetoothGattProvider bluetoothGattProvider, DisconnectionRouter disconnectionRouter, NativeCallbackDispatcher nativeCallbackDispatcher) {
        this.callbackScheduler = callbackScheduler;
        this.bluetoothGattProvider = bluetoothGattProvider;
        this.disconnectionRouter = disconnectionRouter;
        this.nativeCallbackDispatcher = nativeCallbackDispatcher;
    }

    static RxBleConnection.RxBleConnectionState mapConnectionStateToRxBleConnectionStatus(int newState) {
        switch (newState) {
            case 1: {
                return RxBleConnection.RxBleConnectionState.CONNECTING;
            }
            case 2: {
                return RxBleConnection.RxBleConnectionState.CONNECTED;
            }
            case 3: {
                return RxBleConnection.RxBleConnectionState.DISCONNECTING;
            }
        }
        return RxBleConnection.RxBleConnectionState.DISCONNECTED;
    }

    static boolean propagateErrorIfOccurred(Output<?> output, BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status, BleGattOperationType operationType) {
        return RxBleGattCallback.isException(status) && RxBleGattCallback.propagateStatusError(output, new BleGattCharacteristicException(gatt, characteristic, status, operationType));
    }

    static boolean propagateErrorIfOccurred(Output<?> output, BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status, BleGattOperationType operationType) {
        return RxBleGattCallback.isException(status) && RxBleGattCallback.propagateStatusError(output, new BleGattDescriptorException(gatt, descriptor, status, operationType));
    }

    static boolean propagateErrorIfOccurred(Output<?> output, BluetoothGatt gatt, int status, BleGattOperationType operationType) {
        return RxBleGattCallback.isException(status) && RxBleGattCallback.propagateStatusError(output, new BleGattException(gatt, status, operationType));
    }

    private static boolean isException(int status) {
        return status != 0;
    }

    private static boolean propagateStatusError(Output<?> output, BleGattException exception) {
        output.errorRelay.accept((Object)exception);
        return true;
    }

    private <T> Observable<T> withDisconnectionHandling(Output<T> output) {
        return Observable.merge(this.disconnectionRouter.asErrorOnlyObservable(), output.valueRelay, (ObservableSource)output.errorRelay.flatMap(this.errorMapper));
    }

    public BluetoothGattCallback getBluetoothGattCallback() {
        return this.bluetoothGattCallback;
    }

    public <T> Observable<T> observeDisconnect() {
        return this.disconnectionRouter.asErrorOnlyObservable();
    }

    public Observable<RxBleConnection.RxBleConnectionState> getOnConnectionStateChange() {
        return this.connectionStatePublishRelay.delay(0L, TimeUnit.SECONDS, this.callbackScheduler);
    }

    public Observable<RxBleDeviceServices> getOnServicesDiscovered() {
        return this.withDisconnectionHandling(this.servicesDiscoveredOutput).delay(0L, TimeUnit.SECONDS, this.callbackScheduler);
    }

    public Observable<Integer> getOnMtuChanged() {
        return this.withDisconnectionHandling(this.changedMtuOutput).delay(0L, TimeUnit.SECONDS, this.callbackScheduler);
    }

    public Observable<ByteAssociation<UUID>> getOnCharacteristicRead() {
        return this.withDisconnectionHandling(this.readCharacteristicOutput).delay(0L, TimeUnit.SECONDS, this.callbackScheduler);
    }

    public Observable<ByteAssociation<UUID>> getOnCharacteristicWrite() {
        return this.withDisconnectionHandling(this.writeCharacteristicOutput).delay(0L, TimeUnit.SECONDS, this.callbackScheduler);
    }

    public Observable<CharacteristicChangedEvent> getOnCharacteristicChanged() {
        return Observable.merge(this.disconnectionRouter.asErrorOnlyObservable(), this.changedCharacteristicSerializedPublishRelay).delay(0L, TimeUnit.SECONDS, this.callbackScheduler);
    }

    public Observable<ByteAssociation<BluetoothGattDescriptor>> getOnDescriptorRead() {
        return this.withDisconnectionHandling(this.readDescriptorOutput).delay(0L, TimeUnit.SECONDS, this.callbackScheduler);
    }

    public Observable<ByteAssociation<BluetoothGattDescriptor>> getOnDescriptorWrite() {
        return this.withDisconnectionHandling(this.writeDescriptorOutput).delay(0L, TimeUnit.SECONDS, this.callbackScheduler);
    }

    public Observable<Integer> getOnRssiRead() {
        return this.withDisconnectionHandling(this.readRssiOutput).delay(0L, TimeUnit.SECONDS, this.callbackScheduler);
    }

    public Observable<ConnectionParameters> getConnectionParametersUpdates() {
        return this.withDisconnectionHandling(this.updatedConnectionOutput).delay(0L, TimeUnit.SECONDS, this.callbackScheduler);
    }

    public void setNativeCallback(BluetoothGattCallback callback) {
        this.nativeCallbackDispatcher.setNativeCallback(callback);
    }

    public void setHiddenNativeCallback(HiddenBluetoothGattCallback callbackHidden) {
        this.nativeCallbackDispatcher.setNativeCallbackHidden(callbackHidden);
    }

    private static class Output<T> {
        final PublishRelay<T> valueRelay = PublishRelay.create();
        final PublishRelay<BleGattException> errorRelay = PublishRelay.create();

        Output() {
        }

        boolean hasObservers() {
            return this.valueRelay.hasObservers() || this.errorRelay.hasObservers();
        }
    }
}

