/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.connection;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattService;
import androidx.annotation.NonNull;
import bleshadow.javax.inject.Inject;
import com.polidea.rxandroidble2.RxBleDeviceServices;
import com.polidea.rxandroidble2.internal.connection.ConnectionScope;
import com.polidea.rxandroidble2.internal.operations.OperationsProvider;
import com.polidea.rxandroidble2.internal.operations.ServiceDiscoveryOperation;
import com.polidea.rxandroidble2.internal.operations.TimeoutConfiguration;
import com.polidea.rxandroidble2.internal.serialization.ConnectionOperationQueue;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.functions.Functions;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.BehaviorSubject;
import io.reactivex.subjects.Subject;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

@ConnectionScope
class ServiceDiscoveryManager {
    final ConnectionOperationQueue operationQueue;
    final BluetoothGatt bluetoothGatt;
    final OperationsProvider operationProvider;
    private Single<RxBleDeviceServices> deviceServicesObservable;
    final Subject<TimeoutConfiguration> timeoutBehaviorSubject = BehaviorSubject.create().toSerialized();
    boolean hasCachedResults = false;

    @Inject
    ServiceDiscoveryManager(ConnectionOperationQueue operationQueue, BluetoothGatt bluetoothGatt, OperationsProvider operationProvider) {
        this.operationQueue = operationQueue;
        this.bluetoothGatt = bluetoothGatt;
        this.operationProvider = operationProvider;
        this.reset();
    }

    Single<RxBleDeviceServices> getDiscoverServicesSingle(final long timeout, final TimeUnit timeoutTimeUnit) {
        if (this.hasCachedResults) {
            return this.deviceServicesObservable;
        }
        return this.deviceServicesObservable.doOnSubscribe((Consumer)new Consumer<Disposable>(){

            public void accept(Disposable disposable) {
                ServiceDiscoveryManager.this.timeoutBehaviorSubject.onNext((Object)new TimeoutConfiguration(timeout, timeoutTimeUnit, Schedulers.computation()));
            }
        });
    }

    void reset() {
        this.hasCachedResults = false;
        this.deviceServicesObservable = this.getListOfServicesFromGatt().map(ServiceDiscoveryManager.wrapIntoRxBleDeviceServices()).switchIfEmpty((SingleSource)this.getTimeoutConfiguration().flatMap(this.scheduleActualDiscoveryWithTimeout())).doOnSuccess(Functions.actionConsumer((Action)new Action(){

            public void run() {
                ServiceDiscoveryManager.this.hasCachedResults = true;
            }
        })).doOnError(Functions.actionConsumer((Action)new Action(){

            public void run() {
                ServiceDiscoveryManager.this.reset();
            }
        })).cache();
    }

    @NonNull
    private static Function<List<BluetoothGattService>, RxBleDeviceServices> wrapIntoRxBleDeviceServices() {
        return new Function<List<BluetoothGattService>, RxBleDeviceServices>(){

            public RxBleDeviceServices apply(List<BluetoothGattService> bluetoothGattServices) {
                return new RxBleDeviceServices(bluetoothGattServices);
            }
        };
    }

    private Maybe<List<BluetoothGattService>> getListOfServicesFromGatt() {
        return Single.fromCallable((Callable)new Callable<List<BluetoothGattService>>(){

            @Override
            public List<BluetoothGattService> call() {
                return ServiceDiscoveryManager.this.bluetoothGatt.getServices();
            }
        }).filter((Predicate)new Predicate<List<BluetoothGattService>>(){

            public boolean test(List<BluetoothGattService> bluetoothGattServices) {
                return bluetoothGattServices.size() > 0;
            }
        });
    }

    @NonNull
    private Single<TimeoutConfiguration> getTimeoutConfiguration() {
        return this.timeoutBehaviorSubject.firstOrError();
    }

    @NonNull
    private Function<TimeoutConfiguration, Single<RxBleDeviceServices>> scheduleActualDiscoveryWithTimeout() {
        return new Function<TimeoutConfiguration, Single<RxBleDeviceServices>>(){

            public Single<RxBleDeviceServices> apply(TimeoutConfiguration timeoutConf) {
                ServiceDiscoveryOperation operation = ServiceDiscoveryManager.this.operationProvider.provideServiceDiscoveryOperation(timeoutConf.timeout, timeoutConf.timeoutTimeUnit);
                return ServiceDiscoveryManager.this.operationQueue.queue(operation).firstOrError();
            }
        };
    }
}

