/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.serialization;

import androidx.annotation.NonNull;
import com.polidea.rxandroidble2.internal.logger.LoggerUtil;
import com.polidea.rxandroidble2.internal.operations.Operation;
import com.polidea.rxandroidble2.internal.serialization.QueueSemaphore;
import io.reactivex.ObservableEmitter;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.atomic.AtomicLong;

class FIFORunnableEntry<T>
implements Comparable<FIFORunnableEntry> {
    private static final AtomicLong SEQUENCE = new AtomicLong(0L);
    private final long seqNum = SEQUENCE.getAndIncrement();
    final Operation<T> operation;
    final ObservableEmitter<T> operationResultObserver;

    FIFORunnableEntry(Operation<T> operation, ObservableEmitter<T> operationResultObserver) {
        this.operation = operation;
        this.operationResultObserver = operationResultObserver;
    }

    @Override
    public int compareTo(@NonNull FIFORunnableEntry other) {
        int res = this.operation.compareTo(other.operation);
        if (res == 0 && other.operation != this.operation) {
            res = this.seqNum < other.seqNum ? -1 : 1;
        }
        return res;
    }

    public void run(final QueueSemaphore semaphore, final Scheduler subscribeScheduler) {
        if (this.operationResultObserver.isDisposed()) {
            LoggerUtil.logOperationSkippedBecauseDisposedWhenAboutToRun(this.operation);
            semaphore.release();
            return;
        }
        subscribeScheduler.scheduleDirect(new Runnable(){

            @Override
            public void run() {
                FIFORunnableEntry.this.operation.run(semaphore).unsubscribeOn(subscribeScheduler).subscribe(new Observer<T>(){

                    public void onSubscribe(Disposable disposable) {
                        FIFORunnableEntry.this.operationResultObserver.setDisposable(disposable);
                    }

                    public void onNext(T item) {
                        FIFORunnableEntry.this.operationResultObserver.onNext(item);
                    }

                    public void onError(Throwable e) {
                        FIFORunnableEntry.this.operationResultObserver.tryOnError(e);
                    }

                    public void onComplete() {
                        FIFORunnableEntry.this.operationResultObserver.onComplete();
                    }
                });
            }
        });
    }
}

