/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.util;

import androidx.annotation.NonNull;
import com.polidea.rxandroidble2.internal.RxBleLog;

public class CharacteristicPropertiesParser {
    private final int propertyBroadcast;
    private final int propertyRead;
    private final int propertyWriteNoResponse;
    private final int propertyWrite;
    private final int propertyNotify;
    private final int propertyIndicate;
    private final int propertySignedWrite;
    private final int[] possibleProperties;

    public CharacteristicPropertiesParser(int propertyBroadcast, int propertyRead, int propertyWriteNoResponse, int propertyWrite, int propertyNotify, int propertyIndicate, int propertySignedWrite) {
        this.propertyBroadcast = propertyBroadcast;
        this.propertyRead = propertyRead;
        this.propertyWriteNoResponse = propertyWriteNoResponse;
        this.propertyWrite = propertyWrite;
        this.propertyNotify = propertyNotify;
        this.propertyIndicate = propertyIndicate;
        this.propertySignedWrite = propertySignedWrite;
        this.possibleProperties = this.getPossibleProperties();
    }

    @NonNull
    public String propertiesIntToString(int property) {
        StringBuilder builder = new StringBuilder();
        builder.append("[ ");
        for (int possibleProperty : this.possibleProperties) {
            if (!CharacteristicPropertiesParser.propertiesIntContains(property, possibleProperty)) continue;
            builder.append(this.propertyToString(possibleProperty));
            builder.append(" ");
        }
        builder.append("]");
        return builder.toString();
    }

    @NonNull
    private int[] getPossibleProperties() {
        int[] propertyDictionary = new int[]{this.propertyBroadcast, this.propertyRead, this.propertyWriteNoResponse, this.propertyWrite, this.propertyNotify, this.propertyIndicate, this.propertySignedWrite};
        return propertyDictionary;
    }

    private static boolean propertiesIntContains(int properties, int property) {
        return (properties & property) != 0;
    }

    @NonNull
    private String propertyToString(int property) {
        if (property == this.propertyRead) {
            return "READ";
        }
        if (property == this.propertyWrite) {
            return "WRITE";
        }
        if (property == this.propertyWriteNoResponse) {
            return "WRITE_NO_RESPONSE";
        }
        if (property == this.propertySignedWrite) {
            return "SIGNED_WRITE";
        }
        if (property == this.propertyIndicate) {
            return "INDICATE";
        }
        if (property == this.propertyBroadcast) {
            return "BROADCAST";
        }
        if (property == this.propertyNotify) {
            return "NOTIFY";
        }
        if (property == 0) {
            return "";
        }
        RxBleLog.e("Unknown property specified (%d)", property);
        return "UNKNOWN (" + property + " -> check android.bluetooth.BluetoothGattCharacteristic)";
    }
}

