/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.util;

import io.reactivex.ObservableEmitter;
import io.reactivex.SingleEmitter;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.observers.DisposableSingleObserver;

public class DisposableUtil {
    private DisposableUtil() {
    }

    public static <T> DisposableSingleObserver<T> disposableSingleObserverFromEmitter(final SingleEmitter<T> emitter) {
        return new DisposableSingleObserver<T>(){

            public void onSuccess(T t) {
                emitter.onSuccess(t);
            }

            public void onError(Throwable e) {
                emitter.tryOnError(e);
            }
        };
    }

    public static <T> DisposableObserver<T> disposableObserverFromEmitter(final ObservableEmitter<T> emitter) {
        return new DisposableObserver<T>(){

            public void onNext(T t) {
                emitter.onNext(t);
            }

            public void onError(Throwable e) {
                emitter.tryOnError(e);
            }

            public void onComplete() {
                emitter.onComplete();
            }
        };
    }

    public static <T> DisposableSingleObserver<T> disposableSingleObserverFromEmitter(final ObservableEmitter<T> emitter) {
        return new DisposableSingleObserver<T>(){

            public void onSuccess(T t) {
                emitter.onNext(t);
                emitter.onComplete();
            }

            public void onError(Throwable e) {
                emitter.tryOnError(e);
            }
        };
    }
}

