/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.internal.util;

import com.polidea.rxandroidble2.internal.serialization.QueueReleaseInterface;
import io.reactivex.ObservableEmitter;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Cancellable;
import java.util.concurrent.atomic.AtomicBoolean;

public class QueueReleasingEmitterWrapper<T>
implements Observer<T>,
Cancellable {
    private final AtomicBoolean isEmitterCanceled = new AtomicBoolean(false);
    private final ObservableEmitter<T> emitter;
    private final QueueReleaseInterface queueReleaseInterface;

    public QueueReleasingEmitterWrapper(ObservableEmitter<T> emitter, QueueReleaseInterface queueReleaseInterface) {
        this.emitter = emitter;
        this.queueReleaseInterface = queueReleaseInterface;
        emitter.setCancellable((Cancellable)this);
    }

    public void onComplete() {
        this.queueReleaseInterface.release();
        this.emitter.onComplete();
    }

    public void onError(Throwable e) {
        this.queueReleaseInterface.release();
        this.emitter.tryOnError(e);
    }

    public void onSubscribe(Disposable d) {
    }

    public void onNext(T t) {
        this.emitter.onNext(t);
    }

    public synchronized void cancel() {
        this.isEmitterCanceled.set(true);
    }

    public synchronized boolean isWrappedEmitterUnsubscribed() {
        return this.isEmitterCanceled.get();
    }
}

