/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble2.scan;

import android.os.Parcel;
import android.os.Parcelable;
import com.polidea.rxandroidble2.internal.scan.ExternalScanSettingsExtension;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ScanSettings
implements Parcelable,
ExternalScanSettingsExtension<ScanSettings> {
    public static final int SCAN_MODE_OPPORTUNISTIC = -1;
    public static final int SCAN_MODE_LOW_POWER = 0;
    public static final int SCAN_MODE_BALANCED = 1;
    public static final int SCAN_MODE_LOW_LATENCY = 2;
    public static final int CALLBACK_TYPE_ALL_MATCHES = 1;
    public static final int CALLBACK_TYPE_FIRST_MATCH = 2;
    public static final int CALLBACK_TYPE_MATCH_LOST = 4;
    public static final int MATCH_NUM_ONE_ADVERTISEMENT = 1;
    public static final int MATCH_NUM_FEW_ADVERTISEMENT = 2;
    public static final int MATCH_NUM_MAX_ADVERTISEMENT = 3;
    public static final int MATCH_MODE_AGGRESSIVE = 1;
    public static final int MATCH_MODE_STICKY = 2;
    private int mScanMode;
    private int mCallbackType;
    private long mReportDelayMillis;
    private int mMatchMode;
    private int mNumOfMatchesPerFilter;
    private boolean mLegacy;
    private boolean mShouldCheckLocationProviderState;
    public static final Parcelable.Creator<ScanSettings> CREATOR = new Parcelable.Creator<ScanSettings>(){

        public ScanSettings[] newArray(int size) {
            return new ScanSettings[size];
        }

        public ScanSettings createFromParcel(Parcel in) {
            return new ScanSettings(in);
        }
    };

    public int getScanMode() {
        return this.mScanMode;
    }

    public int getCallbackType() {
        return this.mCallbackType;
    }

    public int getMatchMode() {
        return this.mMatchMode;
    }

    public int getNumOfMatches() {
        return this.mNumOfMatchesPerFilter;
    }

    public boolean getLegacy() {
        return this.mLegacy;
    }

    public long getReportDelayMillis() {
        return this.mReportDelayMillis;
    }

    @Override
    public boolean shouldCheckLocationProviderState() {
        return this.mShouldCheckLocationProviderState;
    }

    ScanSettings(int scanMode, int callbackType, long reportDelayMillis, int matchMode, int numOfMatchesPerFilter, boolean legacy, boolean shouldCheckLocationServicesState) {
        this.mScanMode = scanMode;
        this.mCallbackType = callbackType;
        this.mReportDelayMillis = reportDelayMillis;
        this.mNumOfMatchesPerFilter = numOfMatchesPerFilter;
        this.mMatchMode = matchMode;
        this.mLegacy = legacy;
        this.mShouldCheckLocationProviderState = shouldCheckLocationServicesState;
    }

    ScanSettings(Parcel in) {
        this.mScanMode = in.readInt();
        this.mCallbackType = in.readInt();
        this.mReportDelayMillis = in.readLong();
        this.mMatchMode = in.readInt();
        this.mNumOfMatchesPerFilter = in.readInt();
        this.mLegacy = in.readInt() != 0;
        this.mShouldCheckLocationProviderState = in.readInt() != 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mScanMode);
        dest.writeInt(this.mCallbackType);
        dest.writeLong(this.mReportDelayMillis);
        dest.writeInt(this.mMatchMode);
        dest.writeInt(this.mNumOfMatchesPerFilter);
        dest.writeInt(this.mLegacy ? 1 : 0);
        dest.writeInt(this.mShouldCheckLocationProviderState ? 1 : 0);
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public ScanSettings copyWithCallbackType(int callbackType) {
        return new ScanSettings(this.mScanMode, callbackType, this.mReportDelayMillis, this.mMatchMode, this.mNumOfMatchesPerFilter, this.mLegacy, this.mShouldCheckLocationProviderState);
    }

    public static final class Builder
    implements ExternalScanSettingsExtension.Builder {
        private int mScanMode = 0;
        private int mCallbackType = 1;
        private long mReportDelayMillis = 0L;
        private int mMatchMode = 1;
        private int mNumOfMatchesPerFilter = 3;
        private boolean mLegacy = true;
        private boolean mShouldCheckLocationProviderState = true;

        public Builder setScanMode(int scanMode) {
            if (scanMode < -1 || scanMode > 2) {
                throw new IllegalArgumentException("invalid scan mode " + scanMode);
            }
            this.mScanMode = scanMode;
            return this;
        }

        public Builder setCallbackType(int callbackType) {
            if (!Builder.isValidCallbackType(callbackType)) {
                throw new IllegalArgumentException("invalid callback type - " + callbackType);
            }
            this.mCallbackType = callbackType;
            return this;
        }

        public Builder setShouldCheckLocationServicesState(boolean shouldCheck) {
            this.mShouldCheckLocationProviderState = shouldCheck;
            return this;
        }

        private static boolean isValidCallbackType(int callbackType) {
            if (callbackType == 1 || callbackType == 2 || callbackType == 4) {
                return true;
            }
            return callbackType == 6;
        }

        public Builder setLegacy(boolean legacy) {
            this.mLegacy = legacy;
            return this;
        }

        public ScanSettings build() {
            return new ScanSettings(this.mScanMode, this.mCallbackType, this.mReportDelayMillis, this.mMatchMode, this.mNumOfMatchesPerFilter, this.mLegacy, this.mShouldCheckLocationProviderState);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MatchMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MatchNum {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CallbackType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScanMode {
    }
}

