/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.emp.connector;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public interface BayeuxParameters {
    public String bearerToken();

    default public URL endpoint() {
        String path = "/cometd/" + this.version();
        try {
            return new URL(this.host(), path);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("Unable to create url: %s:%s", this.host().toExternalForm(), path), e);
        }
    }

    default public URL host() {
        try {
            return new URL("https://login.salesforce.com");
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(String.format("Unable to form URL for %s", "https://login.salesforce.com"));
        }
    }

    default public long keepAlive() {
        return 60L;
    }

    default public TimeUnit keepAliveUnit() {
        return TimeUnit.MINUTES;
    }

    default public Map<String, Object> longPollingOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("maxNetworkDelay", this.maxNetworkDelay());
        options.put("maxBufferSize", this.maxBufferSize());
        return options;
    }

    default public int maxBufferSize() {
        return 0x100000;
    }

    default public int maxNetworkDelay() {
        return 15000;
    }

    default public Collection<? extends ProxyConfiguration.Proxy> proxies() {
        return Collections.emptyList();
    }

    default public SslContextFactory sslContextFactory() {
        return new SslContextFactory();
    }

    default public String version() {
        return "46.0";
    }
}

