/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.emp.connector.example;

import com.salesforce.emp.connector.BayeuxParameters;
import com.salesforce.emp.connector.EmpConnector;
import com.salesforce.emp.connector.TopicSubscription;
import com.salesforce.emp.connector.example.LoggingListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.jetty.util.ajax.JSON;

public class BearerTokenExample {
    public static void main(final String[] argv) throws Exception {
        if (argv.length < 2 || argv.length > 4) {
            System.err.println("Usage: BearerTokenExample url token topic [replayFrom]");
            System.exit(1);
        }
        long replayFrom = EmpConnector.REPLAY_FROM_EARLIEST;
        if (argv.length == 4) {
            replayFrom = Long.parseLong(argv[3]);
        }
        BayeuxParameters params = new BayeuxParameters(){

            @Override
            public String bearerToken() {
                return argv[1];
            }

            @Override
            public URL host() {
                try {
                    return new URL(argv[0]);
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(String.format("Unable to create url: %s", argv[0]), e);
                }
            }
        };
        Consumer<Map<String, Object>> consumer = event -> System.out.println(String.format("Received:\n%s", JSON.toString((Map)event)));
        EmpConnector connector = new EmpConnector(params);
        connector.addListener("/meta/connect", new LoggingListener(true, true)).addListener("/meta/disconnect", new LoggingListener(true, true)).addListener("/meta/handshake", new LoggingListener(true, true));
        connector.start().get(5L, TimeUnit.SECONDS);
        TopicSubscription subscription = connector.subscribe(argv[2], replayFrom, consumer).get(5L, TimeUnit.SECONDS);
        System.out.println(String.format("Subscribed: %s", subscription));
    }
}

