/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.emp.connector.example;

import com.salesforce.emp.connector.BayeuxParameters;
import com.salesforce.emp.connector.EmpConnector;
import com.salesforce.emp.connector.LoginHelper;
import com.salesforce.emp.connector.TopicSubscription;
import com.salesforce.emp.connector.example.BearerTokenProvider;
import com.salesforce.emp.connector.example.LoggingListener;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.eclipse.jetty.util.ajax.JSON;

public class DevLoginExample {
    public static void main(String[] argv) throws Throwable {
        TopicSubscription subscription;
        if (argv.length < 4 || argv.length > 5) {
            System.err.println("Usage: DevLoginExample url username password topic [replayFrom]");
            System.exit(1);
        }
        Consumer<Map<String, Object>> consumer = event -> System.out.println(String.format("Received:\n%s", JSON.toString((Map)event)));
        BearerTokenProvider tokenProvider = new BearerTokenProvider(() -> {
            try {
                return LoginHelper.login(new URL(argv[0]), argv[1], argv[2]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        BayeuxParameters params = tokenProvider.login();
        EmpConnector connector = new EmpConnector(params);
        LoggingListener loggingListener = new LoggingListener(true, true);
        connector.addListener("/meta/handshake", loggingListener).addListener("/meta/connect", loggingListener).addListener("/meta/disconnect", loggingListener).addListener("/meta/subscribe", loggingListener).addListener("/meta/unsubscribe", loggingListener);
        connector.setBearerTokenProvider(tokenProvider);
        connector.start().get(5L, TimeUnit.SECONDS);
        long replayFrom = EmpConnector.REPLAY_FROM_EARLIEST;
        if (argv.length == 5) {
            replayFrom = Long.parseLong(argv[4]);
        }
        try {
            subscription = connector.subscribe(argv[3], replayFrom, consumer).get(5L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            System.err.println(e.getCause().toString());
            System.exit(1);
            throw e.getCause();
        }
        catch (TimeoutException e) {
            System.err.println("Timed out subscribing");
            System.exit(1);
            throw e.getCause();
        }
        System.out.println(String.format("Subscribed: %s", subscription));
    }
}

