/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.emp.connector.example;

import com.salesforce.emp.connector.BayeuxParameters;
import com.salesforce.emp.connector.EmpConnector;
import com.salesforce.emp.connector.LoginHelper;
import com.salesforce.emp.connector.TopicSubscription;
import com.salesforce.emp.connector.example.BearerTokenProvider;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.jetty.util.ajax.JSON;

public class LoginExample {
    public static void main(String[] argv) throws Exception {
        if (argv.length < 3 || argv.length > 4) {
            System.err.println("Usage: LoginExample username password topic [replayFrom]");
            System.exit(1);
        }
        long replayFrom = EmpConnector.REPLAY_FROM_EARLIEST;
        if (argv.length == 4) {
            replayFrom = Long.parseLong(argv[3]);
        }
        BearerTokenProvider tokenProvider = new BearerTokenProvider(() -> {
            try {
                return LoginHelper.login(argv[0], argv[1]);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.exit(1);
                throw new RuntimeException(e);
            }
        });
        BayeuxParameters params = tokenProvider.login();
        Consumer<Map<String, Object>> consumer = event -> System.out.println(String.format("Received:\n%s", JSON.toString((Map)event)));
        EmpConnector connector = new EmpConnector(params);
        connector.setBearerTokenProvider(tokenProvider);
        connector.start().get(5L, TimeUnit.SECONDS);
        TopicSubscription subscription = connector.subscribe(argv[2], replayFrom, consumer).get(5L, TimeUnit.SECONDS);
        System.out.println(String.format("Subscribed: %s", subscription));
    }
}

