/*
 * Decompiled with CFR 0.152.
 */
package com.posthog.server.internal;

import com.posthog.PostHogConfig;
import com.posthog.internal.FlagConditionGroup;
import com.posthog.internal.FlagDefinition;
import com.posthog.internal.FlagProperty;
import com.posthog.internal.LogicalOperator;
import com.posthog.internal.PropertyGroup;
import com.posthog.internal.PropertyOperator;
import com.posthog.internal.PropertyType;
import com.posthog.internal.PropertyValue;
import com.posthog.internal.VariantDefinition;
import com.posthog.server.internal.FlagEvaluator;
import com.posthog.server.internal.InconclusiveMatchException;
import java.security.MessageDigest;
import java.text.Normalizer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 >2\u00020\u0001:\u0002>?B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\b\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J$\u0010\u0011\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\b\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u0012\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u0002Jj\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00180\u00172\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00102\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00172\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001e0\u0017J\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u00102\u0006\u0010 \u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0010J\"\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00102\b\b\u0002\u0010#\u001a\u00020\u0010H\u0002Jv\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'2\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00172\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001e0\u00172\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u001aJp\u0010(\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0014\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00172\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001e0\u00172\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0010Jv\u0010*\u001a\u0004\u0018\u00010\u00012\u0006\u0010 \u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00102\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00172\u0014\b\u0002\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001e0\u00172\u0016\b\u0002\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u0018\b\u0002\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u001aJ$\u0010+\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0014\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0017Jp\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u001e2\u0014\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00172\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001e0\u00172\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0010J\u001c\u0010.\u001a\u00020\u00062\b\u0010/\u001a\u0004\u0018\u00010\u00012\b\u00100\u001a\u0004\u0018\u00010\u0001H\u0002J\u0018\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u0010H\u0002J\u0010\u00103\u001a\u0002042\u0006\u0010\b\u001a\u00020\u0010H\u0002J\u0010\u00105\u001a\u0002042\u0006\u0010\b\u001a\u00020\u0010H\u0002J\u0012\u00106\u001a\u0004\u0018\u0001042\u0006\u0010\b\u001a\u00020\u0010H\u0002J \u00107\u001a\u00020\u00062\u0006\u00108\u001a\u00020\u00102\u0006\u00109\u001a\u00020\u00102\u0006\u0010:\u001a\u00020\u0006H\u0002J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<2\u0006\u0010 \u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/posthog/server/internal/FlagEvaluator;", "", "config", "Lcom/posthog/PostHogConfig;", "(Lcom/posthog/PostHogConfig;)V", "compareDates", "", "overrideValue", "propertyValue", "propertyOperator", "Lcom/posthog/internal/PropertyOperator;", "compareNumbers", "lhs", "", "rhs", "compareStrings", "", "compareValues", "computeExactMatch", "evaluateFlagDependency", "property", "Lcom/posthog/internal/FlagProperty;", "flagsByKey", "", "Lcom/posthog/internal/FlagDefinition;", "evaluationCache", "", "distinctId", "properties", "cohortProperties", "Lcom/posthog/internal/PropertyGroup;", "getMatchingVariant", "flag", "hash", "key", "salt", "isConditionMatch", "featureFlag", "condition", "Lcom/posthog/internal/FlagConditionGroup;", "matchCohort", "propertyValues", "matchFeatureFlagProperties", "matchProperty", "matchPropertyGroup", "propertyGroup", "matchesDependencyValue", "expectedValue", "actualValue", "matchesRegex", "pattern", "parseDateValue", "Ljava/time/ZonedDateTime;", "parseOverrideDate", "parseRelativeDate", "stringContains", "haystack", "needle", "ignoreCase", "variantLookupTable", "", "Lcom/posthog/server/internal/FlagEvaluator$VariantLookupEntry;", "Companion", "VariantLookupEntry", "posthog-server"})
@SourceDebugExtension(value={"SMAP\nFlagEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlagEvaluator.kt\ncom/posthog/server/internal/FlagEvaluator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,847:1\n1#2:848\n1747#3,3:849\n1549#3:852\n1620#3,3:853\n1045#3:856\n*S KotlinDebug\n*F\n+ 1 FlagEvaluator.kt\ncom/posthog/server/internal/FlagEvaluator\n*L\n206#1:849,3\n674#1:852\n674#1:853,3\n679#1:856\n*E\n"})
public final class FlagEvaluator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PostHogConfig config;
    private static final double LONG_SCALE = 1.152921504606847E18;
    @NotNull
    private static final Set<PropertyOperator> NONE_VALUES_ALLOWED_OPERATORS = SetsKt.setOf((Object)PropertyOperator.IS_NOT);
    @NotNull
    private static final Regex REGEX_COMBINING_MARKS = new Regex("\\p{M}+");
    @NotNull
    private static final Regex REGEX_RELATIVE_DATE = new Regex("^-?([0-9]+)([hdwmy])$");
    private static final DateTimeFormatter DATE_FORMATTER_WITH_SPACE_TZ = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss XXX");
    private static final DateTimeFormatter DATE_FORMATTER_NO_SPACE_TZ = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ssXXX");
    private static final DateTimeFormatter DATE_FORMATTER_NO_TZ = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public FlagEvaluator(@NotNull PostHogConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    private final double hash(String key, String distinctId, String salt) {
        String hashKey = key + '.' + distinctId + salt;
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        byte[] byArray = hashKey.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] hashBytes = digest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)hashBytes, (String)"hashBytes");
        String hexString2 = ArraysKt.joinToString$default((byte[])hashBytes, (CharSequence)"", null, null, (int)0, null, (Function1)hash.hexString.1.INSTANCE, (int)30, null);
        String string = hexString2.substring(0, 15);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        long hashValue = Long.parseLong(string, CharsKt.checkRadix((int)16));
        return (double)hashValue / 1.152921504606847E18;
    }

    static /* synthetic */ double hash$default(FlagEvaluator flagEvaluator, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "";
        }
        return flagEvaluator.hash(string, string2, string3);
    }

    @Nullable
    public final String getMatchingVariant(@NotNull FlagDefinition flag, @NotNull String distinctId) {
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        Intrinsics.checkNotNullParameter((Object)distinctId, (String)"distinctId");
        double hashValue = this.hash(flag.getKey(), distinctId, "variant");
        List<VariantLookupEntry> variants = this.variantLookupTable(flag);
        for (VariantLookupEntry variant : variants) {
            if (!(hashValue >= variant.getValueMin()) || !(hashValue < variant.getValueMax())) continue;
            return variant.getKey();
        }
        return null;
    }

    private final List<VariantLookupEntry> variantLookupTable(FlagDefinition flag) {
        List lookupTable;
        block1: {
            lookupTable = new ArrayList();
            double valueMin = 0.0;
            Object object = flag.getFilters().getMultivariate();
            if (object == null || (object = object.getVariants()) == null) break block1;
            Object variants = object;
            boolean bl = false;
            Iterator iterator = variants.iterator();
            while (iterator.hasNext()) {
                VariantDefinition variant = (VariantDefinition)iterator.next();
                double valueMax = valueMin + variant.getRolloutPercentage() / 100.0;
                lookupTable.add(new VariantLookupEntry(variant.getKey(), valueMin, valueMax));
                valueMin = valueMax;
            }
        }
        return lookupTable;
    }

    public final boolean matchProperty(@NotNull FlagProperty property, @NotNull Map<String, ? extends Object> propertyValues) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter(propertyValues, (String)"propertyValues");
        String key = property.getKey();
        PropertyOperator propertyOperator = property.getPropertyOperator();
        if (propertyOperator == null) {
            propertyOperator = PropertyOperator.EXACT;
        }
        PropertyOperator propertyOperator2 = propertyOperator;
        Object propertyValue = property.getPropertyValue();
        if (!propertyValues.containsKey(key)) {
            throw new InconclusiveMatchException("Can't match properties without a given property value");
        }
        if (propertyOperator2 == PropertyOperator.IS_NOT_SET) {
            throw new InconclusiveMatchException("Can't match properties with operator is_not_set");
        }
        Object overrideValue = propertyValues.get(key);
        if (!NONE_VALUES_ALLOWED_OPERATORS.contains(propertyOperator2) && overrideValue == null) {
            return false;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[propertyOperator2.ordinal()]) {
            case 1: 
            case 2: {
                boolean matches = this.computeExactMatch(propertyValue, overrideValue);
                if (propertyOperator2 == PropertyOperator.EXACT) {
                    bl = matches;
                    break;
                }
                if (!matches) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                bl = propertyValues.containsKey(key);
                break;
            }
            case 4: {
                bl = this.stringContains(String.valueOf(overrideValue), String.valueOf(propertyValue), true);
                break;
            }
            case 5: {
                if (!this.stringContains(String.valueOf(overrideValue), String.valueOf(propertyValue), true)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 6: {
                bl = this.matchesRegex(String.valueOf(propertyValue), String.valueOf(overrideValue));
                break;
            }
            case 7: {
                if (!this.matchesRegex(String.valueOf(propertyValue), String.valueOf(overrideValue))) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                bl = this.compareValues(overrideValue, propertyValue, propertyOperator2);
                break;
            }
            case 12: 
            case 13: {
                bl = this.compareDates(overrideValue, propertyValue, propertyOperator2);
                break;
            }
            default: {
                throw new InconclusiveMatchException("Unknown operator: " + propertyOperator2);
            }
        }
        return bl;
    }

    private final boolean computeExactMatch(Object propertyValue, Object overrideValue) {
        boolean bl;
        block7: {
            String string;
            Object object = overrideValue;
            if (object != null) {
                Object it = object;
                boolean bl2 = false;
                string = FlagEvaluator.Companion.casefold(it.toString());
            } else {
                string = null;
            }
            String expectedValue = string;
            if (propertyValue instanceof List) {
                Iterable $this$any$iv = (Iterable)propertyValue;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator = $this$any$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv;
                        Object v = element$iv = iterator.next();
                        boolean bl3 = false;
                        if (!(Intrinsics.areEqual(v, (Object)expectedValue) || v != null && Intrinsics.areEqual((Object)FlagEvaluator.Companion.casefold(v.toString()), (Object)expectedValue))) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            } else {
                bl = Intrinsics.areEqual((Object)propertyValue, (Object)expectedValue) || propertyValue != null && Intrinsics.areEqual((Object)FlagEvaluator.Companion.casefold(propertyValue.toString()), (Object)expectedValue);
            }
        }
        return bl;
    }

    private final boolean stringContains(String haystack, String needle, boolean ignoreCase) {
        if (ignoreCase) {
            return StringsKt.contains((CharSequence)FlagEvaluator.Companion.casefold(haystack), (CharSequence)FlagEvaluator.Companion.casefold(needle), (boolean)true);
        }
        return StringsKt.contains$default((CharSequence)haystack, (CharSequence)needle, (boolean)false, (int)2, null);
    }

    private final boolean matchesRegex(String pattern, String propertyValue) {
        boolean bl;
        try {
            bl = Regex.find$default((Regex)new Regex(pattern), (CharSequence)propertyValue, (int)0, (int)2, null) != null;
        }
        catch (PatternSyntaxException e) {
            bl = false;
        }
        return bl;
    }

    private final boolean compareValues(Object overrideValue, Object propertyValue, PropertyOperator propertyOperator) {
        Object object;
        Double numericValue;
        Object object2 = propertyValue;
        Double d = object2 != null && (object2 = object2.toString()) != null ? StringsKt.toDoubleOrNull((String)object2) : (numericValue = null);
        return numericValue != null && overrideValue != null ? ((object = overrideValue) instanceof String ? this.compareStrings((String)overrideValue, propertyValue.toString(), propertyOperator) : (object instanceof Number ? this.compareNumbers(((Number)overrideValue).doubleValue(), numericValue, propertyOperator) : this.compareStrings(overrideValue.toString(), propertyValue.toString(), propertyOperator))) : this.compareStrings(String.valueOf(overrideValue), String.valueOf(propertyValue), propertyOperator);
    }

    private final boolean compareNumbers(double lhs, double rhs, PropertyOperator propertyOperator) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[propertyOperator.ordinal()]) {
            case 8: {
                if (lhs > rhs) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 9: {
                if (lhs >= rhs) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 10: {
                if (lhs < rhs) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 11: {
                if (lhs <= rhs) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean compareStrings(String lhs, String rhs, PropertyOperator propertyOperator) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[propertyOperator.ordinal()]) {
            case 8: {
                if (lhs.compareTo(rhs) > 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 9: {
                if (lhs.compareTo(rhs) >= 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 10: {
                if (lhs.compareTo(rhs) < 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 11: {
                if (lhs.compareTo(rhs) <= 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean compareDates(Object overrideValue, Object propertyValue, PropertyOperator propertyOperator) {
        boolean bl;
        ZonedDateTime zonedDateTime;
        ZonedDateTime zonedDateTime2;
        try {
            zonedDateTime2 = this.parseDateValue(String.valueOf(propertyValue));
        }
        catch (Exception e) {
            throw new InconclusiveMatchException("The date set on the flag is not a valid format");
        }
        ZonedDateTime parsedDate = zonedDateTime2;
        Object object = overrideValue;
        if (object instanceof Date) {
            zonedDateTime = ((Date)overrideValue).toInstant().atZone(ZoneId.systemDefault());
        } else if (object instanceof ZonedDateTime) {
            zonedDateTime = (ZonedDateTime)overrideValue;
        } else if (object instanceof Instant) {
            zonedDateTime = ((Instant)overrideValue).atZone(ZoneId.systemDefault());
        } else if (object instanceof String) {
            ZonedDateTime zonedDateTime3;
            try {
                zonedDateTime3 = this.parseOverrideDate((String)overrideValue);
            }
            catch (Exception e) {
                throw new InconclusiveMatchException("The date provided is not a valid format");
            }
            zonedDateTime = zonedDateTime3;
        } else {
            throw new InconclusiveMatchException("The date provided must be a string or date object");
        }
        ZonedDateTime overrideDate = zonedDateTime;
        switch (WhenMappings.$EnumSwitchMapping$0[propertyOperator.ordinal()]) {
            case 12: {
                bl = overrideDate.isBefore(parsedDate);
                break;
            }
            case 13: {
                bl = overrideDate.isAfter(parsedDate);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private final ZonedDateTime parseDateValue(String propertyValue) {
        ZonedDateTime relativeDate = this.parseRelativeDate(propertyValue);
        if (relativeDate != null) {
            return relativeDate;
        }
        return this.parseOverrideDate(propertyValue);
    }

    private final ZonedDateTime parseRelativeDate(String propertyValue) {
        ZonedDateTime zonedDateTime;
        MatchResult matchResult = Regex.find$default((Regex)REGEX_RELATIVE_DATE, (CharSequence)propertyValue, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult match = matchResult;
        Integer n = StringsKt.toIntOrNull((String)((String)match.getGroupValues().get(1)));
        if (n == null) {
            return null;
        }
        int number = n;
        String interval = (String)match.getGroupValues().get(2);
        if (number >= 10000) {
            return null;
        }
        ZonedDateTime now = ZonedDateTime.now();
        switch (interval) {
            case "h": {
                zonedDateTime = now.minus(number, ChronoUnit.HOURS);
                break;
            }
            case "d": {
                zonedDateTime = now.minus(number, ChronoUnit.DAYS);
                break;
            }
            case "w": {
                zonedDateTime = now.minus(number, ChronoUnit.WEEKS);
                break;
            }
            case "m": {
                zonedDateTime = now.minus(number, ChronoUnit.MONTHS);
                break;
            }
            case "y": {
                zonedDateTime = now.minus(number, ChronoUnit.YEARS);
                break;
            }
            default: {
                zonedDateTime = null;
            }
        }
        return zonedDateTime;
    }

    private final ZonedDateTime parseOverrideDate(String propertyValue) {
        try {
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(propertyValue);
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"parse(propertyValue)");
            return zonedDateTime;
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                ZonedDateTime zonedDateTime = ZonedDateTime.parse(propertyValue, DateTimeFormatter.ISO_DATE_TIME);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"parse(propertyValue, Dat\u2026eFormatter.ISO_DATE_TIME)");
                return zonedDateTime;
            }
            catch (DateTimeParseException dateTimeParseException2) {
                try {
                    ZonedDateTime zonedDateTime = LocalDate.parse(propertyValue, DateTimeFormatter.ISO_DATE).atStartOfDay(ZoneId.systemDefault());
                    Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"parse(propertyValue, Dat\u2026y(ZoneId.systemDefault())");
                    return zonedDateTime;
                }
                catch (DateTimeParseException dateTimeParseException3) {
                    try {
                        ZonedDateTime zonedDateTime = Instant.parse(propertyValue).atZone(ZoneId.systemDefault());
                        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"parse(propertyValue).atZ\u2026e(ZoneId.systemDefault())");
                        return zonedDateTime;
                    }
                    catch (DateTimeParseException dateTimeParseException4) {
                        try {
                            ZonedDateTime zonedDateTime = ZonedDateTime.parse(propertyValue, DATE_FORMATTER_WITH_SPACE_TZ);
                            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"parse(propertyValue, DATE_FORMATTER_WITH_SPACE_TZ)");
                            return zonedDateTime;
                        }
                        catch (DateTimeParseException dateTimeParseException5) {
                            try {
                                ZonedDateTime zonedDateTime = ZonedDateTime.parse(propertyValue, DATE_FORMATTER_NO_SPACE_TZ);
                                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"parse(propertyValue, DATE_FORMATTER_NO_SPACE_TZ)");
                                return zonedDateTime;
                            }
                            catch (DateTimeParseException dateTimeParseException6) {
                                try {
                                    ZonedDateTime zonedDateTime = LocalDateTime.parse(propertyValue, DATE_FORMATTER_NO_TZ).atZone(ZoneId.systemDefault());
                                    Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"parse(propertyValue, DAT\u2026e(ZoneId.systemDefault())");
                                    return zonedDateTime;
                                }
                                catch (DateTimeParseException dateTimeParseException7) {
                                    throw new DateTimeParseException("Unable to parse date: " + propertyValue, propertyValue, 0);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public final boolean matchCohort(@NotNull FlagProperty property, @NotNull Map<String, ? extends Object> propertyValues, @NotNull Map<String, PropertyGroup> cohortProperties, @Nullable Map<String, FlagDefinition> flagsByKey, @Nullable Map<String, Object> evaluationCache, @Nullable String distinctId) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter(propertyValues, (String)"propertyValues");
        Intrinsics.checkNotNullParameter(cohortProperties, (String)"cohortProperties");
        Object object = property.getPropertyValue();
        if (object == null || (object = object.toString()) == null) {
            throw new InconclusiveMatchException("Cohort property missing value");
        }
        Object cohortId = object;
        if (!cohortProperties.containsKey(cohortId)) {
            throw new InconclusiveMatchException("Can't match cohort without a given cohort property value");
        }
        PropertyGroup propertyGroup = cohortProperties.get(cohortId);
        if (propertyGroup == null) {
            throw new InconclusiveMatchException("Cohort definition not found");
        }
        PropertyGroup propertyGroup2 = propertyGroup;
        return this.matchPropertyGroup(propertyGroup2, propertyValues, cohortProperties, flagsByKey, evaluationCache, distinctId);
    }

    public final boolean matchPropertyGroup(@NotNull PropertyGroup propertyGroup, @NotNull Map<String, ? extends Object> propertyValues, @NotNull Map<String, PropertyGroup> cohortProperties, @Nullable Map<String, FlagDefinition> flagsByKey, @Nullable Map<String, Object> evaluationCache, @Nullable String distinctId) {
        Intrinsics.checkNotNullParameter((Object)propertyGroup, (String)"propertyGroup");
        Intrinsics.checkNotNullParameter(propertyValues, (String)"propertyValues");
        Intrinsics.checkNotNullParameter(cohortProperties, (String)"cohortProperties");
        LogicalOperator groupType = propertyGroup.getType();
        PropertyValue properties = propertyGroup.getValues();
        if (properties == null || properties.isEmpty()) {
            return true;
        }
        boolean errorMatchingLocally = false;
        PropertyValue propertyValue = properties;
        if (propertyValue instanceof PropertyValue.PropertyGroups) {
            for (PropertyGroup nestedGroup : ((PropertyValue.PropertyGroups)properties).getValues()) {
                try {
                    boolean matches = this.matchPropertyGroup(nestedGroup, propertyValues, cohortProperties, flagsByKey, evaluationCache, distinctId);
                    if (groupType == LogicalOperator.AND) {
                        if (matches) continue;
                        return false;
                    }
                    if (!matches) continue;
                    return true;
                }
                catch (InconclusiveMatchException e) {
                    this.config.getLogger().log("Failed to compute nested property group locally: " + e.getMessage());
                    errorMatchingLocally = true;
                }
            }
            if (errorMatchingLocally) {
                throw new InconclusiveMatchException("Can't match cohort without a given cohort property value");
            }
            return groupType == LogicalOperator.AND;
        }
        if (propertyValue instanceof PropertyValue.FlagProperties) {
            for (FlagProperty property : ((PropertyValue.FlagProperties)properties).getValues()) {
                try {
                    boolean negation;
                    boolean bl;
                    PropertyType propertyType = property.getType();
                    switch (propertyType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[propertyType.ordinal()]) {
                        case 1: {
                            bl = this.matchCohort(property, propertyValues, cohortProperties, flagsByKey, evaluationCache, distinctId);
                            break;
                        }
                        case 2: {
                            Map<String, FlagDefinition> map = flagsByKey;
                            if (map == null) {
                                throw new InconclusiveMatchException("Cannot evaluate flag dependencies without flagsByKey");
                            }
                            Map<String, Object> map2 = evaluationCache;
                            if (map2 == null) {
                                throw new InconclusiveMatchException("Cannot evaluate flag dependencies without evaluationCache");
                            }
                            String string = distinctId;
                            if (string == null) {
                                throw new InconclusiveMatchException("Cannot evaluate flag dependencies without distinctId");
                            }
                            bl = this.evaluateFlagDependency(property, map, map2, string, propertyValues, cohortProperties);
                            break;
                        }
                        default: {
                            bl = this.matchProperty(property, propertyValues);
                        }
                    }
                    boolean matches = bl;
                    Boolean bl2 = property.getNegation();
                    boolean bl3 = negation = bl2 != null ? bl2 : false;
                    if (groupType == LogicalOperator.AND) {
                        if (!matches && !negation) {
                            return false;
                        }
                        if (!matches || !negation) continue;
                        return false;
                    }
                    if (matches && !negation) {
                        return true;
                    }
                    if (matches || !negation) continue;
                    return true;
                }
                catch (InconclusiveMatchException e) {
                    this.config.getLogger().log("Failed to compute property " + property.getKey() + " locally: " + e.getMessage());
                    errorMatchingLocally = true;
                }
            }
            if (errorMatchingLocally) {
                throw new InconclusiveMatchException("Can't match cohort without a given cohort property value");
            }
            return groupType == LogicalOperator.AND;
        }
        throw new NoWhenBranchMatchedException();
    }

    public final boolean isConditionMatch(@NotNull FlagDefinition featureFlag, @NotNull String distinctId, @NotNull FlagConditionGroup condition, @NotNull Map<String, ? extends Object> properties, @NotNull Map<String, PropertyGroup> cohortProperties, @Nullable Map<String, FlagDefinition> flagsByKey, @Nullable Map<String, Object> evaluationCache) {
        List conditionProperties;
        Intrinsics.checkNotNullParameter((Object)featureFlag, (String)"featureFlag");
        Intrinsics.checkNotNullParameter((Object)distinctId, (String)"distinctId");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Intrinsics.checkNotNullParameter(cohortProperties, (String)"cohortProperties");
        Integer rolloutPercentage = condition.getRolloutPercentage();
        List list = condition.getProperties();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        if (!((Collection)(conditionProperties = list)).isEmpty()) {
            for (FlagProperty prop : conditionProperties) {
                boolean matches;
                boolean bl;
                PropertyType propertyType = prop.getType();
                switch (propertyType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[propertyType.ordinal()]) {
                    case 1: {
                        bl = this.matchCohort(prop, properties, cohortProperties, flagsByKey, evaluationCache, distinctId);
                        break;
                    }
                    case 2: {
                        Map<String, FlagDefinition> map = flagsByKey;
                        if (map == null) {
                            throw new InconclusiveMatchException("Cannot evaluate flag dependencies without flagsByKey");
                        }
                        Map<String, Object> map2 = evaluationCache;
                        if (map2 == null) {
                            throw new InconclusiveMatchException("Cannot evaluate flag dependencies without evaluationCache");
                        }
                        bl = this.evaluateFlagDependency(prop, map, map2, distinctId, properties, cohortProperties);
                        break;
                    }
                    default: {
                        bl = this.matchProperty(prop, properties);
                    }
                }
                if (matches = bl) continue;
                return false;
            }
            if (rolloutPercentage == null) {
                return true;
            }
        }
        return rolloutPercentage == null || !(FlagEvaluator.hash$default(this, featureFlag.getKey(), distinctId, null, 4, null) > (double)rolloutPercentage.intValue() / 100.0);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object matchFeatureFlagProperties(@NotNull FlagDefinition flag, @NotNull String distinctId, @NotNull Map<String, ? extends Object> properties, @NotNull Map<String, PropertyGroup> cohortProperties, @Nullable Map<String, FlagDefinition> flagsByKey, @Nullable Map<String, Object> evaluationCache) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        Intrinsics.checkNotNullParameter((Object)distinctId, (String)"distinctId");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Intrinsics.checkNotNullParameter(cohortProperties, (String)"cohortProperties");
        if (flag.getEnsureExperienceContinuity()) {
            throw new InconclusiveMatchException("Flag \"" + flag.getKey() + "\" has experience continuity enabled");
        }
        List list = flag.getFilters().getGroups();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List flagConditions = list;
        boolean isInconclusive = false;
        Object object = flag.getFilters().getMultivariate();
        if (object == null || (object = object.getVariants()) == null) {
            object = CollectionsKt.emptyList();
        }
        Object flagVariants = object;
        Iterable $this$map$iv = (Iterable)flagVariants;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VariantDefinition variantDefinition = (VariantDefinition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKey());
        }
        Set validVariantKeys = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$sortedBy$iv = flagConditions;
        boolean $i$f$sortedBy = false;
        List sortedFlagConditions = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                FlagConditionGroup it = (FlagConditionGroup)a;
                boolean bl = false;
                int n = it.getVariant() != null ? 0 : 1;
                it = (FlagConditionGroup)b;
                Comparable comparable = Integer.valueOf(n);
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it.getVariant() != null ? 0 : 1));
            }
        });
        for (FlagConditionGroup condition : sortedFlagConditions) {
            try {
                if (!this.isConditionMatch(flag, distinctId, condition, properties, cohortProperties, flagsByKey, evaluationCache)) continue;
                String variantOverride = condition.getVariant();
                String variant = variantOverride != null && validVariantKeys.contains(variantOverride) ? variantOverride : this.getMatchingVariant(flag, distinctId);
                Object object2 = variant;
                if (object2 == null) {
                    object2 = true;
                }
                return object2;
            }
            catch (InconclusiveMatchException e) {
                isInconclusive = true;
            }
        }
        if (isInconclusive) {
            throw new InconclusiveMatchException("Can't determine if feature flag is enabled or not with given properties");
        }
        return false;
    }

    public static /* synthetic */ Object matchFeatureFlagProperties$default(FlagEvaluator flagEvaluator, FlagDefinition flagDefinition, String string, Map map, Map map2, Map map3, Map map4, int n, Object object) {
        if ((n & 8) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            map3 = null;
        }
        if ((n & 0x20) != 0) {
            map4 = null;
        }
        return flagEvaluator.matchFeatureFlagProperties(flagDefinition, string, map, map2, map3, map4);
    }

    public final boolean evaluateFlagDependency(@NotNull FlagProperty property, @NotNull Map<String, FlagDefinition> flagsByKey, @NotNull Map<String, Object> evaluationCache, @NotNull String distinctId, @NotNull Map<String, ? extends Object> properties, @NotNull Map<String, PropertyGroup> cohortProperties) {
        PropertyOperator propertyOperator;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter(flagsByKey, (String)"flagsByKey");
        Intrinsics.checkNotNullParameter(evaluationCache, (String)"evaluationCache");
        Intrinsics.checkNotNullParameter((Object)distinctId, (String)"distinctId");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Intrinsics.checkNotNullParameter(cohortProperties, (String)"cohortProperties");
        List dependencyChain = property.getDependencyChain();
        if (dependencyChain == null) {
            throw new InconclusiveMatchException("Flag dependency property for '" + property.getKey() + "' is missing required 'dependency_chain' field");
        }
        if (dependencyChain.isEmpty()) {
            this.config.getLogger().log("Circular dependency detected for flag: " + property.getKey());
            throw new InconclusiveMatchException("Circular dependency detected for flag '" + property.getKey() + '\'');
        }
        for (String depFlagKey : dependencyChain) {
            Object cachedResult;
            if (!evaluationCache.containsKey(depFlagKey)) {
                FlagDefinition depFlag = flagsByKey.get(depFlagKey);
                if (depFlag == null) {
                    evaluationCache.put(depFlagKey, null);
                    throw new InconclusiveMatchException("Cannot evaluate flag dependency '" + depFlagKey + "' - flag not found in local flags");
                }
                if (!depFlag.getActive()) {
                    evaluationCache.put(depFlagKey, false);
                } else {
                    try {
                        Object depResult = this.matchFeatureFlagProperties(depFlag, distinctId, properties, cohortProperties, flagsByKey, evaluationCache);
                        evaluationCache.put(depFlagKey, depResult);
                    }
                    catch (InconclusiveMatchException e) {
                        evaluationCache.put(depFlagKey, null);
                        throw new InconclusiveMatchException("Cannot evaluate flag dependency '" + depFlagKey + "': " + e.getMessage());
                    }
                }
            }
            if ((cachedResult = evaluationCache.get(depFlagKey)) == null) {
                throw new InconclusiveMatchException("Flag dependency '" + depFlagKey + "' was previously inconclusive");
            }
            if (!Intrinsics.areEqual((Object)cachedResult, (Object)false)) continue;
            return false;
        }
        String flagKey = property.getKey();
        Object expectedValue = property.getPropertyValue();
        PropertyOperator propertyOperator2 = property.getPropertyOperator();
        if (propertyOperator2 == null) {
            propertyOperator2 = propertyOperator = PropertyOperator.EXACT;
        }
        if (expectedValue != null) {
            Object actualValue = evaluationCache.get(flagKey);
            if (actualValue == null) {
                throw new InconclusiveMatchException("Flag '" + flagKey + "' was not evaluated despite being in dependency chain");
            }
            if (propertyOperator == PropertyOperator.FLAG_EVALUATES_TO) {
                return this.matchesDependencyValue(expectedValue, actualValue);
            }
            throw new InconclusiveMatchException("Flag dependency property for '" + property.getKey() + "' has invalid operator '" + propertyOperator + '\'');
        }
        return true;
    }

    private final boolean matchesDependencyValue(Object expectedValue, Object actualValue) {
        if (actualValue instanceof String && ((CharSequence)actualValue).length() > 0) {
            Object object = expectedValue;
            return object instanceof Boolean ? (Boolean)expectedValue : (object instanceof String ? Intrinsics.areEqual((Object)actualValue, (Object)expectedValue) : false);
        }
        if (actualValue instanceof Boolean && expectedValue instanceof Boolean) {
            return Intrinsics.areEqual((Object)actualValue, (Object)expectedValue);
        }
        return false;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/posthog/server/internal/FlagEvaluator$Companion;", "", "()V", "DATE_FORMATTER_NO_SPACE_TZ", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "DATE_FORMATTER_NO_TZ", "DATE_FORMATTER_WITH_SPACE_TZ", "LONG_SCALE", "", "NONE_VALUES_ALLOWED_OPERATORS", "", "Lcom/posthog/internal/PropertyOperator;", "REGEX_COMBINING_MARKS", "Lkotlin/text/Regex;", "REGEX_RELATIVE_DATE", "casefold", "", "input", "posthog-server"})
    public static final class Companion {
        private Companion() {
        }

        private final String casefold(String input) {
            String normalized = Normalizer.normalize(input, Normalizer.Form.NFD);
            Regex regex = REGEX_COMBINING_MARKS;
            Intrinsics.checkNotNullExpressionValue((Object)normalized, (String)"normalized");
            String string = regex.replace((CharSequence)normalized, "").toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/posthog/server/internal/FlagEvaluator$VariantLookupEntry;", "", "key", "", "valueMin", "", "valueMax", "(Ljava/lang/String;DD)V", "getKey", "()Ljava/lang/String;", "getValueMax", "()D", "getValueMin", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "posthog-server"})
    private static final class VariantLookupEntry {
        @NotNull
        private final String key;
        private final double valueMin;
        private final double valueMax;

        public VariantLookupEntry(@NotNull String key, double valueMin, double valueMax) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
            this.valueMin = valueMin;
            this.valueMax = valueMax;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        public final double getValueMin() {
            return this.valueMin;
        }

        public final double getValueMax() {
            return this.valueMax;
        }

        @NotNull
        public final String component1() {
            return this.key;
        }

        public final double component2() {
            return this.valueMin;
        }

        public final double component3() {
            return this.valueMax;
        }

        @NotNull
        public final VariantLookupEntry copy(@NotNull String key, double valueMin, double valueMax) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new VariantLookupEntry(key, valueMin, valueMax);
        }

        public static /* synthetic */ VariantLookupEntry copy$default(VariantLookupEntry variantLookupEntry, String string, double d, double d2, int n, Object object) {
            if ((n & 1) != 0) {
                string = variantLookupEntry.key;
            }
            if ((n & 2) != 0) {
                d = variantLookupEntry.valueMin;
            }
            if ((n & 4) != 0) {
                d2 = variantLookupEntry.valueMax;
            }
            return variantLookupEntry.copy(string, d, d2);
        }

        @NotNull
        public String toString() {
            return "VariantLookupEntry(key=" + this.key + ", valueMin=" + this.valueMin + ", valueMax=" + this.valueMax + ')';
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = result * 31 + Double.hashCode(this.valueMin);
            result = result * 31 + Double.hashCode(this.valueMax);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VariantLookupEntry)) {
                return false;
            }
            VariantLookupEntry variantLookupEntry = (VariantLookupEntry)other;
            if (!Intrinsics.areEqual((Object)this.key, (Object)variantLookupEntry.key)) {
                return false;
            }
            if (Double.compare(this.valueMin, variantLookupEntry.valueMin) != 0) {
                return false;
            }
            return Double.compare(this.valueMax, variantLookupEntry.valueMax) == 0;
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PropertyOperator.values().length];
            try {
                nArray[PropertyOperator.EXACT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyOperator.IS_NOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyOperator.IS_SET.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyOperator.ICONTAINS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyOperator.NOT_ICONTAINS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyOperator.REGEX.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyOperator.NOT_REGEX.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyOperator.GT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyOperator.GTE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyOperator.LT.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyOperator.LTE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyOperator.IS_DATE_BEFORE.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyOperator.IS_DATE_AFTER.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PropertyType.values().length];
            try {
                nArray[PropertyType.COHORT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.FLAG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

