/*
 * Decompiled with CFR 0.152.
 */
package com.posthog.server.internal;

import com.posthog.PostHogConfig;
import com.posthog.PostHogEvent;
import com.posthog.internal.PostHogApi;
import com.posthog.internal.PostHogApiEndpoint;
import com.posthog.internal.PostHogApiError;
import com.posthog.internal.PostHogNetworkStatus;
import com.posthog.internal.PostHogQueueInterface;
import com.posthog.internal.PostHogUtilsKt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u0000 52\u00020\u0001:\u00015B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0014H\u0016J\b\u0010$\u001a\u00020\"H\u0002J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020'H\u0002J\b\u0010)\u001a\u00020\"H\u0016J\b\u0010*\u001a\u00020\"H\u0002J\b\u0010+\u001a\u00020\"H\u0016J\b\u0010,\u001a\u00020\"H\u0002J\b\u0010-\u001a\u00020\"H\u0002J\u0010\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u00020\u000bH\u0002J\b\u00100\u001a\u00020\"H\u0016J\u0010\u00101\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u00102\u001a\u00020\"H\u0016J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\u001404H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/posthog/server/internal/PostHogMemoryQueue;", "Lcom/posthog/internal/PostHogQueueInterface;", "config", "Lcom/posthog/PostHogConfig;", "api", "Lcom/posthog/internal/PostHogApi;", "endpoint", "Lcom/posthog/internal/PostHogApiEndpoint;", "executor", "Ljava/util/concurrent/ExecutorService;", "retryDelaySeconds", "", "maxRetryDelaySeconds", "(Lcom/posthog/PostHogConfig;Lcom/posthog/internal/PostHogApi;Lcom/posthog/internal/PostHogApiEndpoint;Ljava/util/concurrent/ExecutorService;II)V", "delay", "", "getDelay", "()J", "events", "Lkotlin/collections/ArrayDeque;", "Lcom/posthog/PostHogEvent;", "eventsLock", "", "isFlushing", "Ljava/util/concurrent/atomic/AtomicBoolean;", "pausedUntil", "Ljava/util/Date;", "retryCount", "timer", "Ljava/util/Timer;", "timerLock", "timerTask", "Ljava/util/TimerTask;", "add", "", "event", "batchEvents", "calculateDelay", "retry", "", "canFlushBatch", "clear", "executeBatch", "flush", "flushBatch", "flushIfOverThreshold", "isAboveThreshold", "flushAt", "start", "startTimer", "stop", "takeEvents", "", "Companion", "posthog-server"})
@SourceDebugExtension(value={"SMAP\nPostHogMemoryQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostHogMemoryQueue.kt\ncom/posthog/server/internal/PostHogMemoryQueue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,259:1\n1#2:260\n1855#3,2:261\n*S KotlinDebug\n*F\n+ 1 PostHogMemoryQueue.kt\ncom/posthog/server/internal/PostHogMemoryQueue\n*L\n216#1:261,2\n*E\n"})
public final class PostHogMemoryQueue
implements PostHogQueueInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PostHogConfig config;
    @NotNull
    private final PostHogApi api;
    @NotNull
    private final PostHogApiEndpoint endpoint;
    @NotNull
    private final ExecutorService executor;
    private final int retryDelaySeconds;
    private final int maxRetryDelaySeconds;
    @NotNull
    private final ArrayDeque<PostHogEvent> events;
    @NotNull
    private final Object eventsLock;
    @NotNull
    private final Object timerLock;
    @Nullable
    private Date pausedUntil;
    private int retryCount;
    @Nullable
    private volatile Timer timer;
    @Nullable
    private volatile TimerTask timerTask;
    @NotNull
    private AtomicBoolean isFlushing;
    private static final int DEFAULT_RETRY_DELAY_SECONDS = 5;
    private static final int DEFAULT_MAX_RETRY_DELAY_SECONDS = 60;

    public PostHogMemoryQueue(@NotNull PostHogConfig config, @NotNull PostHogApi api, @NotNull PostHogApiEndpoint endpoint, @NotNull ExecutorService executor, int retryDelaySeconds, int maxRetryDelaySeconds) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.config = config;
        this.api = api;
        this.endpoint = endpoint;
        this.executor = executor;
        this.retryDelaySeconds = retryDelaySeconds;
        this.maxRetryDelaySeconds = maxRetryDelaySeconds;
        this.events = new ArrayDeque();
        this.eventsLock = new Object();
        this.timerLock = new Object();
        this.isFlushing = new AtomicBoolean(false);
    }

    public /* synthetic */ PostHogMemoryQueue(PostHogConfig postHogConfig, PostHogApi postHogApi, PostHogApiEndpoint postHogApiEndpoint, ExecutorService executorService, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            n = 5;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 60;
        }
        this(postHogConfig, postHogApi, postHogApiEndpoint, executorService, n, n2);
    }

    private final long getDelay() {
        return this.config.getFlushIntervalSeconds() * 1000;
    }

    public void add(@NotNull PostHogEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PostHogUtilsKt.executeSafely((Executor)this.executor, () -> PostHogMemoryQueue.add$lambda$1(this, event));
    }

    public void flush() {
        if (!this.isAboveThreshold(1)) {
            return;
        }
        if (this.isFlushing.getAndSet(true)) {
            this.config.getLogger().log("Queue is flushing.");
            return;
        }
        this.executeBatch();
    }

    public void start() {
        PostHogUtilsKt.executeSafely((Executor)this.executor, () -> PostHogMemoryQueue.start$lambda$3(this));
    }

    public void stop() {
        PostHogUtilsKt.executeSafely((Executor)this.executor, () -> PostHogMemoryQueue.stop$lambda$5(this));
    }

    public void clear() {
        PostHogUtilsKt.executeSafely((Executor)this.executor, () -> PostHogMemoryQueue.clear$lambda$7(this));
    }

    private final void flushIfOverThreshold() {
        if (this.isAboveThreshold(this.config.getFlushAt())) {
            this.flushBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isAboveThreshold(int flushAt) {
        int n;
        Object object = this.eventsLock;
        synchronized (object) {
            boolean bl = false;
            n = this.events.size();
        }
        int size = n;
        if (size >= flushAt) {
            return true;
        }
        if (size > 0) {
            this.config.getLogger().log("Cannot flush the Queue yet, below the threshold: " + flushAt);
        }
        return false;
    }

    private final boolean canFlushBatch() {
        Date date = this.pausedUntil;
        boolean bl = date != null ? date.after(this.config.getDateProvider().currentDate()) : false;
        if (bl) {
            this.config.getLogger().log("Queue is paused until " + this.pausedUntil);
            return false;
        }
        PostHogNetworkStatus postHogNetworkStatus = this.config.getNetworkStatus();
        boolean bl2 = postHogNetworkStatus != null ? !postHogNetworkStatus.isConnected() : false;
        if (bl2) {
            this.config.getLogger().log("Device is offline.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<PostHogEvent> takeEvents() {
        List eventsToProcess = new ArrayList();
        Object object = this.eventsLock;
        synchronized (object) {
            boolean bl = false;
            int maxToTake = Math.min(this.config.getMaxBatchSize(), this.events.size());
            for (int i = 0; i < maxToTake; ++i) {
                PostHogEvent event;
                int it = i;
                boolean bl2 = false;
                if ((PostHogEvent)this.events.removeFirstOrNull() == null) continue;
                boolean bl3 = false;
                eventsToProcess.add(event);
            }
            Unit unit = Unit.INSTANCE;
        }
        return eventsToProcess;
    }

    private final void flushBatch() {
        if (!this.canFlushBatch()) {
            this.config.getLogger().log("Cannot flush the queue.");
            return;
        }
        if (this.isFlushing.getAndSet(true)) {
            this.config.getLogger().log("Queue is flushing.");
            return;
        }
        this.executeBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void executeBatch() {
        boolean retry = false;
        try {
            this.batchEvents();
            this.retryCount = 0;
        }
        catch (Throwable e) {
            this.config.getLogger().log("Flushing failed: " + e + '.');
            retry = true;
            int n = this.retryCount;
            this.retryCount = n + 1;
        }
        finally {
            this.calculateDelay(retry);
            this.isFlushing.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void batchEvents() throws PostHogApiError, IOException {
        List<PostHogEvent> eventsToProcess = this.takeEvents();
        if (eventsToProcess.isEmpty()) {
            return;
        }
        try {
            this.config.getLogger().log("Flushing " + eventsToProcess.size() + " events.");
            switch (WhenMappings.$EnumSwitchMapping$0[this.endpoint.ordinal()]) {
                case 1: {
                    this.api.batch(eventsToProcess);
                    break;
                }
                case 2: {
                    this.api.snapshot(eventsToProcess);
                }
            }
        }
        catch (PostHogApiError e) {
            if (PostHogUtilsKt.isNetworkingError((Throwable)e) || e.getStatusCode() >= 500) {
                Object object = this.eventsLock;
                synchronized (object) {
                    boolean bl = false;
                    Iterable $this$forEach$iv = CollectionsKt.asReversed(eventsToProcess);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PostHogEvent event = (PostHogEvent)element$iv;
                        boolean bl2 = false;
                        this.events.addFirst((Object)event);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                this.config.getLogger().log("Flushing failed because of a network error, let's try again soon.");
            } else {
                this.config.getLogger().log("Flushing failed: " + (Object)((Object)e));
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startTimer(long delay) {
        Object object = this.timerLock;
        synchronized (object) {
            TimerTask timerTask;
            boolean bl = false;
            TimerTask timerTask2 = this.timerTask;
            if (timerTask2 != null) {
                timerTask2.cancel();
            }
            Timer timer = this.timer;
            if (timer != null) {
                Timer timer2 = timer;
                TimerTask timerTask3 = new TimerTask(this){
                    final /* synthetic */ PostHogMemoryQueue this$0;
                    {
                        this.this$0 = postHogMemoryQueue;
                    }

                    public void run() {
                        TimerTask $this$startTimer_u24lambda_u2415_u24lambda_u2414 = this;
                        boolean bl = false;
                        PostHogMemoryQueue.access$flushBatch(this.this$0);
                        PostHogMemoryQueue.access$startTimer(this.this$0, PostHogMemoryQueue.access$getDelay(this.this$0));
                    }
                };
                timer2.schedule(timerTask3, delay);
                timerTask = timerTask3;
            } else {
                timerTask = null;
            }
            this.timerTask = timerTask;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateDelay(boolean retry) {
        if (retry) {
            void it;
            int delayInSeconds = Math.min(this.retryDelaySeconds * this.retryCount, this.maxRetryDelaySeconds);
            Date date = this.config.getDateProvider().currentDate();
            PostHogMemoryQueue postHogMemoryQueue = this;
            boolean bl = false;
            postHogMemoryQueue.pausedUntil = new Date(it.getTime() + (long)(delayInSeconds * 1000));
            this.config.getLogger().log("Retrying in " + delayInSeconds + " seconds.");
        } else {
            this.pausedUntil = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void add$lambda$1(PostHogMemoryQueue this$0, PostHogEvent $event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        Object removedEvent = null;
        Object object = this$0.eventsLock;
        synchronized (object) {
            boolean bl = false;
            if (this$0.events.size() >= this$0.config.getMaxQueueSize()) {
                removedEvent = this$0.events.removeFirstOrNull();
            }
            this$0.events.addLast((Object)$event);
            Unit unit = Unit.INSTANCE;
        }
        if (removedEvent != null) {
            this$0.config.getLogger().log("Queue is full, the oldest event " + ((PostHogEvent)removedEvent).getEvent() + " was discarded.");
        }
        this$0.config.getLogger().log("Event: " + $event.getEvent() + " was added to the queue.");
        this$0.flushIfOverThreshold();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void start$lambda$3(PostHogMemoryQueue this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = this$0.timerLock;
        synchronized (object) {
            boolean bl = false;
            if (this$0.timer == null) {
                this$0.timer = new Timer();
                this$0.startTimer(this$0.getDelay());
                this$0.config.getLogger().log("Queue timer started.");
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void stop$lambda$5(PostHogMemoryQueue this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = this$0.timerLock;
        synchronized (object) {
            boolean bl = false;
            TimerTask timerTask = this$0.timerTask;
            if (timerTask != null) {
                timerTask.cancel();
            }
            this$0.timerTask = null;
            Timer timer = this$0.timer;
            if (timer != null) {
                timer.cancel();
            }
            this$0.timer = null;
            this$0.config.getLogger().log("Queue timer stopped.");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void clear$lambda$7(PostHogMemoryQueue this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = this$0.eventsLock;
        synchronized (object) {
            boolean bl = false;
            int eventsRemoved = this$0.events.size();
            this$0.events.clear();
            this$0.config.getLogger().log(eventsRemoved + " events cleared from Queue.");
            Unit unit = Unit.INSTANCE;
        }
    }

    public static final /* synthetic */ void access$flushBatch(PostHogMemoryQueue $this) {
        $this.flushBatch();
    }

    public static final /* synthetic */ void access$startTimer(PostHogMemoryQueue $this, long delay) {
        $this.startTimer(delay);
    }

    public static final /* synthetic */ long access$getDelay(PostHogMemoryQueue $this) {
        return $this.getDelay();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/posthog/server/internal/PostHogMemoryQueue$Companion;", "", "()V", "DEFAULT_MAX_RETRY_DELAY_SECONDS", "", "DEFAULT_RETRY_DELAY_SECONDS", "posthog-server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PostHogApiEndpoint.values().length];
            try {
                nArray[PostHogApiEndpoint.BATCH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PostHogApiEndpoint.SNAPSHOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

