/*
 * Decompiled with CFR 0.152.
 */
package com.posthog.server.internal;

import com.posthog.PostHogConfig;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u000e\u001a\u00020\bJ\u0006\u0010\u000f\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/posthog/server/internal/LocalEvaluationPoller;", "", "config", "Lcom/posthog/PostHogConfig;", "pollIntervalSeconds", "", "execute", "Lkotlin/Function0;", "", "(Lcom/posthog/PostHogConfig;ILkotlin/jvm/functions/Function0;)V", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "isStarted", "", "start", "stop", "posthog-server"})
public final class LocalEvaluationPoller {
    @NotNull
    private final PostHogConfig config;
    private final int pollIntervalSeconds;
    @NotNull
    private final Function0<Unit> execute;
    @NotNull
    private final ScheduledExecutorService executor;
    private boolean isStarted;

    public LocalEvaluationPoller(@NotNull PostHogConfig config, int pollIntervalSeconds, @NotNull Function0<Unit> execute) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(execute, (String)"execute");
        this.config = config;
        this.pollIntervalSeconds = pollIntervalSeconds;
        this.execute = execute;
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(LocalEvaluationPoller::executor$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduled\u2026e\n            }\n        }");
        this.executor = scheduledExecutorService;
    }

    public final void start() {
        if (this.isStarted) {
            this.config.getLogger().log("LocalEvaluationPoller already started");
            return;
        }
        this.isStarted = true;
        this.config.getLogger().log("Starting LocalEvaluationPoller with interval " + this.pollIntervalSeconds + 's');
        this.executor.scheduleAtFixedRate(() -> LocalEvaluationPoller.start$lambda$2(this), 0L, this.pollIntervalSeconds, TimeUnit.SECONDS);
    }

    public final void stop() {
        if (!this.isStarted) {
            return;
        }
        this.config.getLogger().log("Stopping LocalEvaluationPoller");
        this.isStarted = false;
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static final Thread executor$lambda$1(Runnable r) {
        Thread thread;
        Thread $this$executor_u24lambda_u241_u24lambda_u240 = thread = new Thread(r, "PostHog-LocalEvaluationPoller");
        boolean bl = false;
        $this$executor_u24lambda_u241_u24lambda_u240.setDaemon(true);
        return thread;
    }

    private static final void start$lambda$2(LocalEvaluationPoller this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            this$0.execute.invoke();
        }
        catch (Throwable e) {
            this$0.config.getLogger().log("Error in LocalEvaluationPoller: " + e.getMessage());
        }
    }
}

