/*
 * Decompiled with CFR 0.152.
 */
package com.posthog.server.internal;

import com.posthog.PostHogConfig;
import com.posthog.PostHogOnFeatureFlags;
import com.posthog.internal.FeatureFlag;
import com.posthog.internal.FeatureFlagMetadata;
import com.posthog.internal.FlagDefinition;
import com.posthog.internal.LocalEvaluationResponse;
import com.posthog.internal.PostHogApi;
import com.posthog.internal.PostHogFeatureFlagsInterface;
import com.posthog.internal.PostHogFlagsResponse;
import com.posthog.internal.PropertyGroup;
import com.posthog.server.internal.FeatureFlagCacheEntry;
import com.posthog.server.internal.FeatureFlagCacheKey;
import com.posthog.server.internal.FlagEvaluator;
import com.posthog.server.internal.InconclusiveMatchException;
import com.posthog.server.internal.LocalEvaluationPoller;
import com.posthog.server.internal.PostHogFeatureFlagCache;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0011\b\u0000\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0007\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\"\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\f2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u001bH\u0002J\b\u0010)\u001a\u00020*H\u0016Jl\u0010+\u001a\u0004\u0018\u00010'2\u0006\u0010%\u001a\u00020\f2\u0006\u0010,\u001a\u00020\f2\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\u00142\u0016\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010'\u0018\u00010\u00142\"\u0010/\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010'0\u0014\u0018\u00010\u0014H\u0002Jk\u00100\u001a\u0004\u0018\u0001012\b\u0010,\u001a\u0004\u0018\u00010\f2\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\u00142\u0016\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010'\u0018\u00010\u00142\"\u0010/\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010'0\u0014\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u00102Jx\u00103\u001a\u0004\u0018\u00010'2\u0006\u0010%\u001a\u00020\f2\b\u00104\u001a\u0004\u0018\u00010'2\b\u0010,\u001a\u0004\u0018\u00010\f2\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\u00142\u0016\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010'\u0018\u00010\u00142\"\u0010/\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010'0\u0014\u0018\u00010\u0014H\u0016Jx\u00105\u001a\u0004\u0018\u00010'2\u0006\u0010%\u001a\u00020\f2\b\u00104\u001a\u0004\u0018\u00010'2\b\u0010,\u001a\u0004\u0018\u00010\f2\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\u00142\u0016\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010'\u0018\u00010\u00142\"\u0010/\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010'0\u0014\u0018\u00010\u0014H\u0016Jr\u00106\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020$\u0018\u00010\u00142\b\u0010,\u001a\u0004\u0018\u00010\f2\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\u00142\u0016\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010'\u0018\u00010\u00142\"\u0010/\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010'0\u0014\u0018\u00010\u0014H\u0016Jp\u00107\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020$\u0018\u00010\u00142\u0006\u0010,\u001a\u00020\f2\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\u00142\u0016\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010'\u0018\u00010\u00142\"\u0010/\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010'0\u0014\u0018\u00010\u0014H\u0002Jz\u00108\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020$\u0018\u00010\u00142\u0006\u0010,\u001a\u00020\f2\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\u00142\u0016\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010'\u0018\u00010\u00142\"\u0010/\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010'0\u0014\u0018\u00010\u00142\b\b\u0002\u00109\u001a\u00020\nH\u0002Jp\u0010:\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020$\u0018\u00010\u00142\u0006\u0010,\u001a\u00020\f2\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\u00142\u0016\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010'\u0018\u00010\u00142\"\u0010/\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010'0\u0014\u0018\u00010\u0014H\u0002Jf\u0010;\u001a\u0004\u0018\u00010\f2\b\u0010,\u001a\u0004\u0018\u00010\f2\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\u00142\u0016\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010'\u0018\u00010\u00142\"\u0010/\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010'0\u0014\u0018\u00010\u0014H\u0016J\u0006\u0010<\u001a\u00020*J\b\u0010=\u001a\u00020\nH\u0002Jl\u0010>\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\f2\u0006\u0010,\u001a\u00020\f2\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\u00142\u0016\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010'\u0018\u00010\u00142\"\u0010/\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010'0\u0014\u0018\u00010\u0014H\u0002J\b\u0010?\u001a\u00020*H\u0016J\b\u0010@\u001a\u00020*H\u0002J\b\u0010A\u001a\u00020*H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/posthog/server/internal/PostHogFeatureFlags;", "Lcom/posthog/internal/PostHogFeatureFlagsInterface;", "config", "Lcom/posthog/PostHogConfig;", "api", "Lcom/posthog/internal/PostHogApi;", "cacheMaxAgeMs", "", "cacheMaxSize", "localEvaluation", "", "personalApiKey", "", "pollIntervalSeconds", "onFeatureFlags", "Lcom/posthog/PostHogOnFeatureFlags;", "(Lcom/posthog/PostHogConfig;Lcom/posthog/internal/PostHogApi;IIZLjava/lang/String;ILcom/posthog/PostHogOnFeatureFlags;)V", "cache", "Lcom/posthog/server/internal/PostHogFeatureFlagCache;", "cohorts", "", "Lcom/posthog/internal/PropertyGroup;", "definitionsLoaded", "evaluator", "Lcom/posthog/server/internal/FlagEvaluator;", "featureFlags", "", "Lcom/posthog/internal/FlagDefinition;", "flagDefinitions", "groupTypeMapping", "isLoading", "loadLock", "Ljava/lang/Object;", "poller", "Lcom/posthog/server/internal/LocalEvaluationPoller;", "buildFeatureFlagFromResult", "Lcom/posthog/internal/FeatureFlag;", "key", "result", "", "flagDef", "clear", "", "computeFlagLocally", "distinctId", "groups", "personProperties", "groupProperties", "getEvaluatedAt", "", "(Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;)Ljava/lang/Long;", "getFeatureFlag", "defaultValue", "getFeatureFlagPayload", "getFeatureFlags", "getFeatureFlagsFromCache", "getFeatureFlagsFromLocalEvaluation", "onlyEvaluateLocally", "getFeatureFlagsFromRemote", "getRequestId", "loadFeatureFlagDefinitions", "localEvaluationEnabled", "resolveFeatureFlag", "shutDown", "startPoller", "stopPoller", "posthog-server"})
@SourceDebugExtension(value={"SMAP\nPostHogFeatureFlags.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostHogFeatureFlags.kt\ncom/posthog/server/internal/PostHogFeatureFlags\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,547:1\n1194#2,2:548\n1222#2,4:550\n*S KotlinDebug\n*F\n+ 1 PostHogFeatureFlags.kt\ncom/posthog/server/internal/PostHogFeatureFlags\n*L\n348#1:548,2\n348#1:550,4\n*E\n"})
public final class PostHogFeatureFlags
implements PostHogFeatureFlagsInterface {
    @NotNull
    private final PostHogConfig config;
    @NotNull
    private final PostHogApi api;
    private final int cacheMaxAgeMs;
    private final int cacheMaxSize;
    private final boolean localEvaluation;
    @Nullable
    private final String personalApiKey;
    private final int pollIntervalSeconds;
    @Nullable
    private final PostHogOnFeatureFlags onFeatureFlags;
    @NotNull
    private final PostHogFeatureFlagCache cache;
    @Nullable
    private volatile List<FlagDefinition> featureFlags;
    @Nullable
    private volatile Map<String, FlagDefinition> flagDefinitions;
    @Nullable
    private volatile Map<String, PropertyGroup> cohorts;
    @Nullable
    private volatile Map<String, String> groupTypeMapping;
    @NotNull
    private final FlagEvaluator evaluator;
    @Nullable
    private LocalEvaluationPoller poller;
    private boolean definitionsLoaded;
    private volatile boolean isLoading;
    @NotNull
    private final Object loadLock;

    public PostHogFeatureFlags(@NotNull PostHogConfig config, @NotNull PostHogApi api, int cacheMaxAgeMs, int cacheMaxSize, boolean localEvaluation, @Nullable String personalApiKey, int pollIntervalSeconds, @Nullable PostHogOnFeatureFlags onFeatureFlags) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.config = config;
        this.api = api;
        this.cacheMaxAgeMs = cacheMaxAgeMs;
        this.cacheMaxSize = cacheMaxSize;
        this.localEvaluation = localEvaluation;
        this.personalApiKey = personalApiKey;
        this.pollIntervalSeconds = pollIntervalSeconds;
        this.onFeatureFlags = onFeatureFlags;
        this.cache = new PostHogFeatureFlagCache(this.cacheMaxSize, this.cacheMaxAgeMs);
        this.evaluator = new FlagEvaluator(this.config);
        this.loadLock = new Object();
        try {
            this.startPoller();
        }
        catch (Throwable e) {
            this.config.getLogger().log("Poller failed to init: " + e);
            this.stopPoller();
        }
        if (!this.localEvaluation) {
            try {
                PostHogOnFeatureFlags postHogOnFeatureFlags = this.onFeatureFlags;
                if (postHogOnFeatureFlags != null) {
                    postHogOnFeatureFlags.loaded();
                }
            }
            catch (Throwable e) {
                this.config.getLogger().log("Error in onFeatureFlags callback: " + e.getMessage());
            }
        }
    }

    public /* synthetic */ PostHogFeatureFlags(PostHogConfig postHogConfig, PostHogApi postHogApi, int n, int n2, boolean bl, String string, int n3, PostHogOnFeatureFlags postHogOnFeatureFlags, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x10) != 0) {
            bl = false;
        }
        if ((n4 & 0x20) != 0) {
            string = null;
        }
        if ((n4 & 0x40) != 0) {
            n3 = 30;
        }
        if ((n4 & 0x80) != 0) {
            postHogOnFeatureFlags = null;
        }
        this(postHogConfig, postHogApi, n, n2, bl, string, n3, postHogOnFeatureFlags);
    }

    @Nullable
    public Object getFeatureFlag(@NotNull String key, @Nullable Object defaultValue, @Nullable String distinctId, @Nullable Map<String, String> groups, @Nullable Map<String, ? extends Object> personProperties, @Nullable Map<String, ? extends Map<String, ? extends Object>> groupProperties) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (distinctId == null) {
            return defaultValue;
        }
        FeatureFlag flag = this.resolveFeatureFlag(key, distinctId, groups, personProperties, groupProperties);
        Object object = flag;
        if (object == null || (object = object.getVariant()) == null) {
            FeatureFlag featureFlag = flag;
            object = featureFlag != null ? Boolean.valueOf(featureFlag.getEnabled()) : defaultValue;
        }
        return object;
    }

    @Nullable
    public Object getFeatureFlagPayload(@NotNull String key, @Nullable Object defaultValue, @Nullable String distinctId, @Nullable Map<String, String> groups, @Nullable Map<String, ? extends Object> personProperties, @Nullable Map<String, ? extends Map<String, ? extends Object>> groupProperties) {
        String string;
        FeatureFlagMetadata featureFlagMetadata;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (distinctId == null) {
            return defaultValue;
        }
        FeatureFlag featureFlag = this.resolveFeatureFlag(key, distinctId, groups, personProperties, groupProperties);
        return featureFlag != null && (featureFlagMetadata = featureFlag.getMetadata()) != null && (string = featureFlagMetadata.getPayload()) != null ? string : defaultValue;
    }

    private final FeatureFlag resolveFeatureFlag(String key, String distinctId, Map<String, String> groups, Map<String, ? extends Object> personProperties, Map<String, ? extends Map<String, ? extends Object>> groupProperties) {
        Map<String, FeatureFlag> cachedFlags = this.getFeatureFlagsFromCache(distinctId, groups, personProperties, groupProperties);
        if (cachedFlags != null) {
            this.config.getLogger().log("Feature flags cache hit for distinctId: " + distinctId);
            FeatureFlag flag = cachedFlags.get(key);
            if (flag != null) {
                return flag;
            }
        }
        if (this.localEvaluation) {
            FlagDefinition flagDef;
            if (this.flagDefinitions == null && !this.definitionsLoaded) {
                this.config.getLogger().log("Flag definitions not loaded, loading now");
                this.loadFeatureFlagDefinitions();
            }
            Map<String, FlagDefinition> map = this.flagDefinitions;
            FlagDefinition flagDefinition = flagDef = map != null ? map.get(key) : null;
            if (flagDef != null) {
                try {
                    this.config.getLogger().log("Attempting local evaluation for flag '" + key + "' for distinctId: " + distinctId);
                    Map map2 = personProperties;
                    if (map2 == null) {
                        map2 = MapsKt.emptyMap();
                    }
                    Map props = MapsKt.toMutableMap(map2);
                    Object result = this.computeFlagLocally(key, distinctId, groups, props, groupProperties);
                    FeatureFlag flag = this.buildFeatureFlagFromResult(key, result, flagDef);
                    this.config.getLogger().log("Local evaluation successful for flag '" + key + '\'');
                    return flag;
                }
                catch (InconclusiveMatchException e) {
                    this.config.getLogger().log("Local evaluation inconclusive for flag '" + key + "': " + e.getMessage());
                }
                catch (Throwable e) {
                    this.config.getLogger().log("Local evaluation failed for flag '" + key + "': " + e.getMessage());
                }
            }
        }
        this.config.getLogger().log("Feature flag cache miss for distinctId: " + distinctId + ", calling API");
        Map<String, FeatureFlag> map = this.getFeatureFlagsFromRemote(distinctId, groups, personProperties, groupProperties);
        return map != null ? map.get(key) : null;
    }

    private final Map<String, FeatureFlag> getFeatureFlagsFromCache(String distinctId, Map<String, String> groups, Map<String, ? extends Object> personProperties, Map<String, ? extends Map<String, ? extends Object>> groupProperties) {
        FeatureFlagCacheKey cacheKey = new FeatureFlagCacheKey(distinctId, groups, personProperties, groupProperties);
        return this.cache.get(cacheKey);
    }

    private final Map<String, FeatureFlag> getFeatureFlagsFromLocalEvaluation(String distinctId, Map<String, String> groups, Map<String, ? extends Object> personProperties, Map<String, ? extends Map<String, ? extends Object>> groupProperties, boolean onlyEvaluateLocally) {
        Map<String, FlagDefinition> currentFlagDefinitions;
        if (!this.localEvaluation) {
            return null;
        }
        if (this.flagDefinitions == null && !this.definitionsLoaded) {
            this.config.getLogger().log("Flag definitions not loaded, loading now");
            this.loadFeatureFlagDefinitions();
        }
        if ((currentFlagDefinitions = this.flagDefinitions) == null) {
            return null;
        }
        this.config.getLogger().log("Attempting local evaluation for distinctId: " + distinctId);
        Map localFlags = new LinkedHashMap();
        Map map = personProperties;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map props = MapsKt.toMutableMap(map);
        for (Map.Entry<String, FlagDefinition> entry : currentFlagDefinitions.entrySet()) {
            String key = entry.getKey();
            FlagDefinition flagDef = entry.getValue();
            try {
                Object result = this.computeFlagLocally(key, distinctId, groups, props, groupProperties);
                localFlags.put(key, this.buildFeatureFlagFromResult(key, result, flagDef));
            }
            catch (InconclusiveMatchException e) {
                this.config.getLogger().log("Local evaluation inconclusive for flag '" + key + "': " + e.getMessage());
                if (onlyEvaluateLocally) continue;
                return null;
            }
        }
        this.config.getLogger().log("Local evaluation successful for " + localFlags.size() + " flags");
        return localFlags;
    }

    static /* synthetic */ Map getFeatureFlagsFromLocalEvaluation$default(PostHogFeatureFlags postHogFeatureFlags, String string, Map map, Map map2, Map map3, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return postHogFeatureFlags.getFeatureFlagsFromLocalEvaluation(string, map, map2, map3, bl);
    }

    private final Map<String, FeatureFlag> getFeatureFlagsFromRemote(String distinctId, Map<String, String> groups, Map<String, ? extends Object> personProperties, Map<String, ? extends Map<String, ? extends Object>> groupProperties) {
        Map map;
        FeatureFlagCacheKey cacheKey = new FeatureFlagCacheKey(distinctId, groups, personProperties, groupProperties);
        Map<String, FeatureFlag> cachedFlags = this.cache.get(cacheKey);
        if (cachedFlags != null) {
            return cachedFlags;
        }
        try {
            PostHogFlagsResponse response;
            PostHogFlagsResponse postHogFlagsResponse = response = this.api.flags(distinctId, null, groups, personProperties, groupProperties);
            Map flags = postHogFlagsResponse != null ? postHogFlagsResponse.getFlags() : null;
            PostHogFlagsResponse postHogFlagsResponse2 = response;
            PostHogFlagsResponse postHogFlagsResponse3 = response;
            this.cache.put(cacheKey, flags, postHogFlagsResponse2 != null ? postHogFlagsResponse2.getRequestId() : null, postHogFlagsResponse3 != null ? postHogFlagsResponse3.getEvaluatedAt() : null);
            map = flags;
        }
        catch (Throwable e) {
            this.config.getLogger().log("Loading remote feature flags failed: " + e);
            map = null;
        }
        return map;
    }

    @Nullable
    public Map<String, FeatureFlag> getFeatureFlags(@Nullable String distinctId, @Nullable Map<String, String> groups, @Nullable Map<String, ? extends Object> personProperties, @Nullable Map<String, ? extends Map<String, ? extends Object>> groupProperties) {
        if (distinctId == null) {
            this.config.getLogger().log("getFeatureFlags called but no distinctId available for API call");
            return null;
        }
        Map<String, FeatureFlag> cached = this.getFeatureFlagsFromCache(distinctId, groups, personProperties, groupProperties);
        if (cached != null) {
            return cached;
        }
        Map localFlags = PostHogFeatureFlags.getFeatureFlagsFromLocalEvaluation$default(this, distinctId, groups, personProperties, groupProperties, false, 16, null);
        if (localFlags != null) {
            return localFlags;
        }
        return this.getFeatureFlagsFromRemote(distinctId, groups, personProperties, groupProperties);
    }

    public void clear() {
        this.cache.clear();
        this.config.getLogger().log("Feature flags cache cleared");
    }

    public void shutDown() {
        this.stopPoller();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void loadFeatureFlagDefinitions() {
        block32: {
            Object $i$a$-synchronized-PostHogFeatureFlags$loadFeatureFlagDefinitions$4;
            if (!this.localEvaluation || this.personalApiKey == null) {
                return;
            }
            boolean wasWaitingForLoad = false;
            Object object = this.loadLock;
            synchronized (object) {
                boolean bl = false;
                while (this.isLoading) {
                    wasWaitingForLoad = true;
                    try {
                        this.loadLock.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        this.config.getLogger().log("Interrupted while waiting for flag definitions to load");
                        return;
                    }
                }
                if (wasWaitingForLoad && this.flagDefinitions != null) {
                    this.config.getLogger().log("Definitions loaded by another thread, skipping duplicate request");
                    return;
                }
                this.isLoading = true;
                $i$a$-synchronized-PostHogFeatureFlags$loadFeatureFlagDefinitions$4 = Unit.INSTANCE;
            }
            try {
                this.config.getLogger().log("Loading feature flags for local evaluation");
                LocalEvaluationResponse apiResponse = this.api.localEvaluation(this.personalApiKey);
                if (apiResponse == null) break block32;
                $i$a$-synchronized-PostHogFeatureFlags$loadFeatureFlagDefinitions$4 = this.loadLock;
                synchronized ($i$a$-synchronized-PostHogFeatureFlags$loadFeatureFlagDefinitions$4) {
                    Unit unit;
                    Map map;
                    boolean $i$a$-synchronized-PostHogFeatureFlags$loadFeatureFlagDefinitions$52 = false;
                    this.featureFlags = apiResponse.getFlags();
                    PostHogFeatureFlags postHogFeatureFlags = this;
                    List list = apiResponse.getFlags();
                    if (list != null) {
                        void $this$associateByTo$iv$iv;
                        void $this$associateBy$iv;
                        Iterable iterable = list;
                        PostHogFeatureFlags postHogFeatureFlags2 = postHogFeatureFlags;
                        boolean $i$f$associateBy = false;
                        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                        void var10_27 = $this$associateBy$iv;
                        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                        boolean $i$f$associateByTo = false;
                        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                            void it;
                            FlagDefinition flagDefinition = (FlagDefinition)element$iv$iv;
                            Map map2 = destination$iv$iv;
                            boolean bl = false;
                            map2.put(it.getKey(), element$iv$iv);
                        }
                        map = destination$iv$iv;
                        postHogFeatureFlags = postHogFeatureFlags2;
                    } else {
                        map = null;
                    }
                    postHogFeatureFlags.flagDefinitions = map;
                    this.cohorts = apiResponse.getCohorts();
                    this.groupTypeMapping = apiResponse.getGroupTypeMapping();
                    List list2 = apiResponse.getFlags();
                    this.config.getLogger().log("Loaded " + (list2 != null ? list2.size() : 0) + " feature flags for local evaluation");
                    this.definitionsLoaded = true;
                    try {
                        Unit unit2;
                        PostHogOnFeatureFlags postHogOnFeatureFlags = this.onFeatureFlags;
                        if (postHogOnFeatureFlags != null) {
                            postHogOnFeatureFlags.loaded();
                            unit2 = Unit.INSTANCE;
                        } else {
                            unit2 = null;
                        }
                        unit = unit2;
                    }
                    catch (Throwable e) {
                        this.config.getLogger().log("Error in onFeatureFlags callback: " + e.getMessage());
                        unit = Unit.INSTANCE;
                    }
                    Unit $i$a$-synchronized-PostHogFeatureFlags$loadFeatureFlagDefinitions$52 = unit;
                }
            }
            catch (Throwable e) {
                this.config.getLogger().log("Failed to load feature flags for local evaluation: " + e.getMessage());
            }
            finally {
                object = this.loadLock;
                synchronized (object) {
                    boolean $i$a$-synchronized-PostHogFeatureFlags$loadFeatureFlagDefinitions$62 = false;
                    this.isLoading = false;
                    this.loadLock.notifyAll();
                    Unit $i$a$-synchronized-PostHogFeatureFlags$loadFeatureFlagDefinitions$62 = Unit.INSTANCE;
                }
            }
        }
    }

    private final FeatureFlag buildFeatureFlagFromResult(String key, Object result, FlagDefinition flagDef) {
        Map map;
        Object object = result;
        Pair pair = object instanceof String ? TuplesKt.to((Object)true, (Object)result) : (object instanceof Boolean ? TuplesKt.to((Object)result, null) : TuplesKt.to((Object)false, null));
        boolean enabled = (Boolean)pair.component1();
        String variant = (String)pair.component2();
        String payload = result != null ? ((map = flagDef.getFilters().getPayloads()) != null && (map = map.get(result.toString())) != null ? map.toString() : null) : null;
        return new FeatureFlag(key, enabled, variant, new FeatureFlagMetadata(flagDef.getId(), payload, flagDef.getVersion()), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startPoller() {
        if (!this.localEvaluation) {
            return;
        }
        Object object = this.personalApiKey;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            this.config.getLogger().log("Local evaluation enabled but no personal API key provided");
            return;
        }
        object = this;
        synchronized (object) {
            boolean bl = false;
            if (this.poller == null) {
                LocalEvaluationPoller localEvaluationPoller = this.poller = new LocalEvaluationPoller(this.config, this.pollIntervalSeconds, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ PostHogFeatureFlags this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.loadFeatureFlagDefinitions();
                    }
                }));
                if (localEvaluationPoller != null) {
                    localEvaluationPoller.start();
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stopPoller() {
        PostHogFeatureFlags postHogFeatureFlags = this;
        synchronized (postHogFeatureFlags) {
            boolean bl = false;
            LocalEvaluationPoller localEvaluationPoller = this.poller;
            if (localEvaluationPoller != null) {
                localEvaluationPoller.stop();
            }
            this.poller = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final Object computeFlagLocally(String key, String distinctId, Map<String, String> groups, Map<String, ? extends Object> personProperties, Map<String, ? extends Map<String, ? extends Object>> groupProperties) {
        Map map;
        Pair pair;
        Map<String, FlagDefinition> map2 = this.flagDefinitions;
        if (map2 == null) {
            return null;
        }
        Map<String, FlagDefinition> flags = map2;
        FlagDefinition flagDefinition = flags.get(key);
        if (flagDefinition == null) {
            return null;
        }
        FlagDefinition flag = flagDefinition;
        if (!flag.getActive()) {
            return false;
        }
        Integer aggregationGroupIndex = flag.getFilters().getAggregationGroupTypeIndex();
        if (aggregationGroupIndex != null) {
            String groupKey;
            String groupTypeName;
            Map<String, String> map3 = this.groupTypeMapping;
            String string = groupTypeName = map3 != null ? map3.get(aggregationGroupIndex.toString()) : null;
            if (groupTypeName == null) {
                this.config.getLogger().log("Unknown group type index " + aggregationGroupIndex + " for flag '" + key + '\'');
                throw new InconclusiveMatchException("Flag has unknown group type index");
            }
            Map<String, String> map4 = groups;
            String string2 = groupKey = map4 != null ? map4.get(groupTypeName) : null;
            if (groupKey == null) {
                this.config.getLogger().log("Can't compute group flag '" + key + "' without group '" + groupTypeName + '\'');
                return false;
            }
            pair = new Pair((Object)groupKey, groupProperties);
        } else {
            pair = new Pair((Object)distinctId, personProperties);
        }
        Pair pair2 = pair;
        String evaluationId = (String)pair2.component1();
        Map evaluationProperties = (Map)pair2.component2();
        Map evaluationCache = new LinkedHashMap();
        Map map5 = evaluationProperties;
        if (map5 == null) {
            map5 = MapsKt.emptyMap();
        }
        if ((map = this.cohorts) == null) {
            map = MapsKt.emptyMap();
        }
        return this.evaluator.matchFeatureFlagProperties(flag, evaluationId, map5, map, flags, evaluationCache);
    }

    private final boolean localEvaluationEnabled() {
        CharSequence charSequence;
        return this.localEvaluation && !((charSequence = (CharSequence)this.personalApiKey) == null || StringsKt.isBlank((CharSequence)charSequence));
    }

    @Nullable
    public String getRequestId(@Nullable String distinctId, @Nullable Map<String, String> groups, @Nullable Map<String, ? extends Object> personProperties, @Nullable Map<String, ? extends Map<String, ? extends Object>> groupProperties) {
        if (distinctId == null) {
            return null;
        }
        FeatureFlagCacheKey cacheKey = new FeatureFlagCacheKey(distinctId, groups, personProperties, groupProperties);
        FeatureFlagCacheEntry featureFlagCacheEntry = this.cache.getEntry(cacheKey);
        return featureFlagCacheEntry != null ? featureFlagCacheEntry.getRequestId() : null;
    }

    @Nullable
    public Long getEvaluatedAt(@Nullable String distinctId, @Nullable Map<String, String> groups, @Nullable Map<String, ? extends Object> personProperties, @Nullable Map<String, ? extends Map<String, ? extends Object>> groupProperties) {
        if (distinctId == null) {
            return null;
        }
        FeatureFlagCacheKey cacheKey = new FeatureFlagCacheKey(distinctId, groups, personProperties, groupProperties);
        FeatureFlagCacheEntry featureFlagCacheEntry = this.cache.getEntry(cacheKey);
        return featureFlagCacheEntry != null ? featureFlagCacheEntry.getEvaluatedAt() : null;
    }
}

