/*
 * Decompiled with CFR 0.152.
 */
package com.postmarkapp.postmark.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.postmarkapp.postmark.client.BaseApiClient;
import com.postmarkapp.postmark.client.HttpClient;
import com.postmarkapp.postmark.client.Parameters;
import com.postmarkapp.postmark.client.data.model.RequestResponse;
import com.postmarkapp.postmark.client.data.model.bounces.Bounce;
import com.postmarkapp.postmark.client.data.model.bounces.BounceDump;
import com.postmarkapp.postmark.client.data.model.bounces.Bounces;
import com.postmarkapp.postmark.client.data.model.bounces.DeliveryStats;
import com.postmarkapp.postmark.client.data.model.message.Message;
import com.postmarkapp.postmark.client.data.model.message.MessageResponse;
import com.postmarkapp.postmark.client.data.model.messages.InboundMessageDetails;
import com.postmarkapp.postmark.client.data.model.messages.InboundMessages;
import com.postmarkapp.postmark.client.data.model.messages.OutboundMessageClicks;
import com.postmarkapp.postmark.client.data.model.messages.OutboundMessageDetails;
import com.postmarkapp.postmark.client.data.model.messages.OutboundMessageDump;
import com.postmarkapp.postmark.client.data.model.messages.OutboundMessageOpens;
import com.postmarkapp.postmark.client.data.model.messages.OutboundMessages;
import com.postmarkapp.postmark.client.data.model.server.Server;
import com.postmarkapp.postmark.client.data.model.stats.OutboundBounceStats;
import com.postmarkapp.postmark.client.data.model.stats.OutboundClickLocationStats;
import com.postmarkapp.postmark.client.data.model.stats.OutboundClickPlatformStats;
import com.postmarkapp.postmark.client.data.model.stats.OutboundClickStats;
import com.postmarkapp.postmark.client.data.model.stats.OutboundOpenPlatformStats;
import com.postmarkapp.postmark.client.data.model.stats.OutboundOpenStats;
import com.postmarkapp.postmark.client.data.model.stats.OutboundSendStats;
import com.postmarkapp.postmark.client.data.model.stats.OutboundSpamStats;
import com.postmarkapp.postmark.client.data.model.stats.OutboundStats;
import com.postmarkapp.postmark.client.data.model.stats.OutboundTrackedStats;
import com.postmarkapp.postmark.client.data.model.streams.MessageStream;
import com.postmarkapp.postmark.client.data.model.streams.MessageStreamArchiveResponse;
import com.postmarkapp.postmark.client.data.model.streams.MessageStreamUnarchiveResponse;
import com.postmarkapp.postmark.client.data.model.streams.MessageStreams;
import com.postmarkapp.postmark.client.data.model.suppressions.SuppressionEntries;
import com.postmarkapp.postmark.client.data.model.suppressions.SuppressionStatuses;
import com.postmarkapp.postmark.client.data.model.suppressions.Suppressions;
import com.postmarkapp.postmark.client.data.model.templates.BaseTemplate;
import com.postmarkapp.postmark.client.data.model.templates.Template;
import com.postmarkapp.postmark.client.data.model.templates.TemplateContent;
import com.postmarkapp.postmark.client.data.model.templates.TemplateToValidate;
import com.postmarkapp.postmark.client.data.model.templates.TemplateValidation;
import com.postmarkapp.postmark.client.data.model.templates.TemplatedMessage;
import com.postmarkapp.postmark.client.data.model.templates.Templates;
import com.postmarkapp.postmark.client.data.model.triggers.InboundRule;
import com.postmarkapp.postmark.client.data.model.triggers.InboundRuleResponse;
import com.postmarkapp.postmark.client.data.model.triggers.InboundRules;
import com.postmarkapp.postmark.client.data.model.webhooks.Webhook;
import com.postmarkapp.postmark.client.data.model.webhooks.Webhooks;
import com.postmarkapp.postmark.client.exception.PostmarkException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiClient
extends BaseApiClient {
    private final String bouncesEndpoint = "/bounces/";
    private final String templatesEndpoint = "/templates/";
    private final String serverEndpoint = "/server/";
    private final String outboundMessagesEndpoint = "/messages/outbound/";
    private final String inboundMessagesEndpoint = "/messages/inbound/";
    private final String outboundStatsEndpoint = "/stats/outbound/";
    private final String triggerInboundRulesEndpoint = "/triggers/inboundRules/";
    private final String sendingEndpoint = "/email/";
    private final String webhooksEndpoint = "/webhooks/";
    private final String suppressionsEndpoint = "/suppressions/";
    private final String messageStreamsEndpoint = "/message-streams/";

    public ApiClient(String baseUrl, Map<String, Object> headers) {
        super(baseUrl, headers);
    }

    public ApiClient(String baseUrl, Map<String, Object> headers, boolean secureConnection) {
        super(baseUrl, headers, secureConnection);
    }

    public MessageResponse deliverMessage(Message data) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.POST, this.getEndpointUrl("/email/"), data);
        return this.dataHandler.fromJson(response, MessageResponse.class);
    }

    public List<MessageResponse> deliverMessage(List<Message> data) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.POST, this.getEndpointUrl("/email/batch"), data);
        return this.dataHandler.fromJson(response, new TypeReference<List<MessageResponse>>(){});
    }

    public DeliveryStats getDeliveryStats() throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/deliveryStats/"));
        return this.dataHandler.fromJson(response, DeliveryStats.class);
    }

    public Bounces getBounces(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/bounces/" + parameters));
        return this.dataHandler.fromJson(response, Bounces.class);
    }

    public Bounce getBounce(Long id) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/bounces/" + id));
        return this.dataHandler.fromJson(response, Bounce.class);
    }

    public BounceDump getBounceDump(Long id) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/bounces/" + id + "/dump"));
        return this.dataHandler.fromJson(response, BounceDump.class);
    }

    public String activateBounce(Long id) throws PostmarkException, IOException {
        return this.execute(HttpClient.REQUEST_TYPES.PUT, this.getEndpointUrl("/bounces/" + id + "/activate"));
    }

    public Template getTemplate(Integer id) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/templates/" + id));
        return this.dataHandler.fromJson(response, Template.class);
    }

    public Template getTemplate(String alias) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/templates/" + alias));
        return this.dataHandler.fromJson(response, Template.class);
    }

    public BaseTemplate createTemplate(TemplateContent data) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.POST, this.getEndpointUrl("/templates/"), data);
        return this.dataHandler.fromJson(response, BaseTemplate.class);
    }

    public BaseTemplate setTemplate(Integer id, TemplateContent data) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.PUT, this.getEndpointUrl("/templates/" + id), data);
        return this.dataHandler.fromJson(response, BaseTemplate.class);
    }

    public BaseTemplate setTemplate(String alias, TemplateContent data) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.PUT, this.getEndpointUrl("/templates/" + alias), data);
        return this.dataHandler.fromJson(response, BaseTemplate.class);
    }

    public Templates getTemplates(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/templates/" + parameters));
        return this.dataHandler.fromJson(response, Templates.class);
    }

    public String deleteTemplate(Integer id) throws PostmarkException, IOException {
        return this.execute(HttpClient.REQUEST_TYPES.DELETE, this.getEndpointUrl("/templates/" + id));
    }

    public String deleteTemplate(String alias) throws PostmarkException, IOException {
        return this.execute(HttpClient.REQUEST_TYPES.DELETE, this.getEndpointUrl("/templates/" + alias));
    }

    public TemplateValidation validateTemplate(TemplateToValidate data) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.POST, this.getEndpointUrl("/templates/validate"), data);
        return this.dataHandler.fromJson(response, TemplateValidation.class);
    }

    @Deprecated
    public MessageResponse deliverMessage(TemplatedMessage data) throws PostmarkException, IOException {
        return this.deliverMessageWithTemplate(data);
    }

    public MessageResponse deliverMessageWithTemplate(TemplatedMessage data) throws PostmarkException, IOException {
        this.setTemplateModelToObject(data);
        String response = this.execute(HttpClient.REQUEST_TYPES.POST, this.getEndpointUrl("/email/withTemplate"), data);
        return this.dataHandler.fromJson(response, MessageResponse.class);
    }

    public List<MessageResponse> deliverMessageWithTemplate(List<TemplatedMessage> data) throws PostmarkException, IOException {
        HashMap<String, List<TemplatedMessage>> dataToSend = new HashMap<String, List<TemplatedMessage>>();
        dataToSend.put("Messages", data);
        for (TemplatedMessage templateMessage : data) {
            this.setTemplateModelToObject(templateMessage);
        }
        String response = this.execute(HttpClient.REQUEST_TYPES.POST, this.getEndpointUrl("/email/batchWithTemplates"), dataToSend);
        return this.dataHandler.fromJson(response, new TypeReference<List<MessageResponse>>(){});
    }

    private void setTemplateModelToObject(TemplatedMessage data) throws IOException {
        if (data.getTemplateModel().getClass() == String.class) {
            data.setTemplateModel(this.dataHandler.fromJson(data.getTemplateModel().toString(), Object.class));
        }
    }

    public Server getServer() throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/server/"));
        return this.dataHandler.fromJson(response, Server.class);
    }

    public Server setServer(Server data) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.PUT, this.getEndpointUrl("/server/"), data);
        return this.dataHandler.fromJson(response, Server.class);
    }

    public OutboundMessages getMessages(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/messages/outbound/" + parameters));
        return this.dataHandler.fromJson(response, OutboundMessages.class);
    }

    public OutboundMessageDetails getMessageDetails(String id) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/messages/outbound/" + id + "/details"));
        return this.dataHandler.fromJson(response, OutboundMessageDetails.class);
    }

    public OutboundMessageDetails getMessageDetails(String id, Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/messages/outbound/" + id + "/details" + parameters));
        return this.dataHandler.fromJson(response, OutboundMessageDetails.class);
    }

    public OutboundMessageDump getMessageDump(String id) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/messages/outbound/" + id + "/dump"));
        return this.dataHandler.fromJson(response, OutboundMessageDump.class);
    }

    public OutboundMessageOpens getMessageOpens(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/messages/outbound/opens" + parameters));
        return this.dataHandler.fromJson(response, OutboundMessageOpens.class);
    }

    public OutboundMessageOpens getMessageOpens(String id, Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/messages/outbound/opens/" + id + parameters));
        return this.dataHandler.fromJson(response, OutboundMessageOpens.class);
    }

    public OutboundMessageClicks getMessageClicks(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/messages/outbound/clicks" + parameters));
        return this.dataHandler.fromJson(response, OutboundMessageClicks.class);
    }

    public OutboundMessageClicks getMessageClicks(String id, Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/messages/outbound/clicks/" + id + parameters));
        return this.dataHandler.fromJson(response, OutboundMessageClicks.class);
    }

    public InboundMessages getInboundMessages(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/messages/inbound/" + parameters));
        return this.dataHandler.fromJson(response, InboundMessages.class);
    }

    public InboundMessageDetails getInboundMessageDetails(String id) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/messages/inbound/" + id + "/details"));
        return this.dataHandler.fromJson(response, InboundMessageDetails.class);
    }

    public RequestResponse bypassInboundMessage(String id) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.PUT, this.getEndpointUrl("/messages/inbound/" + id + "/bypass"));
        return this.dataHandler.fromJson(response, RequestResponse.class);
    }

    public RequestResponse retryFailedInboundMessage(String id) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.PUT, this.getEndpointUrl("/messages/inbound/" + id + "/retry"));
        return this.dataHandler.fromJson(response, RequestResponse.class);
    }

    public OutboundStats getOutboundStats(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/stats/outbound/" + parameters));
        return this.dataHandler.fromJson(response, OutboundStats.class);
    }

    public OutboundSendStats getOutboundSendStats(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/stats/outbound/sends" + parameters));
        return this.dataHandler.fromJson(response, OutboundSendStats.class);
    }

    public OutboundBounceStats getOutboundBounceStats(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/stats/outbound/bounces" + parameters));
        return this.dataHandler.fromJson(response, OutboundBounceStats.class);
    }

    public OutboundSpamStats getOutboundSpamStats(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/stats/outbound/spam" + parameters));
        return this.dataHandler.fromJson(response, OutboundSpamStats.class);
    }

    public OutboundTrackedStats getOutboundTrackedStats(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/stats/outbound/tracked" + parameters));
        return this.dataHandler.fromJson(response, OutboundTrackedStats.class);
    }

    public OutboundOpenStats getOutboundOpenStats(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/stats/outbound/opens" + parameters));
        return this.dataHandler.fromJson(response, OutboundOpenStats.class);
    }

    public OutboundOpenPlatformStats getOutboundOpenPlatformStats(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/stats/outbound/opens/platforms" + parameters));
        return this.dataHandler.fromJson(response, OutboundOpenPlatformStats.class);
    }

    public HashMap getOutboundOpenClientStats(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/stats/outbound/opens/platforms" + parameters));
        return this.dataHandler.fromJson(response, HashMap.class);
    }

    public HashMap getOutboundOpenReadTimes(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/stats/outbound/opens/readTimes" + parameters));
        return this.dataHandler.fromJson(response, HashMap.class);
    }

    public OutboundClickStats getOutboundClickStats(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/stats/outbound/clicks" + parameters));
        return this.dataHandler.fromJson(response, OutboundClickStats.class);
    }

    public HashMap getOutboundClickBrowsersStats(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/stats/outbound/clicks/browserfamilies" + parameters));
        return this.dataHandler.fromJson(response, HashMap.class);
    }

    public OutboundClickPlatformStats getOutboundClickPlatformStats(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/stats/outbound/clicks/platforms" + parameters));
        return this.dataHandler.fromJson(response, OutboundClickPlatformStats.class);
    }

    public OutboundClickLocationStats getOutboundClickLocationStats(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/stats/outbound/clicks/location" + parameters));
        return this.dataHandler.fromJson(response, OutboundClickLocationStats.class);
    }

    public InboundRuleResponse createInboundRule(String rule) throws PostmarkException, IOException {
        InboundRule data = new InboundRule();
        data.setRule(rule);
        String response = this.execute(HttpClient.REQUEST_TYPES.POST, this.getEndpointUrl("/triggers/inboundRules/"), data);
        return this.dataHandler.fromJson(response, InboundRuleResponse.class);
    }

    public String deleteInboundRule(Integer id) throws PostmarkException, IOException {
        return this.execute(HttpClient.REQUEST_TYPES.DELETE, this.getEndpointUrl("/triggers/inboundRules/" + id));
    }

    public InboundRules getInboundRules(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/triggers/inboundRules/" + parameters));
        return this.dataHandler.fromJson(response, InboundRules.class);
    }

    public Webhooks getWebhooks() throws PostmarkException, IOException {
        return this.getWebhooks(Parameters.init());
    }

    public Webhooks getWebhooks(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/webhooks/" + parameters));
        return this.dataHandler.fromJson(response, Webhooks.class);
    }

    public Webhook getWebhook(Integer id) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/webhooks/" + id));
        return this.dataHandler.fromJson(response, Webhook.class);
    }

    public Webhook createWebhook(Webhook data) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.POST, this.getEndpointUrl("/webhooks/"), data);
        return this.dataHandler.fromJson(response, Webhook.class);
    }

    public Webhook setWebhook(Integer id, Webhook data) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.PUT, this.getEndpointUrl("/webhooks/" + id), data);
        return this.dataHandler.fromJson(response, Webhook.class);
    }

    public String deleteWebhook(Integer id) throws PostmarkException, IOException {
        return this.execute(HttpClient.REQUEST_TYPES.DELETE, this.getEndpointUrl("/webhooks/" + id));
    }

    public Suppressions getSuppressions(String messageStream) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/message-streams/") + messageStream + "/suppressions/" + "dump");
        return this.dataHandler.fromJson(response, Suppressions.class);
    }

    public Suppressions getSuppressions(String messageStream, Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/message-streams/") + messageStream + "/suppressions/" + "dump" + parameters);
        return this.dataHandler.fromJson(response, Suppressions.class);
    }

    public SuppressionStatuses createSuppressions(String messageStream, SuppressionEntries suppressions) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.POST, this.getEndpointUrl("/message-streams/") + messageStream + "/suppressions/", suppressions);
        return this.dataHandler.fromJson(response, SuppressionStatuses.class);
    }

    public SuppressionStatuses deleteSuppressions(String messageStream, SuppressionEntries suppressions) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.POST, this.getEndpointUrl("/message-streams/") + messageStream + "/suppressions/" + "delete", suppressions);
        return this.dataHandler.fromJson(response, SuppressionStatuses.class);
    }

    public MessageStreams getMessageStreams() throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/message-streams/"));
        return this.dataHandler.fromJson(response, MessageStreams.class);
    }

    public MessageStreams getMessageStreams(Parameters parameters) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/message-streams/") + parameters);
        return this.dataHandler.fromJson(response, MessageStreams.class);
    }

    public MessageStream getMessageStream(String messageStreamId) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.GET, this.getEndpointUrl("/message-streams/" + messageStreamId));
        return this.dataHandler.fromJson(response, MessageStream.class);
    }

    public MessageStream setMessageStream(String messageStreamId, MessageStream data) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.PATCH, this.getEndpointUrl("/message-streams/" + messageStreamId), data);
        return this.dataHandler.fromJson(response, MessageStream.class);
    }

    public MessageStream createMessageStream(MessageStream data) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.POST, this.getEndpointUrl("/message-streams/"), data);
        return this.dataHandler.fromJson(response, MessageStream.class);
    }

    public MessageStreamArchiveResponse archiveMessageStream(String messageStreamId) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.POST, this.getEndpointUrl("/message-streams/" + messageStreamId + "/archive"));
        return this.dataHandler.fromJson(response, MessageStreamArchiveResponse.class);
    }

    public MessageStreamUnarchiveResponse unarchiveMessageStream(String messageStreamId) throws PostmarkException, IOException {
        String response = this.execute(HttpClient.REQUEST_TYPES.POST, this.getEndpointUrl("/message-streams/" + messageStreamId + "/unarchive"));
        return this.dataHandler.fromJson(response, MessageStreamUnarchiveResponse.class);
    }
}

