/*
 * Decompiled with CFR 0.152.
 */
package com.postmarkapp.postmark.client;

import com.postmarkapp.postmark.client.HttpClient;
import com.postmarkapp.postmark.client.HttpClientErrorHandler;
import com.postmarkapp.postmark.client.data.parser.DataHandler;
import com.postmarkapp.postmark.client.exception.PostmarkException;
import java.io.IOException;
import java.util.Map;

public class HttpClientHandler {
    private final HttpClient httpClient;
    protected final DataHandler dataHandler = new DataHandler(false);
    private final HttpClientErrorHandler httpClientErrorHandler = new HttpClientErrorHandler(this.dataHandler);

    protected HttpClientHandler(Map<String, Object> headers) {
        this.httpClient = new HttpClient(headers);
    }

    protected HttpClientHandler(Map<String, Object> headers, boolean secureConnection) {
        this(headers);
        this.getHttpClient().setSecureConnection(secureConnection);
    }

    protected String execute(HttpClient.REQUEST_TYPES request_type, String url) throws PostmarkException, IOException {
        return this.execute(request_type, url, null);
    }

    protected String execute(HttpClient.REQUEST_TYPES request_type, String url, Object data) throws PostmarkException, IOException {
        HttpClient.ClientResponse response = this.httpClient.execute(request_type, url, this.dataHandler.toJson(data));
        if (response.getCode() == 200) {
            return response.getMessage();
        }
        throw this.httpClientErrorHandler.throwErrorBasedOnStatusCode(response.getCode(), response.getMessage());
    }

    public void setDebugMode() {
        this.dataHandler.setStrictMapper();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setConnectTimeoutSeconds(int connectTimeoutSeconds) {
        this.getHttpClient().setConnectTimeoutSeconds(connectTimeoutSeconds);
    }

    public void setReadTimeoutSeconds(int readTimeoutSeconds) {
        this.getHttpClient().setReadTimeoutSeconds(readTimeoutSeconds);
    }

    public void setSecureConnection(boolean secureConnection) {
        this.getHttpClient().setSecureConnection(secureConnection);
    }

    public DataHandler getDataHandler() {
        return this.dataHandler;
    }
}

