/*
 * Decompiled with CFR 0.152.
 */
package com.postmarkapp.postmark.client.data.model.message;

import com.postmarkapp.postmark.client.data.model.FileDetails;
import com.postmarkapp.postmark.client.data.model.message.Header;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BaseMessage {
    private String messageStream;
    private String from;
    private String to;
    private String cc;
    private String bcc;
    private String replyTo;
    private String subject;
    private String htmlBody;
    private String textBody;
    private String tag;
    private List<Header> headers;
    private List<Map<String, String>> attachments;

    public BaseMessage() {
        this.attachments = new ArrayList<Map<String, String>>();
    }

    public BaseMessage(String from, String to, String subject, String htmlBody) {
        this.from = from;
        this.to = to;
        this.subject = subject;
        this.htmlBody = htmlBody;
        this.attachments = new ArrayList<Map<String, String>>();
    }

    public BaseMessage(String from, String to, String subject, String htmlBody, String textBody) {
        this.from = from;
        this.to = to;
        this.subject = subject;
        this.htmlBody = htmlBody;
        this.textBody = textBody;
        this.attachments = new ArrayList<Map<String, String>>();
    }

    public BaseMessage(String from, String to, String subject, String htmlBody, String textBody, String messageStream) {
        this.from = from;
        this.to = to;
        this.subject = subject;
        this.htmlBody = htmlBody;
        this.textBody = textBody;
        this.messageStream = messageStream;
        this.attachments = new ArrayList<Map<String, String>>();
    }

    public String getMessageStream() {
        return this.messageStream;
    }

    public void setMessageStream(String messageStream) {
        this.messageStream = messageStream;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setFrom(String name, String address) {
        this.from = this.convertRecipient(name, address);
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setTo(Map<String, String> to) {
        this.to = this.convertRecipients(to);
    }

    public void setTo(List<String> to) {
        this.to = this.convertRecipients(to);
    }

    public String getCc() {
        return this.cc;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public void setCc(Map<String, String> cc) {
        this.cc = this.convertRecipients(cc);
    }

    public void setCc(List<String> cc) {
        this.cc = this.convertRecipients(cc);
    }

    public String getBcc() {
        return this.bcc;
    }

    public void setBcc(String bcc) {
        this.bcc = bcc;
    }

    public void setBcc(Map<String, String> bcc) {
        this.bcc = this.convertRecipients(bcc);
    }

    public void setBcc(List<String> bcc) {
        this.bcc = this.convertRecipients(bcc);
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getHtmlBody() {
        return this.htmlBody;
    }

    public void setHtmlBody(String htmlBody) {
        this.htmlBody = htmlBody;
    }

    public String getTextBody() {
        return this.textBody;
    }

    public void setTextBody(String textBody) {
        this.textBody = textBody;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<Header> headers) {
        this.headers = headers;
    }

    public void addHeader(String name, String value) {
        if (this.headers == null) {
            this.setHeaders(new ArrayList<Header>());
        }
        this.headers.add(new Header(name, value));
    }

    public void clearHeaders() {
        if (this.headers != null) {
            this.headers.clear();
        }
    }

    public List<Map<String, String>> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Map<String, String>> attachments) {
        this.attachments = attachments;
    }

    public void addAttachment(String path) throws IOException {
        this.addAttachment(FileDetails.getFileName(path), FileDetails.getFileContent(path), FileDetails.getFileContentType(path));
    }

    public void addAttachment(String path, String contentId) throws IOException {
        this.addAttachment(FileDetails.getFileName(path), FileDetails.getFileContent(path), FileDetails.getFileContentType(path), contentId);
    }

    public void addAttachment(String filename, String content, String contentType, String contentId) {
        this.addAttachment(filename, content.getBytes(), contentType, contentId);
    }

    public void addAttachment(String filename, String content, String contentType) {
        this.addAttachment(filename, content.getBytes(), contentType);
    }

    public void addAttachment(String name, byte[] content, String contentType) {
        HashMap<String, String> attachment = new HashMap<String, String>();
        attachment.put("Name", name);
        attachment.put("Content", Base64.getEncoder().encodeToString(content));
        attachment.put("ContentType", contentType);
        this.addAttachment(attachment);
    }

    public void addAttachment(String name, byte[] content, String contentType, String contentId) {
        HashMap<String, String> attachment = new HashMap<String, String>();
        attachment.put("Name", name);
        attachment.put("Content", Base64.getEncoder().encodeToString(content));
        attachment.put("ContentType", contentType);
        attachment.put("ContentId", contentId);
        this.addAttachment(attachment);
    }

    public void addAttachment(Map<String, String> attachment) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Map<String, String>>();
        }
        this.attachments.add(attachment);
    }

    public void addAttachments(List<Map<String, String>> attachments) {
        attachments.forEach(this::addAttachment);
    }

    private String convertRecipients(Map<String, String> recipients) {
        StringBuilder recipientsString = new StringBuilder();
        Iterator<Map.Entry<String, String>> entries = recipients.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, String> entry = entries.next();
            recipientsString.append(this.convertRecipient(entry.getKey(), entry.getValue()));
            if (!entries.hasNext()) continue;
            recipientsString.append(",");
        }
        return recipientsString.toString();
    }

    private String convertRecipients(List<String> recipients) {
        StringBuilder recipientsString = new StringBuilder();
        Iterator<String> entries = recipients.iterator();
        while (entries.hasNext()) {
            String entry = entries.next();
            recipientsString.append("\"").append(entry).append("\"");
            if (!entries.hasNext()) continue;
            recipientsString.append(",");
        }
        return recipientsString.toString();
    }

    private String convertRecipient(String name, String address) {
        StringBuilder recipientsString = new StringBuilder();
        return recipientsString.append("\"").append(name).append("\"").append("<").append(address).append(">").toString();
    }
}

