/*
 * Decompiled with CFR 0.152.
 */
package com.postmarkapp.postmark.client.data.model.templates;

import com.postmarkapp.postmark.client.data.model.FileDetails;
import com.postmarkapp.postmark.client.data.model.message.Header;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BaseTemplatedMessage {
    private Integer templateId;
    private String templateAlias;
    private Object templateModel;
    private String messageStream;
    private Boolean inlineCss;
    private String from;
    private String to;
    private String cc;
    private String bcc;
    private String replyTo;
    private String tag;
    private List<Header> headers;
    private List<Map<String, String>> attachments;

    public BaseTemplatedMessage() {
        this.setAttachments(new ArrayList<Map<String, String>>());
        this.setInlineCss(true);
        this.setTemplateModel(new HashMap());
    }

    public BaseTemplatedMessage(String from, String to) {
        this();
        this.from = from;
        this.to = to;
    }

    public BaseTemplatedMessage(String from, String to, String templateAlias) {
        this();
        this.from = from;
        this.to = to;
        this.templateAlias = templateAlias;
    }

    public BaseTemplatedMessage(String from, String to, String templateAlias, String messageStream) {
        this();
        this.from = from;
        this.to = to;
        this.templateAlias = templateAlias;
        this.messageStream = messageStream;
    }

    public BaseTemplatedMessage(String from, String to, Integer templateId) {
        this();
        this.from = from;
        this.to = to;
        this.templateId = templateId;
    }

    public BaseTemplatedMessage(String from, String to, Integer templateId, String messageStream) {
        this();
        this.from = from;
        this.to = to;
        this.templateId = templateId;
        this.messageStream = messageStream;
    }

    public String getMessageStream() {
        return this.messageStream;
    }

    public void setMessageStream(String messageStream) {
        this.messageStream = messageStream;
    }

    public String getTemplateAlias() {
        return this.templateAlias;
    }

    public void setTemplateAlias(String templateAlias) {
        this.templateAlias = templateAlias;
    }

    public Integer getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Integer templateId) {
        this.templateId = templateId;
    }

    public Object getTemplateModel() {
        return this.templateModel;
    }

    public void setTemplateModel(Object templateModel) {
        this.templateModel = templateModel;
    }

    public Boolean getInlineCss() {
        return this.inlineCss;
    }

    public void setInlineCss(Boolean inlineCss) {
        this.inlineCss = inlineCss;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setTo(Map<String, String> to) {
        this.to = this.convertRecipients(to);
    }

    public String getCc() {
        return this.cc;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public void setCc(Map<String, String> cc) {
        this.cc = this.convertRecipients(cc);
    }

    public String getBcc() {
        return this.bcc;
    }

    public void setBcc(String bcc) {
        this.bcc = bcc;
    }

    public void setBcc(Map<String, String> bcc) {
        this.bcc = this.convertRecipients(bcc);
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<Header> headers) {
        this.headers = headers;
    }

    public void addHeader(String name, String value) {
        if (this.headers == null) {
            this.setHeaders(new ArrayList<Header>());
        }
        this.headers.add(new Header(name, value));
    }

    public void clearHeaders() {
        if (this.headers != null) {
            this.headers.clear();
        }
    }

    public List<Map<String, String>> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Map<String, String>> attachments) {
        this.attachments = attachments;
    }

    public void addAttachment(String path) throws IOException {
        this.addAttachment(FileDetails.getFileName(path), FileDetails.getFileContent(path), FileDetails.getFileContentType(path));
    }

    public void addAttachment(String path, String contentId) throws IOException {
        this.addAttachment(FileDetails.getFileName(path), FileDetails.getFileContent(path), FileDetails.getFileContentType(path), contentId);
    }

    public void addAttachment(String filename, String content, String contentType, String contentId) {
        this.addAttachment(filename, content.getBytes(), contentType, contentId);
    }

    public void addAttachment(String filename, String content, String contentType) {
        this.addAttachment(filename, content.getBytes(), contentType);
    }

    public void addAttachment(String name, byte[] content, String contentType) {
        HashMap<String, String> attachment = new HashMap<String, String>();
        attachment.put("Name", name);
        attachment.put("Content", Base64.getEncoder().encodeToString(content));
        attachment.put("ContentType", contentType);
        this.addAttachment(attachment);
    }

    public void addAttachment(String name, byte[] content, String contentType, String contentId) {
        HashMap<String, String> attachment = new HashMap<String, String>();
        attachment.put("Name", name);
        attachment.put("Content", Base64.getEncoder().encodeToString(content));
        attachment.put("ContentType", contentType);
        attachment.put("ContentId", contentId);
        this.addAttachment(attachment);
    }

    public void addAttachment(Map<String, String> attachment) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Map<String, String>>();
        }
        this.attachments.add(attachment);
    }

    public void addAttachments(List<Map<String, String>> attachments) {
        attachments.forEach(this::addAttachment);
    }

    private String convertRecipients(Map<String, String> recipients) {
        StringBuilder recipientsString = new StringBuilder();
        Iterator<Map.Entry<String, String>> entries = recipients.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, String> entry = entries.next();
            recipientsString.append("\"").append(entry.getKey()).append("\"").append("<").append(entry.getValue()).append(">");
            if (!entries.hasNext()) continue;
            recipientsString.append(",");
        }
        return recipientsString.toString();
    }
}

