/*
 * Decompiled with CFR 0.152.
 */
package com.postmarkapp.postmark.client.data.parser;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.IOException;

public class DataHandler {
    private final ObjectMapper mapper = new ObjectMapper();

    public DataHandler() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
        this.setLiberalMapper();
    }

    public DataHandler(boolean isStrictMapper) {
        this();
        if (isStrictMapper) {
            this.setStrictMapper();
        } else {
            this.setLiberalMapper();
        }
    }

    public String toJson(Object data) throws IOException {
        return this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(data);
    }

    public <T> T fromJson(String response, Class<T> valueType) throws IOException {
        return (T)this.mapper.readValue(response, valueType);
    }

    public <T> T fromJson(String response, TypeReference<T> valueType) throws IOException {
        return (T)this.mapper.readValue(response, valueType);
    }

    public void setStrictMapper() {
        this.mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        this.mapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, true);
        this.mapper.configure(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES, true);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
    }

    public void setLiberalMapper() {
        this.mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        this.mapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        this.mapper.configure(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES, false);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

