/*
 * Decompiled with CFR 0.152.
 */
package com.postmarkapp.postmark;

import com.postmarkapp.postmark.client.AccountApiClient;
import com.postmarkapp.postmark.client.ApiClient;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class Postmark {
    private static final Logger LOGGER = Logger.getLogger(Postmark.class.getName());

    public static String libraryVersion() {
        Properties prop = new Properties();
        InputStream in = Postmark.class.getClassLoader().getResourceAsStream(".properties");
        try {
            prop.load(in);
        }
        catch (Exception e) {
            LOGGER.warning(e.toString());
        }
        return prop.getProperty("Version");
    }

    public static ApiClient getApiClient(String apiToken) {
        return new ApiClient(DEFAULTS.API_URL.value, Postmark.getHeadersWithAuth(DEFAULTS.SERVER_AUTH_HEADER, apiToken));
    }

    public static ApiClient getApiClient(String apiToken, Boolean secureConnection) {
        return new ApiClient(DEFAULTS.API_URL.value, Postmark.getHeadersWithAuth(DEFAULTS.SERVER_AUTH_HEADER, apiToken), secureConnection);
    }

    public static ApiClient getApiClient(String apiToken, Boolean secureConnection, String customApiUrl) {
        return new ApiClient(customApiUrl, Postmark.getHeadersWithAuth(DEFAULTS.SERVER_AUTH_HEADER, apiToken), secureConnection);
    }

    public static AccountApiClient getAccountApiClient(String apiToken) {
        return new AccountApiClient(DEFAULTS.API_URL.value, Postmark.getHeadersWithAuth(DEFAULTS.ACCOUNT_AUTH_HEADER, apiToken));
    }

    public static AccountApiClient getAccountApiClient(String apiToken, Boolean secureConnection) {
        return new AccountApiClient(DEFAULTS.API_URL.value, Postmark.getHeadersWithAuth(DEFAULTS.ACCOUNT_AUTH_HEADER, apiToken), secureConnection);
    }

    public static AccountApiClient getAccountApiClient(String apiToken, Boolean secureConnection, String customApiUrl) {
        return new AccountApiClient(customApiUrl, Postmark.getHeadersWithAuth(DEFAULTS.ACCOUNT_AUTH_HEADER, apiToken), secureConnection);
    }

    private Postmark() {
    }

    private static Map<String, Object> getHeadersWithAuth(DEFAULTS authType, String apiToken) {
        Map<String, Object> headers = DefaultHeaders.headers();
        headers.put(authType.value, apiToken);
        return headers;
    }

    public static class DefaultHeaders {
        public static Map<String, Object> headers() {
            HashMap<String, Object> headerValues = new HashMap<String, Object>();
            headerValues.put("User-Agent", "Postmark Java Library: " + Postmark.libraryVersion());
            headerValues.put("Accept", "application/json");
            headerValues.put("Content-Type", "application/json");
            return headerValues;
        }
    }

    public static enum DEFAULTS {
        API_URL("api.postmarkapp.com"),
        SERVER_AUTH_HEADER("X-Postmark-Server-Token"),
        ACCOUNT_AUTH_HEADER("X-Postmark-Account-Token");

        public final String value;

        private DEFAULTS(String value) {
            this.value = value;
        }
    }
}

