/*
 * Decompiled with CFR 0.152.
 */
package com.postmarkapp.postmark.client;

import java.io.IOException;
import java.util.Map;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class HttpClient {
    private final Map<String, Object> headers;
    private CloseableHttpClient client;
    private RequestConfig.Builder clientConfigBuilder;
    private boolean secureConnection = true;

    public HttpClient(Map<String, Object> headers, int connectTimeoutSeconds, int readTimeoutSeconds) {
        this.headers = headers;
        this.clientConfigBuilder = RequestConfig.custom().setConnectTimeout(Timeout.ofSeconds((long)connectTimeoutSeconds)).setConnectionRequestTimeout(Timeout.ofSeconds((long)connectTimeoutSeconds)).setConnectionKeepAlive((TimeValue)Timeout.ofSeconds((long)connectTimeoutSeconds)).setResponseTimeout(Timeout.ofSeconds((long)readTimeoutSeconds));
        this.client = this.buildClient();
    }

    public HttpClient(Map<String, Object> headers) {
        this(headers, DEFAULTS.CONNECT_TIMEOUT_SECONDS.value, DEFAULTS.READ_TIMEOUT_SECONDS.value);
    }

    public ClientResponse execute(REQUEST_TYPES request_type, String url) throws IOException {
        return this.execute(request_type, url, null);
    }

    public ClientResponse execute(REQUEST_TYPES requestType, String url, String data) throws IOException {
        ClassicHttpRequest request = this.createRequest(requestType, url, data);
        for (Map.Entry<String, Object> header : this.headers.entrySet()) {
            request.setHeader(header.getKey(), (Object)header.getValue().toString());
        }
        return (ClientResponse)this.client.execute(request, response -> {
            HttpEntity entity = response.getEntity();
            int code = response.getCode();
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            EntityUtils.consume((HttpEntity)entity);
            return new ClientResponse(code, body);
        });
    }

    private ClassicHttpRequest createRequest(REQUEST_TYPES requestType, String url, String data) {
        ClassicRequestBuilder requestBuilder = ClassicRequestBuilder.create((String)requestType.name()).setUri(this.getHttpUrl(url));
        if (data != null) {
            return requestBuilder.setEntity(data, ContentType.APPLICATION_JSON).build();
        }
        return requestBuilder.build();
    }

    public void setConnectTimeoutSeconds(int connectTimeoutSeconds) {
        this.clientConfigBuilder.setConnectTimeout(Timeout.ofSeconds((long)connectTimeoutSeconds));
        this.client = this.buildClient();
    }

    public void setReadTimeoutSeconds(int readTimeoutSeconds) {
        this.clientConfigBuilder.setResponseTimeout(Timeout.ofSeconds((long)readTimeoutSeconds));
        this.client = this.buildClient();
    }

    public void setSecureConnection(boolean secureConnection) {
        this.secureConnection = secureConnection;
    }

    private String getHttpUrl(String url) {
        String urlPrefix = this.secureConnection ? "https://" : "http://";
        return urlPrefix + url;
    }

    public CloseableHttpClient getClient() {
        return this.client;
    }

    private CloseableHttpClient buildClient() {
        return HttpClientBuilder.create().setDefaultRequestConfig(this.clientConfigBuilder.build()).build();
    }

    public static enum REQUEST_TYPES {
        POST,
        GET,
        PUT,
        PATCH,
        DELETE;

    }

    public class ClientResponse {
        private final int code;
        private final String message;

        public ClientResponse(int code, String message) {
            this.code = code;
            this.message = message;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static enum DEFAULTS {
        CONNECT_TIMEOUT_SECONDS(60),
        READ_TIMEOUT_SECONDS(60);

        public final int value;

        private DEFAULTS(int value) {
            this.value = value;
        }
    }
}

