/*
 * Decompiled with CFR 0.152.
 */
package com.postmarkapp.postmark.client;

import com.postmarkapp.postmark.client.data.model.PostmarkError;
import com.postmarkapp.postmark.client.data.parser.DataHandler;
import com.postmarkapp.postmark.client.exception.InternalServerException;
import com.postmarkapp.postmark.client.exception.InvalidAPIKeyException;
import com.postmarkapp.postmark.client.exception.InvalidMessageException;
import com.postmarkapp.postmark.client.exception.PostmarkHttpException;
import com.postmarkapp.postmark.client.exception.TimeoutException;
import com.postmarkapp.postmark.client.exception.UnknownException;
import java.io.IOException;

public class HttpClientErrorHandler {
    protected final DataHandler dataHandler;

    public HttpClientErrorHandler(DataHandler dataHandler) {
        this.dataHandler = dataHandler;
    }

    public PostmarkHttpException throwErrorBasedOnStatusCode(Integer statusCode, String message) throws IOException {
        switch (statusCode) {
            case 401: {
                return new InvalidAPIKeyException(this.postmarkErrorFromResponse(message), statusCode);
            }
            case 408: {
                return new TimeoutException(message, statusCode);
            }
            case 422: {
                return new InvalidMessageException(this.postmarkErrorFromResponse(message), statusCode);
            }
            case 500: {
                return new InternalServerException(message, statusCode);
            }
        }
        return new UnknownException(message, statusCode);
    }

    private PostmarkError postmarkErrorFromResponse(String message) throws IOException {
        return this.dataHandler.fromJson(message, PostmarkError.class);
    }
}

