/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.apidoc;

import com.power4j.fist.boot.apidoc.ApiTrait;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpMethod;
import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class ApiAccessRegistry
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiAccessRegistry.class);
    private final ApplicationContext applicationContext;
    private final MultiValuedMap<String, HttpMethod> pubAccess = new HashSetValuedHashMap(16);
    private final MultiValuedMap<String, HttpMethod> userAccess = new HashSetValuedHashMap(16);
    private final MultiValuedMap<String, HttpMethod> interAccess = new HashSetValuedHashMap(16);

    public void afterPropertiesSet() throws Exception {
        RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)this.applicationContext.getBean(RequestMappingHandlerMapping.class);
        mapping.getHandlerMethods().forEach((k, v) -> {
            Method method = v.getMethod();
            Class clazz = v.getBeanType();
            ApiAccessRegistry.findMostSpecificAnnotation(method, clazz, ApiTrait.class).ifPresent(apiTrait -> this.process((ApiTrait)apiTrait, (RequestMappingInfo)k));
        });
    }

    public MultiValuedMap<String, HttpMethod> getPubAccess() {
        return this.pubAccess;
    }

    public MultiValuedMap<String, HttpMethod> getUserAccess() {
        return this.userAccess;
    }

    public MultiValuedMap<String, HttpMethod> getInterAccess() {
        return this.interAccess;
    }

    private void process(ApiTrait apiTrait, RequestMappingInfo info) {
        MultiValuedMap<String, HttpMethod> entry = null;
        switch (apiTrait.access()) {
            case DEFAULT: {
                break;
            }
            case INTERNAL: {
                entry = this.interAccess;
                break;
            }
            case USER: {
                entry = this.userAccess;
                break;
            }
            case PUBLIC: {
                entry = this.pubAccess;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + apiTrait.access());
            }
        }
        if (Objects.nonNull(entry)) {
            Set patterns = info.getPatternValues();
            Set requestMethods = info.getMethodsCondition().getMethods();
            if (requestMethods.isEmpty()) {
                log.warn("empty request method on :{}", (Object)StringUtils.join((Iterable)patterns, (String)","));
                return;
            }
            Set methods = info.getMethodsCondition().getMethods().stream().map(m -> HttpMethod.valueOf((String)m.name())).collect(Collectors.toSet());
            for (String pattern : patterns) {
                if (log.isDebugEnabled()) {
                    log.debug("[access = {}] pattern = {},method = {}", new Object[]{apiTrait.access().name(), pattern, StringUtils.join(methods, (String)",")});
                }
                if (entry.containsKey((Object)pattern)) {
                    log.warn("path already exists: {}", (Object)pattern);
                }
                entry.putAll((Object)pattern, methods);
            }
        }
    }

    static <A extends Annotation> Optional<A> findMostSpecificAnnotation(Method method, Class<?> targetClass, Class<A> annotationClass) {
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, targetClass);
        Annotation annotation = AnnotationUtils.findAnnotation((Method)specificMethod, annotationClass);
        if (annotation != null) {
            if (log.isDebugEnabled()) {
                log.debug("{} found on specific method: {}", (Object)annotation, (Object)specificMethod);
            }
            return Optional.of(annotation);
        }
        if (specificMethod != method && (annotation = AnnotationUtils.findAnnotation((Method)method, annotationClass)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("{} found on: {}", (Object)annotation, (Object)method);
            }
            return Optional.of(annotation);
        }
        annotation = AnnotationUtils.findAnnotation(specificMethod.getDeclaringClass(), annotationClass);
        if (annotation != null) {
            if (log.isDebugEnabled()) {
                log.debug("{} found on: {}", (Object)annotation, (Object)specificMethod.getDeclaringClass().getName());
            }
            return Optional.of(annotation);
        }
        return Optional.empty();
    }

    @Generated
    public ApiAccessRegistry(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

