/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.apidoc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.power4j.fist.boot.apidoc.ApiModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class DocParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocParser.class);
    private static final String SWAGGER_EXTENSION_KEY = "extensions";
    private static final String KEY_PATHS = "paths";
    private static final String KEY_OPERATION_ID = "operationId";
    private static final String KEY_TAGS = "tags";
    private static final String KEY_SUMMARY = "summary";
    private static final String KEY_LEVEL = "level";
    private static final String KEY_RESOURCE_ID = "resourceId";
    private static final String KEY_CODE = "code";
    private static final String KEY_EXPOSE = "expose";
    private static final String KEY_SIGN = "sign";
    private final ObjectMapper objectMapper;

    public DocParser(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public DocParser() {
        this(new ObjectMapper());
    }

    private List<ApiModel> parseFromJson(@Nullable String json) throws JsonProcessingException {
        if (Objects.isNull(json) || json.isEmpty()) {
            return Collections.emptyList();
        }
        JsonNode root = this.objectMapper.readTree(json);
        Iterator pathIter = Optional.ofNullable(root.get(KEY_PATHS)).map(JsonNode::fields).orElse(null);
        if (Objects.isNull(pathIter)) {
            return Collections.emptyList();
        }
        ArrayList<ApiModel> permissionInfos = new ArrayList<ApiModel>(16);
        pathIter.forEachRemaining(path -> ((JsonNode)path.getValue()).fields().forEachRemaining(kv -> {
            ApiModel apiModel = new ApiModel();
            apiModel.setPath((String)path.getKey());
            apiModel.setMethod(((String)kv.getKey()).toLowerCase());
            Optional<JsonNode> methodInfo = Optional.ofNullable((JsonNode)kv.getValue());
            methodInfo.ifPresent(o -> {
                apiModel.setAction(Optional.ofNullable(o.get(KEY_OPERATION_ID)).map(JsonNode::asText).orElse(""));
                apiModel.setDocTags(Optional.ofNullable(o.get(KEY_TAGS)).map(this::readStrArray).orElse(null));
                apiModel.setDescription(Optional.ofNullable(o.get(KEY_SUMMARY)).map(JsonNode::asText).orElse(""));
            });
            Optional<JsonNode> secureDetails = methodInfo.map(o -> o.get("x-secure-api-details"));
            if (secureDetails.isEmpty()) {
                secureDetails = methodInfo.map(o -> o.get(SWAGGER_EXTENSION_KEY)).map(o -> o.get("x-secure-api-details"));
            }
            if (secureDetails.isEmpty()) {
                log.info("\u5ffd\u7565\u6ce8\u518c {} {}", kv.getKey(), path.getKey());
            } else {
                apiModel.setLevel(secureDetails.map(o -> o.get(KEY_LEVEL)).map(JsonNode::asText).orElse(null));
                apiModel.setResourceId(secureDetails.map(o -> o.get(KEY_RESOURCE_ID)).map(JsonNode::asText).orElse(null));
                apiModel.setCode(secureDetails.map(o -> o.get(KEY_CODE)).map(JsonNode::asText).orElse(""));
                apiModel.setExpose(secureDetails.map(o -> o.get(KEY_EXPOSE)).map(JsonNode::asText).orElse(null));
                apiModel.setSign(secureDetails.map(o -> o.get(KEY_SIGN)).map(JsonNode::asBoolean).orElse(false));
                permissionInfos.add(apiModel);
            }
        }));
        return permissionInfos;
    }

    protected List<JsonNode> readArray(JsonNode node) {
        if (!node.isArray()) {
            return Collections.emptyList();
        }
        ArrayList<JsonNode> list = new ArrayList<JsonNode>(8);
        for (JsonNode c : node) {
            list.add(c);
        }
        return list;
    }

    protected List<String> readStrArray(JsonNode node) {
        return this.readArray(node).stream().map(JsonNode::asText).collect(Collectors.toList());
    }
}

