/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.apidoc;

import com.power4j.fist.boot.apidoc.ApiDetails;
import com.power4j.fist.boot.apidoc.ApiTrait;
import com.power4j.fist.boot.apidoc.ResourceDescribe;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DocUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocUtil.class);

    public static Optional<ApiDetails> buildApiDetails(ResourceDescribe describe, Supplier<ApiTrait> supplier) {
        ApiTrait apiTrait = supplier.get();
        if (Objects.nonNull(apiTrait)) {
            ApiDetails details = DocUtil.createDetails(apiTrait);
            if (StringUtils.isEmpty((CharSequence)details.getResourceName())) {
                details.setResourceName(describe.getResourceName());
            }
            return Optional.of(details);
        }
        return Optional.empty();
    }

    public static ApiDetails createDetails(ApiTrait apiTrait) {
        ApiDetails apiDetails = new ApiDetails();
        apiDetails.setResourceId(StringUtils.trimToNull((String)apiTrait.resourceId()));
        apiDetails.setCode(StringUtils.trimToNull((String)apiTrait.code()));
        apiDetails.setLevel(apiTrait.level().getValue());
        apiDetails.setExpose(apiTrait.access().getValue());
        apiDetails.setSign(apiTrait.sign());
        return apiDetails;
    }

    @Generated
    private DocUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

