/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.apidoc;

import com.power4j.fist.boot.apidoc.ResourceDescribe;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.lang.Nullable;

public class HandlerMethodResource
implements ResourceDescribe {
    private Class<?> clazz;
    private String methodName;
    @Nullable
    private List<Class<?>> parameterTypes;
    private Class<?> returnType;

    @Override
    public String getResourceName() {
        return String.format("%s.%s.%s", this.clazz.getSimpleName(), this.methodName, this.getResourceSign());
    }

    @Override
    public String getResourceSign() {
        String context = this.buildMethodSignature();
        return DigestUtils.sha1Hex((String)context).toLowerCase();
    }

    private String buildMethodSignature() {
        Validate.notNull((Object)this.methodName);
        Validate.notNull(this.returnType);
        StringBuilder builder = new StringBuilder();
        builder.append("(").append(this.clazz.getSimpleName()).append(")");
        builder.append(this.methodName);
        builder.append("(");
        if (Objects.nonNull(this.parameterTypes)) {
            int parameterIndex = 0;
            for (Class<?> parameterType : this.parameterTypes) {
                if (parameterIndex++ > 0) {
                    builder.append(",");
                }
                builder.append(parameterType.getSimpleName());
            }
        }
        builder.append(")");
        return builder.toString();
    }

    @Generated
    HandlerMethodResource(Class<?> clazz, String methodName, @Nullable List<Class<?>> parameterTypes, Class<?> returnType) {
        this.clazz = clazz;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
    }

    @Generated
    public static HandlerMethodResourceBuilder builder() {
        return new HandlerMethodResourceBuilder();
    }

    @Generated
    public Class<?> getClazz() {
        return this.clazz;
    }

    @Generated
    public String getMethodName() {
        return this.methodName;
    }

    @Nullable
    @Generated
    public List<Class<?>> getParameterTypes() {
        return this.parameterTypes;
    }

    @Generated
    public Class<?> getReturnType() {
        return this.returnType;
    }

    @Generated
    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Generated
    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Generated
    public void setParameterTypes(@Nullable List<Class<?>> parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    @Generated
    public void setReturnType(Class<?> returnType) {
        this.returnType = returnType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HandlerMethodResource)) {
            return false;
        }
        HandlerMethodResource other = (HandlerMethodResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<?> this$clazz = this.getClazz();
        Class<?> other$clazz = other.getClazz();
        if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
            return false;
        }
        String this$methodName = this.getMethodName();
        String other$methodName = other.getMethodName();
        if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
            return false;
        }
        List<Class<?>> this$parameterTypes = this.getParameterTypes();
        List<Class<?>> other$parameterTypes = other.getParameterTypes();
        if (this$parameterTypes == null ? other$parameterTypes != null : !((Object)this$parameterTypes).equals(other$parameterTypes)) {
            return false;
        }
        Class<?> this$returnType = this.getReturnType();
        Class<?> other$returnType = other.getReturnType();
        return !(this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HandlerMethodResource;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $clazz = this.getClazz();
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        String $methodName = this.getMethodName();
        result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
        List<Class<?>> $parameterTypes = this.getParameterTypes();
        result = result * 59 + ($parameterTypes == null ? 43 : ((Object)$parameterTypes).hashCode());
        Class<?> $returnType = this.getReturnType();
        result = result * 59 + ($returnType == null ? 43 : $returnType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HandlerMethodResource(clazz=" + this.getClazz() + ", methodName=" + this.getMethodName() + ", parameterTypes=" + this.getParameterTypes() + ", returnType=" + this.getReturnType() + ")";
    }

    @Generated
    public static class HandlerMethodResourceBuilder {
        @Generated
        private Class<?> clazz;
        @Generated
        private String methodName;
        @Generated
        private List<Class<?>> parameterTypes;
        @Generated
        private Class<?> returnType;

        @Generated
        HandlerMethodResourceBuilder() {
        }

        @Generated
        public HandlerMethodResourceBuilder clazz(Class<?> clazz) {
            this.clazz = clazz;
            return this;
        }

        @Generated
        public HandlerMethodResourceBuilder methodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        @Generated
        public HandlerMethodResourceBuilder parameterTypes(@Nullable List<Class<?>> parameterTypes) {
            this.parameterTypes = parameterTypes;
            return this;
        }

        @Generated
        public HandlerMethodResourceBuilder returnType(Class<?> returnType) {
            this.returnType = returnType;
            return this;
        }

        @Generated
        public HandlerMethodResource build() {
            return new HandlerMethodResource(this.clazz, this.methodName, this.parameterTypes, this.returnType);
        }

        @Generated
        public String toString() {
            return "HandlerMethodResource.HandlerMethodResourceBuilder(clazz=" + this.clazz + ", methodName=" + this.methodName + ", parameterTypes=" + this.parameterTypes + ", returnType=" + this.returnType + ")";
        }
    }
}

