/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.apidoc;

import com.power4j.fist.boot.apidoc.ResourceDescribe;
import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.http.HttpMethod;

public class RestResource
implements ResourceDescribe {
    private String name;
    private HttpMethod method;
    private String requestMappingPattern;

    @Override
    public String getResourceSign() {
        Validate.notNull((Object)this.getMethod());
        Validate.notNull((Object)this.getRequestMappingPattern());
        String context = this.getMethod().name().toLowerCase() + "@" + this.getRequestMappingPattern();
        String hi = DigestUtils.sha1Hex((String)context);
        String lo = this.u32Hex(this.crc32(context.getBytes(StandardCharsets.UTF_8)));
        return (hi.substring(0, 8) + "-" + lo).toLowerCase();
    }

    @Override
    public String getResourceName() {
        return String.format("%s.%s.%s", this.name, this.getMethod().name().toLowerCase(), this.getResourceSign());
    }

    long crc32(byte[] data) {
        CRC32 crc32 = new CRC32();
        crc32.update(data);
        return crc32.getValue();
    }

    String u32Hex(long value) {
        return StringUtils.leftPad((String)Long.toHexString(value), (int)8);
    }

    @Generated
    RestResource(String name, HttpMethod method, String requestMappingPattern) {
        this.name = name;
        this.method = method;
        this.requestMappingPattern = requestMappingPattern;
    }

    @Generated
    public static RestResourceBuilder builder() {
        return new RestResourceBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public HttpMethod getMethod() {
        return this.method;
    }

    @Generated
    public String getRequestMappingPattern() {
        return this.requestMappingPattern;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    @Generated
    public void setRequestMappingPattern(String requestMappingPattern) {
        this.requestMappingPattern = requestMappingPattern;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestResource)) {
            return false;
        }
        RestResource other = (RestResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        HttpMethod this$method = this.getMethod();
        HttpMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$requestMappingPattern = this.getRequestMappingPattern();
        String other$requestMappingPattern = other.getRequestMappingPattern();
        return !(this$requestMappingPattern == null ? other$requestMappingPattern != null : !this$requestMappingPattern.equals(other$requestMappingPattern));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RestResource;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        HttpMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $requestMappingPattern = this.getRequestMappingPattern();
        result = result * 59 + ($requestMappingPattern == null ? 43 : $requestMappingPattern.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RestResource(name=" + this.getName() + ", method=" + this.getMethod() + ", requestMappingPattern=" + this.getRequestMappingPattern() + ")";
    }

    @Generated
    public static class RestResourceBuilder {
        @Generated
        private String name;
        @Generated
        private HttpMethod method;
        @Generated
        private String requestMappingPattern;

        @Generated
        RestResourceBuilder() {
        }

        @Generated
        public RestResourceBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public RestResourceBuilder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        @Generated
        public RestResourceBuilder requestMappingPattern(String requestMappingPattern) {
            this.requestMappingPattern = requestMappingPattern;
            return this;
        }

        @Generated
        public RestResource build() {
            return new RestResource(this.name, this.method, this.requestMappingPattern);
        }

        @Generated
        public String toString() {
            return "RestResource.RestResourceBuilder(name=" + this.name + ", method=" + this.method + ", requestMappingPattern=" + this.requestMappingPattern + ")";
        }
    }
}

