/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.apidoc.springdoc.extension;

import com.power4j.fist.boot.apidoc.ApiDetails;
import com.power4j.fist.boot.apidoc.ApiTrait;
import com.power4j.fist.boot.apidoc.DocUtil;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.Operation;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.customizers.GlobalOperationCustomizer;
import org.springframework.web.method.HandlerMethod;

public class ApiTraitOperationCustomizer
implements GlobalOperationCustomizer {
    public Operation customize(Operation operation, HandlerMethod handlerMethod) {
        Optional.ofNullable((ApiTrait)handlerMethod.getMethodAnnotation(ApiTrait.class)).ifPresent(apiTrait -> {
            ApiDetails details = DocUtil.createDetails(apiTrait);
            operation.addExtension("x-secure-api-details", (Object)details);
            String tip = String.format("\u5c42\u7ea7:%s | \u6743\u9650\u7801:%s | \u8bbf\u95ee\u7c7b\u578b:%s", apiTrait.level().name(), apiTrait.code(), apiTrait.access().name());
            String desc = operation.getDescription();
            if (StringUtils.isNotEmpty((CharSequence)desc)) {
                operation.description(String.format("%s ( %s )", desc, tip));
            } else {
                operation.description(tip);
            }
        });
        return operation;
    }

    protected Optional<Tag> getDocTag(HandlerMethod handlerMethod) {
        Tag tag = (Tag)handlerMethod.getMethodAnnotation(Tag.class);
        if (Objects.isNull(tag)) {
            tag = handlerMethod.getBeanType().getAnnotation(Tag.class);
        }
        return Optional.ofNullable(tag);
    }
}

