/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.apidoc.swagger.plugin;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.power4j.fist.boot.apidoc.ApiDetails;
import com.power4j.fist.boot.apidoc.ApiTrait;
import com.power4j.fist.boot.apidoc.DocUtil;
import java.util.Collections;
import java.util.Map;
import springfox.documentation.service.ObjectVendorExtension;
import springfox.documentation.service.StringVendorExtension;
import springfox.documentation.service.VendorExtension;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

public class ApiTraitOperationPlugin
implements OperationBuilderPlugin {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final TypeReference<Map<String, Object>> MAP_TYPE = new TypeReference<Map<String, Object>>(){};

    public void apply(OperationContext context) {
        context.findAnnotation(ApiTrait.class).map(DocUtil::createDetails).map(this::toObjectVendorExtension).ifPresent(extension -> context.operationBuilder().extensions(Collections.singletonList(extension)));
    }

    public boolean supports(DocumentationType documentationType) {
        return SwaggerPluginSupport.pluginDoesApply((DocumentationType)documentationType);
    }

    private ObjectVendorExtension toObjectVendorExtension(ApiDetails details) {
        ObjectVendorExtension extension = new ObjectVendorExtension("x-secure-api-details");
        Map props = (Map)MAPPER.convertValue((Object)details, this.MAP_TYPE);
        props.forEach((k, v) -> extension.addProperty((VendorExtension)new StringVendorExtension(k, v.toString())));
        return extension;
    }
}

