/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.autoconfigure.apidoc;

import com.power4j.fist.boot.apidoc.springdoc.extension.ApiTraitOperationCustomizer;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import org.springdoc.core.configuration.SpringDocConfiguration;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={SpringDocConfiguration.class})
public class SpringDocAutoConfiguration {
    private static final String SCHEME_INNER_AUTH = "inner_auth";

    @Bean
    public OperationCustomizer apiTraitOperationCustomizer() {
        return new ApiTraitOperationCustomizer();
    }

    @Bean
    public OpenAPI openApi() {
        return new OpenAPI().components(new Components().addSecuritySchemes(SCHEME_INNER_AUTH, this.apiKeyInnerAuthScheme())).addSecurityItem(new SecurityRequirement().addList(SCHEME_INNER_AUTH));
    }

    private SecurityScheme oAuthScheme() {
        return new SecurityScheme().type(SecurityScheme.Type.OAUTH2).description("This API uses OAuth 2 with the implicit grant flow. [More info](https://api.example.com/docs/auth)").flows(new OAuthFlows().implicit(new OAuthFlow().authorizationUrl("https://api.example.com/oauth2/authorize").scopes(new Scopes().addString("read_pets", "read your pets").addString("write_pets", "modify pets in your account"))));
    }

    private SecurityScheme apiKeyInnerAuthScheme() {
        return new SecurityScheme().type(SecurityScheme.Type.APIKEY).in(SecurityScheme.In.HEADER).name("X-USER-IN");
    }

    private SecurityScheme basicScheme() {
        return new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("basic");
    }
}

