/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.fist.boot.autoconfigure.apidoc;

import com.power4j.fist.boot.apidoc.swagger.plugin.ApiTraitOperationPlugin;
import io.swagger.v3.oas.annotations.Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.oas.configuration.OpenApiDocumentationConfiguration;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;

@AutoConfiguration
@ConditionalOnClass(value={OpenApiDocumentationConfiguration.class})
public class SwaggerDocAutoConfiguration {
    private static final String SECURITY_REFERENCE_NAME = "X-USER-IN";

    @Bean
    public OperationBuilderPlugin apiTraitOperationPlugin() {
        return new ApiTraitOperationPlugin();
    }

    @Bean
    public Docket docket() {
        return new Docket(DocumentationType.OAS_30).apiInfo(this.apiInfo()).enable(true).securitySchemes(this.apiKeyList()).securityContexts(this.securityContexts()).select().apis(RequestHandlerSelectors.withMethodAnnotation(Operation.class)).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title("FIST \u63a5\u53e3\u6587\u6863").contact(new Contact("power4j", "https://github.com/power4j", "amNsYXp6QG91dGxvb2suY29t")).version("1.0").build();
    }

    private List<SecurityScheme> apiKeyList() {
        ApiKey apiKey = new ApiKey(SECURITY_REFERENCE_NAME, SECURITY_REFERENCE_NAME, "header");
        return Collections.singletonList(apiKey);
    }

    private List<SecurityContext> securityContexts() {
        SecurityContext securityContext = SecurityContext.builder().securityReferences(this.defaultAuth()).operationSelector(c -> true).build();
        return Collections.singletonList(securityContext);
    }

    private List<SecurityReference> defaultAuth() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
        ArrayList<SecurityReference> securityReferenceList = new ArrayList<SecurityReference>();
        securityReferenceList.add(new SecurityReference(SECURITY_REFERENCE_NAME, authorizationScopes));
        return securityReferenceList;
    }
}

